/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.data.craft.HumidityControl;
import com.teamtea.eclipticseasons.api.data.misc.ESSortInfo;
import com.teamtea.eclipticseasons.common.block.base.SimpleEntityBlock;
import com.teamtea.eclipticseasons.common.block.blockentity.BlockInCopperGrateBlockEntity;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.WeatheringCopperGrateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockInCopperGrateBlock
extends WeatheringCopperGrateBlock
implements EntityBlock {
    public BlockInCopperGrateBlock(WeatheringCopperGrateBlock weatherState, BlockBehaviour.Properties properties) {
        super(weatherState.getAge(), properties);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return BlockRegistry.getOriginalCopperGrateBlock((Block)this).asItem().getDefaultInstance();
    }

    public static boolean validItemAndBlock(Level level, ItemStack stack, BlockState state) {
        Pair<BlockItem, HumidityControl> match = BlockInCopperGrateBlock.getItemMatch(level, stack);
        return match != null && BlockRegistry.getCopperGrateBlockChange(state.getBlock()) != null;
    }

    public static Pair<BlockItem, HumidityControl> getItemMatch(Level level, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            for (HumidityControl humidityControl : ESSortInfo.sorted2(level.registryAccess().registryOrThrow(ESRegistries.HUMIDITY_CONTROL))) {
                if (!humidityControl.ingredient().test(stack)) continue;
                return Pair.of((Object)blockItem, (Object)humidityControl);
            }
        }
        return null;
    }

    public static ItemInteractionResult getItemInteractionResult(ItemStack stack, Level level, BlockPos pos, BlockState state) {
        Pair<BlockItem, HumidityControl> itemMatch = BlockInCopperGrateBlock.getItemMatch(level, stack);
        if (itemMatch != null) {
            BlockInCopperGrateBlock.setNewBlock(level, pos, state, (BlockItem)itemMatch.getFirst());
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return null;
    }

    public static void setNewBlock(Level level, BlockPos pos, BlockState state, BlockItem input) {
        Block copperGrateBlockChange;
        if (!level.isClientSide() && (copperGrateBlockChange = BlockRegistry.getCopperGrateBlockChange(state.getBlock())) != Blocks.AIR) {
            level.setBlockAndUpdate(pos, copperGrateBlockChange.withPropertiesOf(state));
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BlockInCopperGrateBlockEntity) {
                BlockInCopperGrateBlockEntity blockEntity2 = (BlockInCopperGrateBlockEntity)blockEntity;
                blockEntity2.setInnerBlock(input.getBlock());
            }
        }
    }

    @Nullable
    public static ItemInteractionResult getItemInteractionResult(ItemStack stack, Level level, BlockPos pos) {
        Pair<BlockItem, HumidityControl> itemMatch = BlockInCopperGrateBlock.getItemMatch(level, stack);
        if (itemMatch != null) {
            BlockEntity blockEntity;
            if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof BlockInCopperGrateBlockEntity) {
                BlockInCopperGrateBlockEntity blockEntity2 = (BlockInCopperGrateBlockEntity)blockEntity;
                blockEntity2.setInnerBlock(((BlockItem)itemMatch.getFirst()).getBlock());
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (stack.isEmpty()) {
            BlockEntity blockEntity;
            if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof BlockInCopperGrateBlockEntity) {
                BlockInCopperGrateBlockEntity blockEntity3 = (BlockInCopperGrateBlockEntity)blockEntity;
                blockEntity3.setInnerBlock(null);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return null;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        ItemInteractionResult result = BlockInCopperGrateBlock.getItemInteractionResult(stack, level, pos);
        if (result == ItemInteractionResult.sidedSuccess((boolean)level.isClientSide()) && !player.isCreative()) {
            stack.shrink(1);
        }
        if (result != null) {
            return result;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.block_in_copper_grate_block_entity_type.get()).create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level worldIn, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return !worldIn.isClientSide ? SimpleEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)BlockEntityRegistry.block_in_copper_grate_block_entity_type.get(), BlockInCopperGrateBlockEntity::tick) : null;
    }

    protected boolean isRandomlyTicking(@NotNull BlockState state) {
        return state.getBlock() != BlockRegistry.block_in_oxidized_copper_grate_block.get();
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockState blockState = super.playerWillDestroy(level, pos, state, player);
        if (!level.isClientSide() && player.isCreative()) {
            BlockInCopperGrateBlockEntity.removeBlock(level, pos);
        }
        return blockState;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!(movedByPiston || level.isClientSide() || newState.is((Block)this))) {
            BlockInCopperGrateBlockEntity.popResource(level, pos);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }
}

