/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block;

import com.mojang.serialization.MapCodec;
import com.teamtea.eclipticseasons.common.block.base.WallPlacedBlock;
import com.teamtea.eclipticseasons.common.block.blockentity.CalendarBlockEntity;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CalendarBlock
extends WallPlacedBlock {
    protected static final VoxelShape shape_N = Shapes.box((double)0.1875, (double)0.0, (double)0.75, (double)0.8125, (double)0.875, (double)1.0);
    protected static final VoxelShape shape_S = Shapes.box((double)0.1875, (double)0.0, (double)0.0, (double)0.8125, (double)0.875, (double)0.25);
    protected static final VoxelShape shape_W = Shapes.box((double)0.75, (double)0.0, (double)0.1875, (double)1.0, (double)0.875, (double)0.8125);
    protected static final VoxelShape shape_E = Shapes.box((double)0.0, (double)0.0, (double)0.1875, (double)0.25, (double)0.875, (double)0.8125);
    protected static final VoxelShape[] shapes = new VoxelShape[]{shape_S, shape_W, shape_N, shape_E};
    public static final EnumProperty<DisplayMode> MODE = EnumProperty.create((String)"display_mode", DisplayMode.class);

    public CalendarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(MODE, (Comparable)((Object)DisplayMode.NORMAL)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CalendarBlock.simpleCodec(CalendarBlock::new);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{MODE}));
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return shapes[((Direction)pState.getValue((Property)FACING)).get2DDataValue()];
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)BlockEntityRegistry.calendar_entity_type.get()).create(pPos, pState);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity cycle2;
        if (player.isShiftKeyDown()) {
            if (level instanceof ServerLevel) {
                BlockState cycle2 = (BlockState)state.cycle(MODE);
                level.setBlock(pos, cycle2, 2);
                player.displayClientMessage((Component)Component.translatable((String)"info.eclipticseasons.calendar.model", (Object[])new Object[]{Component.translatable((String)("info.eclipticseasons.calendar.model." + ((DisplayMode)((Object)cycle2.getValue(MODE))).getSerializedName()))}), true);
            }
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        if (level.isClientSide() && (cycle2 = level.getBlockEntity(pos)) instanceof CalendarBlockEntity) {
            CalendarBlockEntity calendarBlockEntity = (CalendarBlockEntity)cycle2;
            Holder<Biome> cropBiome = CropGrowthHandler.getCropBiome((LevelAccessor)level, pos);
            calendarBlockEntity.setBiome(cropBiome);
            if (!calendarBlockEntity.isInit()) {
                calendarBlockEntity.setInit(true);
            }
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public static enum DisplayMode implements StringRepresentable
    {
        NORMAL,
        YEAR,
        NEXT;


        @NotNull
        public String getSerializedName() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

