/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block;

import com.mojang.serialization.MapCodec;
import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.common.block.base.SimpleHorizontalEntityBlock;
import com.teamtea.eclipticseasons.common.block.blockentity.WindChimesBlockEntity;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import com.teamtea.eclipticseasons.common.registry.SoundEventsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WindChimesBlock
extends SimpleHorizontalEntityBlock {
    public static final VoxelShape BOX_P = Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    public static final VoxelShape BOX_0 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    public static final VoxelShape BOX_B = Block.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0);

    public WindChimesBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return WindChimesBlock.simpleCodec(WindChimesBlock::new);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = Direction.UP;
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
    }

    protected BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pDirection == Direction.UP && pNeighborState.isAir()) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)BlockEntityRegistry.wind_chimes_entity_type.get()).create(pPos, pState);
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Block block = state.getBlock();
        if (block == BlockRegistry.wind_chimes.get()) {
            return BOX_0;
        }
        if (block == BlockRegistry.bamboo_wind_chimes.get()) {
            return BOX_B;
        }
        return BOX_P;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Vec3 deltaMovement = livingEntity.getDeltaMovement();
            Direction facing = (Direction)state.getValue((Property)FACING);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof WindChimesBlockEntity) {
                WindChimesBlockEntity windChimesBlockEntity = (WindChimesBlockEntity)blockEntity;
                if (level.isClientSide()) {
                    windChimesBlockEntity.setShaking(true);
                }
            }
        }
    }

    public static SoundEvent getSoundEvent(Block block) {
        return block == BlockRegistry.paper_wind_chimes.get() ? SoundEventsRegistry.paper_wind_chimes : (block == BlockRegistry.bamboo_wind_chimes.get() ? SoundEventsRegistry.bamboo_wind_chimes : SoundEventsRegistry.wind_chimes);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity;
        super.randomTick(state, level, pos, random);
        if (EclipticSeasonsApi.getInstance().isRainingOrSnowing((Level)level, pos) && (blockEntity = level.getBlockEntity(pos)) instanceof WindChimesBlockEntity) {
            WindChimesBlockEntity windChimesBlockEntity = (WindChimesBlockEntity)blockEntity;
            windChimesBlockEntity.setShaking(true);
        }
    }
}

