/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block.base;

import com.teamtea.eclipticseasons.common.block.base.SimpleEntityBlock;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class SimpleHorizontalEntityBlock
extends SimpleEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public SimpleHorizontalEntityBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING}));
    }

    public static int getRotateYByFacing(BlockState state) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case EAST: {
                return 90;
            }
            case SOUTH: {
                return 180;
            }
            case WEST: {
                return 270;
            }
        }
        return 0;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }
}

