/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block.base;

import com.teamtea.eclipticseasons.common.block.base.SimpleHorizontalEntityBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class WallPlacedBlock
extends SimpleHorizontalEntityBlock {
    public WallPlacedBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = ((Direction)state.getValue((Property)FACING)).getOpposite();
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
    }

    protected BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pDirection == ((Direction)pState.getValue((Property)FACING)).getOpposite() && pNeighborState.isAir()) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction clickedFace = context.getClickedFace();
        if (!Direction.Plane.HORIZONTAL.test(clickedFace)) {
            clickedFace = context.getHorizontalDirection().getOpposite();
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)clickedFace);
    }
}

