/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block.blockentity;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.data.craft.HumidityControl;
import com.teamtea.eclipticseasons.common.block.BlockInCopperGrateBlock;
import com.teamtea.eclipticseasons.common.block.blockentity.HumidityControlBlockEntity;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class BlockInCopperGrateBlockEntity
extends HumidityControlBlockEntity {
    protected Block innerBlock = null;
    protected final GrateItemStackHandler itemStackHandler = new GrateItemStackHandler();

    public BlockInCopperGrateBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.block_in_copper_grate_block_entity_type.get(), pos, state);
    }

    public static void popResource(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BlockInCopperGrateBlockEntity) {
            BlockInCopperGrateBlockEntity blockEntity2 = (BlockInCopperGrateBlockEntity)blockEntity;
            blockEntity2.popBlock(level, pos);
        }
    }

    public static void removeBlock(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BlockInCopperGrateBlockEntity) {
            BlockInCopperGrateBlockEntity blockEntity2 = (BlockInCopperGrateBlockEntity)blockEntity;
            blockEntity2.setInnerBlock(null);
        }
    }

    protected void popBlock(Level level, BlockPos pos) {
        if (this.canBlockObtained(level)) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)this.getInnerBlock().asItem().getDefaultInstance());
        }
    }

    private boolean canBlockObtained(Level level) {
        return level != null && !level.isClientSide() && this.getInnerBlock() != Blocks.AIR && (this.humidityControl == null || (double)this.humidityControl.lasting_time() * 0.6 < (double)this.time || this.humidityControl.noCost());
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("inner_block", BuiltInRegistries.BLOCK.getKey((Object)this.getInnerBlock()).toString());
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("inner_block")) {
            Block block = (Block)BuiltInRegistries.BLOCK.get(EclipticSeasons.parse(tag.getString("inner_block")));
            if (!block.defaultBlockState().isAir()) {
                this.setBlockAndItemNotSync(block);
            } else {
                this.setBlockAndItemNotSync(null);
            }
        }
    }

    protected void setBlockNotSync(Block block) {
        this.innerBlock = block;
    }

    protected void setBlockAndItemNotSync(Block block) {
        this.setBlockNotSync(block);
        this.itemStackHandler.setStackInSlotNotSync(0, (block == null ? Items.AIR : block.asItem()).getDefaultInstance());
    }

    public void setInnerBlock(Block innerBlock) {
        this.popBlock(this.getLevel(), this.getBlockPos());
        this.setBlockAndItemNotSync(innerBlock);
        this.inventoryChanged();
    }

    public Block getInnerBlock() {
        return this.innerBlock == null ? Blocks.AIR : this.innerBlock;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, BlockInCopperGrateBlockEntity blockEntity) {
        HumidityControlBlockEntity.tick(level, blockPos, blockState, blockEntity);
    }

    @Override
    protected boolean isRecipeCacheValid(@NotNull HumidityControl humidityControl) {
        if (this.innerBlock == null || !humidityControl.ingredient().test(this.innerBlock.asItem().getDefaultInstance())) {
            return false;
        }
        return super.isRecipeCacheValid(humidityControl);
    }

    @Override
    protected void endRecipe() {
        Item item;
        if (!this.hasNoRecipe() && this.time <= 0 && (item = this.humidityControl.result().getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            this.setInnerBlock(blockItem.getBlock());
        }
        super.endRecipe();
    }

    @Override
    protected void resetRecipe() {
        super.resetRecipe();
        this.setInnerBlock(null);
    }

    public GrateItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public class GrateItemStackHandler
    extends ItemStackHandler {
        public GrateItemStackHandler() {
            super(1);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return BlockInCopperGrateBlock.getItemMatch(BlockInCopperGrateBlockEntity.this.level, stack) != null;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BlockInCopperGrateBlockEntity.this.setBlockNotSync(Block.byItem((Item)this.getStackInSlot(0).getItem()));
            BlockInCopperGrateBlockEntity.this.inventoryChanged();
        }

        public void setStackInSlotNotSync(int slot, @NotNull ItemStack stack) {
            this.validateSlotIndex(slot);
            this.stacks.set(slot, (Object)stack);
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return super.getStackInSlot(slot);
        }
    }
}

