/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block.blockentity;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.block.GreenHouseCoreBlock;
import com.teamtea.eclipticseasons.common.block.blockentity.base.SyncBlockEntity;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.core.crop.GreenHouseAir;
import com.teamtea.eclipticseasons.common.core.crop.GreenHouseCoreProvider;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GreenHouseCoreBlockEntity
extends SyncBlockEntity {
    private Long2ObjectOpenHashMap<GreenHouseAir> greenHouseHolder = new Long2ObjectOpenHashMap();
    private int checkSleepTime = -1;

    public GreenHouseCoreBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.greenhouse_core_entity_type.get(), pos, state);
    }

    public void setRemoved() {
        SolarDataManager manager = SolarHolders.getSaveData(this.level);
        if (manager != null) {
            manager.removeGreenHouseProvider(this.getBlockPos());
        }
        this.greenHouseHolder.clear();
        super.setRemoved();
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, GreenHouseCoreBlockEntity blockEntity) {
        Block block = blockState.getBlock();
        if (block instanceof GreenHouseCoreBlock) {
            Holder<Biome> cropBiome;
            Holder<AgroClimaticZone> agroClimaticZoneHolder;
            GreenHouseCoreBlock greenHouseCoreBlock = (GreenHouseCoreBlock)block;
            SolarDataManager manager = SolarHolders.getSaveData(level);
            if (manager != null) {
                GreenHouseCoreProvider nearGreenHouseProvider = manager.queryGreenHouseProvider(blockPos);
                if (nearGreenHouseProvider != null) {
                    if (nearGreenHouseProvider.getAvailCost() < 10) {
                        nearGreenHouseProvider.addAvailCost(999);
                    }
                } else {
                    manager.addGreenHouseCoreProvider(blockPos, new GreenHouseCoreProvider(greenHouseCoreBlock.getSeason(), 999));
                }
            }
            if (blockEntity.checkSleepTime <= 0) {
                blockEntity.greenHouseHolder.clear();
            } else {
                --blockEntity.checkSleepTime;
                if (blockEntity.checkSleepTime == 9900) {
                    // empty if block
                }
            }
            if (!level.isClientSide() && level.getGameTime() % 100L == 0L && (agroClimaticZoneHolder = CropGrowthHandler.getclimateTypeHolder(cropBiome = CropGrowthHandler.getCropBiome((LevelAccessor)level, blockPos))) != null) {
                AgroClimaticZone agroClimaticZone = (AgroClimaticZone)agroClimaticZoneHolder.value();
                List<Pair<Season, Integer>> pairs = agroClimaticZone.seasonalSignalDurations();
                Pair<Season, Integer> currentSeason = GreenHouseCoreBlockEntity.findCurrentSeason(pairs, EclipticUtil.getNowSolarTerm(level).ordinal());
                if (currentSeason.getFirst() == greenHouseCoreBlock.getSeason()) {
                    level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)GreenHouseCoreBlock.POWER, (Comparable)((Integer)currentSeason.getSecond())));
                } else {
                    level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)GreenHouseCoreBlock.POWER, (Comparable)Integer.valueOf(0)));
                }
            }
        }
    }

    public static Pair<Season, Integer> findCurrentSeason(List<Pair<Season, Integer>> localSeason, int index) {
        if (localSeason.isEmpty()) {
            return Pair.of((Object)Season.NONE, (Object)0);
        }
        if (localSeason.size() == 1) {
            return Pair.of((Object)((Season)localSeason.get(0).getFirst()), (Object)15);
        }
        int accumulatedLength = 0;
        for (int i = 0; i < localSeason.size(); ++i) {
            Season season = (Season)localSeason.get(i).getFirst();
            int seasonLength = (Integer)localSeason.get(i).getSecond();
            if (index < accumulatedLength + seasonLength) {
                int power;
                Season lastSeason;
                Season firstSeason = (Season)localSeason.get(0).getFirst();
                if (firstSeason.equals(lastSeason = (Season)localSeason.get(localSeason.size() - 1).getFirst()) && (i == 0 || i == localSeason.size() - 1)) {
                    int localIndex = index - accumulatedLength;
                    int totalMergedLength = (Integer)localSeason.get(0).getSecond() + (Integer)localSeason.get(localSeason.size() - 1).getSecond();
                    power = Math.min(index, totalMergedLength - localIndex) * 30 / totalMergedLength;
                } else {
                    power = Math.min(accumulatedLength + seasonLength - index, index - accumulatedLength) * 30 / seasonLength;
                }
                return Pair.of((Object)season, (Object)Mth.clamp((int)power, (int)1, (int)15));
            }
            accumulatedLength += seasonLength;
        }
        return Pair.of((Object)Season.NONE, (Object)0);
    }

    private static /* synthetic */ void lambda$tick$0(GreenHouseCoreBlockEntity blockEntity, GreenHouseAir.GreenHouseScanResult greenHouseScanResult1) {
        blockEntity.checkSleepTime = 1000;
        blockEntity.greenHouseHolder = greenHouseScanResult1.airMap();
    }
}

