/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.constant.climate.BiomeRain;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.api.util.SimpleUtil;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.snow.SnowyMapChecker;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import com.teamtea.eclipticseasons.common.misc.MapExporter;
import com.teamtea.eclipticseasons.common.network.SimpleNetworkHandler;
import com.teamtea.eclipticseasons.common.network.message.EmptyMessage;
import com.teamtea.eclipticseasons.common.network.message.UpdateTempChangeMessage;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.TimeCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="eclipticseasons")
public class CommandHandler {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"time").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)"set").then(Commands.literal((String)"night").executes(source -> TimeCommand.setTime((CommandSourceStack)((CommandSourceStack)source.getSource()), (int)EclipticUtil.getNightTime((Level)((CommandSourceStack)source.getSource()).getLevel()))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ecliptic").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"solar").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"set").then(Commands.argument((String)"day", (ArgumentType)IntegerArgumentType.integer()).executes(commandContext -> CommandHandler.setDay((CommandSourceStack)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"day")))))).then(Commands.literal((String)"get").executes(commandContext -> {
            int solar = EclipticUtil.getNowSolarDay((Level)((CommandSourceStack)commandContext.getSource()).getLevel());
            ((CommandSourceStack)commandContext.getSource()).sendSuccess(() -> Component.literal((String)("" + solar)), true);
            return 0;
        }))).then(Commands.literal((String)"setSnowTempChange").then(Commands.argument((String)"tempChange", (ArgumentType)FloatArgumentType.floatArg((float)-0.25f, (float)0.25f)).executes(commandContext -> CommandHandler.setTempChange((CommandSourceStack)commandContext.getSource(), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"tempChange")))))).then(Commands.literal((String)"getSnowTempChange").executes(commandContext -> {
            float snowTempChange = EclipticUtil.getSnowTempChange((Level)((CommandSourceStack)commandContext.getSource()).getLevel());
            ((CommandSourceStack)commandContext.getSource()).sendSuccess(() -> Component.literal((String)("" + snowTempChange)), true);
            return 0;
        }))).then(Commands.literal((String)"setTerm").then(Commands.argument((String)"term", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
            String pre = "";
            try {
                pre = (String)context.getArgument("term", String.class);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String finalPre = pre;
            for (SolarTerm solarTerm : SolarTerm.collectValues()) {
                if (solarTerm == SolarTerm.NONE) continue;
                MutableComponent translation = solarTerm.getTranslation();
                String s = solarTerm.getName();
                if (!s.contains(finalPre.toLowerCase(Locale.ROOT))) continue;
                builder.suggest(s, (Message)Component.translatable((String)"%s%s%s%s", (Object[])new Object[]{Component.literal((String)"[").withStyle(ChatFormatting.WHITE), translation.withStyle(solarTerm.getSeason().getColor()).withStyle(ChatFormatting.WHITE), Component.literal((String)"] ").withStyle(ChatFormatting.WHITE), solarTerm.getAlternationText()}));
            }
            return builder.buildFuture();
        }).executes(commandContext -> {
            String s = StringArgumentType.getString((CommandContext)commandContext, (String)"term");
            Enum ss = null;
            for (SolarTerm solarTerm : SolarTerm.collectValues()) {
                if (!solarTerm.getName().equals(s)) continue;
                ss = solarTerm;
                break;
            }
            int day = ss.ordinal() * (Integer)CommonConfig.Season.lastingDaysOfEachTerm.get();
            return CommandHandler.setDay((CommandSourceStack)commandContext.getSource(), day);
        })))).then(Commands.literal((String)"getTerm").executes(commandContext -> {
            SolarTerm solar = EclipticUtil.getNowSolarTerm((Level)((CommandSourceStack)commandContext.getSource()).getLevel());
            ((CommandSourceStack)commandContext.getSource()).sendSuccess(solar::getTranslation, true);
            return 0;
        }))).then(Commands.literal((String)"add").then(Commands.argument((String)"day", (ArgumentType)IntegerArgumentType.integer()).executes(commandContext -> CommandHandler.addDay((CommandSourceStack)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"day"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"weather").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"biome", (ArgumentType)ResourceOrTagArgument.resourceOrTag((CommandBuildContext)event.getBuildContext(), (ResourceKey)Registries.BIOME)).then(Commands.literal((String)"rain").executes(commandContext -> CommandHandler.setBiomeRain((CommandSourceStack)commandContext.getSource(), (Predicate<Holder<Biome>>)ResourceOrTagArgument.getResourceOrTag((CommandContext)commandContext, (String)"biome", (ResourceKey)Registries.BIOME), true, false)))).then(Commands.literal((String)"thunder").executes(commandContext -> CommandHandler.setBiomeRain((CommandSourceStack)commandContext.getSource(), (Predicate<Holder<Biome>>)ResourceOrTagArgument.getResourceOrTag((CommandContext)commandContext, (String)"biome", (ResourceKey)Registries.BIOME), true, true)))).then(Commands.literal((String)"clear").executes(commandContext -> CommandHandler.setBiomeRain((CommandSourceStack)commandContext.getSource(), (Predicate<Holder<Biome>>)ResourceOrTagArgument.getResourceOrTag((CommandContext)commandContext, (String)"biome", (ResourceKey)Registries.BIOME), false, false)))).then(Commands.literal((String)"snow_depth").then(Commands.argument((String)"depth", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(commandContext -> CommandHandler.setSnowDepth((CommandSourceStack)commandContext.getSource(), (ResourceOrTagArgument.Result<Biome>)ResourceOrTagArgument.getResourceOrTag((CommandContext)commandContext, (String)"biome", (ResourceKey)Registries.BIOME), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"depth")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"export").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"biome_map").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(stackCommandContext -> MapExporter.exportMap((CommandSourceStack)stackCommandContext.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)stackCommandContext, (String)"pos")))))).then(Commands.literal((String)"humid_charts").then(Commands.argument((String)"namespace", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            String pre = "";
            try {
                pre = (String)context.getArgument("namespace", String.class);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Registry biomes = ((CommandSourceStack)context.getSource()).getLevel().registryAccess().registryOrThrow(Registries.BIOME);
            Set collect = biomes.keySet().stream().map(ResourceLocation::getNamespace).collect(Collectors.toSet());
            for (String s : collect) {
                if (!s.contains(pre)) continue;
                builder.suggest(s);
            }
            return builder.buildFuture();
        }).executes(stackCommandContext -> {
            try {
                String s = StringArgumentType.getString((CommandContext)stackCommandContext, (String)"namespace");
                SimpleUtil.exportHumidityChart((Level)((CommandSourceStack)stackCommandContext.getSource()).getLevel(), s);
                ((CommandSourceStack)stackCommandContext.getSource()).sendSuccess(() -> Component.literal((String)("Can find them in " + "%s/humid/%s".formatted("eclipticseasons", s))), true);
            }
            catch (Exception e) {
                ((CommandSourceStack)stackCommandContext.getSource()).sendFailure((Component)Component.literal((String)e.getMessage()));
                return 1;
            }
            return 0;
        })))));
    }

    private static int setSnowDepth(CommandSourceStack sourceStack, ResourceOrTagArgument.Result<Biome> result, int depth) {
        ServerLevel level = sourceStack.getLevel();
        ArrayList<WeatherManager.BiomeWeather> levelBiomeWeather = WeatherManager.getBiomeList((Level)level);
        if (levelBiomeWeather != null) {
            boolean found = false;
            for (WeatherManager.BiomeWeather biomeWeather : levelBiomeWeather) {
                if (!result.test(biomeWeather.biomeHolder)) continue;
                biomeWeather.snowDepth = (byte)depth;
                biomeWeather.lastRainTime = level.getGameTime();
                found = true;
            }
            if (found) {
                WeatherManager.sendBiomePacket(levelBiomeWeather, level.players());
                SnowyMapChecker.updateAllChunks(level);
                SimpleNetworkHandler.send(level.players(), new EmptyMessage());
            }
        }
        return 0;
    }

    public static int setBiomeRain(CommandSourceStack sourceStack, Predicate<Holder<Biome>> result, boolean setRain, boolean isThunder) throws CommandSyntaxException {
        ServerLevel level = sourceStack.getLevel();
        ArrayList<WeatherManager.BiomeWeather> levelBiomeWeather = WeatherManager.getBiomeList((Level)level);
        if (levelBiomeWeather != null) {
            boolean found = false;
            int size = WeatherManager.getWeatherTickFactor((Level)level);
            SolarTerm solarTerm = EclipticSeasonsApi.getInstance().getSolarTerm((Level)level);
            for (WeatherManager.BiomeWeather biomeWeather : levelBiomeWeather) {
                if (!result.test(biomeWeather.biomeHolder)) continue;
                BiomeRain biomeRain = WeatherManager.getBiomeRain(level, solarTerm, biomeWeather.biomeHolder);
                biomeWeather.clearTime = setRain ? 0 : biomeRain.getRainDelay(level.getRandom()) / size;
                biomeWeather.rainTime = setRain ? biomeRain.getRainDuration(level.getRandom()) / size : 0;
                biomeWeather.lastRainTime = setRain ? level.getGameTime() : biomeWeather.lastRainTime;
                biomeWeather.thunderTime = isThunder ? biomeRain.getThunderDuration(level.getRandom()) / size : 0;
                found = true;
            }
            if (found) {
                WeatherManager.sendBiomePacket(levelBiomeWeather, level.players());
            }
        }
        return 0;
    }

    private static int getDay(ServerLevel worldIn) {
        return SolarHolders.getSaveDataLazy((Level)worldIn).map(SolarDataManager::getSolarTermsDay).orElse(0);
    }

    public static int setDay(CommandSourceStack source, int day) {
        for (ServerLevel serverLevel : List.of(source.getLevel())) {
            SolarHolders.getSaveDataLazy((Level)serverLevel).ifPresent(data -> {
                data.setSolarTermsDay(day);
                data.sendAndUpdate(serverLevel);
            });
        }
        source.sendSuccess(() -> Component.translatable((String)"commands.eclipticseasons.solar.set", (Object[])new Object[]{day}), true);
        return CommandHandler.getDay(source.getLevel());
    }

    public static int setTempChange(CommandSourceStack source, float tempChange) {
        for (ServerLevel serverLevel : List.of(source.getLevel())) {
            SolarHolders.getSaveDataLazy((Level)serverLevel).ifPresent(data -> {
                data.setSolarTempChange(tempChange);
                SimpleNetworkHandler.send(serverLevel.players(), new UpdateTempChangeMessage(tempChange));
            });
        }
        source.sendSuccess(() -> Component.literal((String)("" + tempChange)), true);
        return 0;
    }

    public static int addDay(CommandSourceStack source, int add) {
        for (ServerLevel ServerLevel2 : List.of(source.getLevel())) {
            SolarHolders.getSaveDataLazy((Level)ServerLevel2).ifPresent(data -> {
                data.setSolarTermsDay(data.getSolarTermsDay() + add);
                data.sendAndUpdate(ServerLevel2);
                source.sendSuccess(() -> Component.translatable((String)"commands.eclipticseasons.solar.set", (Object[])new Object[]{data.getSolarTermsDay()}), true);
            });
        }
        return CommandHandler.getDay(source.getLevel());
    }

    public static ResourceOrTagArgument.Result<Biome> createAllResult(RegistryAccess registryAccess) {
        Registry biomes = registryAccess.registryOrThrow(Registries.BIOME);
        return new crs((Holder.Reference<Biome>)((Holder.Reference)biomes.getHolder(0).orElse(null)));
    }

    private record crs(Holder.Reference<Biome> biomeReference) implements ResourceOrTagArgument.Result<Biome>
    {
        public boolean test(Holder<Biome> biomeHolder) {
            return true;
        }

        @NotNull
        public Either<Holder.Reference<Biome>, HolderSet.Named<Biome>> unwrap() {
            try {
                throw new IllegalCallerException("Should not call the method because it just use for internal.");
            }
            catch (IllegalCallerException e) {
                e.printStackTrace();
                return Either.left(this.biomeReference);
            }
        }

        @NotNull
        public <E> Optional<ResourceOrTagArgument.Result<E>> cast(@NotNull ResourceKey<? extends Registry<E>> p_249572_) {
            return Optional.empty();
        }

        @NotNull
        public String asPrintable() {
            return EclipticSeasons.rl("all").toLanguageKey("ResourceOrTagArgument.Result");
        }
    }
}

