/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.crop;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.constant.biome.Humidity;
import com.teamtea.eclipticseasons.api.constant.crop.CropHumidityInfo;
import com.teamtea.eclipticseasons.api.constant.crop.CropHumidityType;
import com.teamtea.eclipticseasons.api.constant.crop.CropSeasonInfo;
import com.teamtea.eclipticseasons.api.constant.crop.CropSeasonType;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.tag.EclipticBlockTags;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.data.craft.WetterStructure;
import com.teamtea.eclipticseasons.api.data.crop.CropGrow;
import com.teamtea.eclipticseasons.api.data.crop.CropGrowControl;
import com.teamtea.eclipticseasons.api.data.crop.CropGrowControlBuilder;
import com.teamtea.eclipticseasons.api.data.crop.GrowParameter;
import com.teamtea.eclipticseasons.api.data.misc.ESSortInfo;
import com.teamtea.eclipticseasons.api.data.misc.PosAndBlockStateCheck;
import com.teamtea.eclipticseasons.api.event.CanPlantGrowEvent;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.api.util.SimpleUtil;
import com.teamtea.eclipticseasons.api.util.fast.Enum2ObjectMap;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.crop.CropInfoManager;
import com.teamtea.eclipticseasons.common.core.crop.GreenHouseCoreProvider;
import com.teamtea.eclipticseasons.common.core.crop.HumidityControlProvider;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import com.teamtea.eclipticseasons.common.registry.AgroClimateRegistry;
import com.teamtea.eclipticseasons.common.registry.CropRegistry;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;
import net.neoforged.neoforge.event.level.block.CropGrowEvent;
import org.jetbrains.annotations.NotNull;

public final class CropGrowthHandler {
    private static final Map<Block, List<WetterStructure>> wetterStructures = new IdentityHashMap<Block, List<WetterStructure>>();
    private static final Map<Biome, Holder<AgroClimaticZone>> cropClimateTypeMap = new IdentityHashMap<Biome, Holder<AgroClimaticZone>>();
    private static final Map<ResourceLocation, CropGrowControlBuilder> CropGrowControlBuilder = new HashMap<ResourceLocation, CropGrowControlBuilder>();
    private static final Map<Block, Map<Holder<AgroClimaticZone>, CropGrowControl>> CROP_GROW_MAP = new IdentityHashMap<Block, Map<Holder<AgroClimaticZone>, CropGrowControl>>();
    private static final IdentityHashMap<Boolean, Holder<AgroClimaticZone>> DefaultCropClimateType = new IdentityHashMap();
    public static final int CANCEL = 1;
    public static final int PASS = 2;
    public static final int GROW = 3;
    public static final Vec3[] CHECK_DIRECTIONS = new Vec3[]{new Vec3(0.0, 1.0, 0.0), new Vec3(1.0, 0.0, 0.0), new Vec3(-1.0, 0.0, 0.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, -1.0), new Vec3(1.0, 1.0, 0.0), new Vec3(-1.0, 1.0, 0.0), new Vec3(0.0, 1.0, 1.0), new Vec3(0.0, 1.0, -1.0), new Vec3(1.0, 0.0, 1.0), new Vec3(1.0, 0.0, -1.0), new Vec3(-1.0, 0.0, 1.0), new Vec3(-1.0, 0.0, -1.0), new Vec3(1.0, 1.0, 1.0), new Vec3(1.0, 1.0, -1.0), new Vec3(-1.0, 1.0, 1.0), new Vec3(-1.0, 1.0, -1.0)};
    public static final Vec3[] CHECK_DIRECTIONS_SIMPLE = new Vec3[]{new Vec3(0.0, 1.0, 0.0), new Vec3(1.0, 0.0, 0.0), new Vec3(-1.0, 0.0, 0.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, -1.0)};
    private static final FailHandler FAIL_HANDLER = new FailHandler();

    public static void beforeCropGrowUp(CropGrowEvent.Pre event) {
        BlockState block = event.getState();
        LevelAccessor world = event.getLevel();
        BlockPos pos = event.getPos();
        if (world instanceof Level) {
            Level level = (Level)world;
            CropGrowthHandler.beforeCropGrowUp((Event)event, level, pos, block);
        }
    }

    public static void beforeCropGrowUp(CanPlantGrowEvent event) {
        BlockState block = event.getState();
        LevelAccessor world = event.getLevel();
        BlockPos pos = event.getPos();
        if (world instanceof Level) {
            Level level = (Level)world;
            CropGrowthHandler.beforeCropGrowUp((Event)event, level, pos, block);
        }
    }

    public static void beforeCropGrowUp(BonemealEvent event) {
        BlockState block = event.getState();
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        if (world instanceof Level) {
            Level level = world;
            CropGrowthHandler.beforeCropGrowUp((Event)event, level, pos, block);
        }
    }

    public static void beforeCropGrowUp(BlockGrowFeatureEvent event) {
        LevelAccessor world = event.getLevel();
        BlockPos pos = event.getPos();
        if (world instanceof Level) {
            SolarDataManager data;
            Level level = (Level)world;
            SolarDataManager solarDataManager = SolarHolders.getSaveData(level);
            if (solarDataManager instanceof SolarDataManager && (data = solarDataManager).shouldSkipNextCheck(pos)) {
                return;
            }
            CropGrowthHandler.beforeCropGrowUp((Event)event, level, pos, world.getBlockState(pos));
        }
    }

    public static void resetUpdate(RegistryAccess registryAccess, boolean isServer) {
        Optional structures;
        if (isServer && (structures = registryAccess.registry(ESRegistries.WETTER)).isPresent()) {
            wetterStructures.clear();
            for (WetterStructure structure : ESSortInfo.sorted2((Registry)structures.get())) {
                HolderSet.Direct holders = structure.core().isPresent() && structure.core().get().blocks().isPresent() ? (HolderSet)structure.core().get().blocks().get() : HolderSet.direct((Holder[])new Holder[]{Blocks.AIR.builtInRegistryHolder()});
                for (Holder holder : holders) {
                    wetterStructures.compute((Block)holder.value(), (block, wetterStructures1) -> {
                        wetterStructures1 = wetterStructures1 == null ? new ArrayList() : wetterStructures1;
                        wetterStructures1.add(structure);
                        return wetterStructures1;
                    });
                }
            }
        }
        Optional agroClimaticZones = registryAccess.registry(ESRegistries.AGRO_CLIMATE);
        Optional cropGrowControlBuilders = registryAccess.registry(ESRegistries.CROP);
        if (agroClimaticZones.isEmpty()) {
            SimpleUtil.warningForModWrongCalling(ESRegistries.AGRO_CLIMATE);
            return;
        }
        if (cropGrowControlBuilders.isEmpty()) {
            SimpleUtil.warningForModWrongCalling(ESRegistries.CROP);
            return;
        }
        long startTime = System.currentTimeMillis();
        if (isServer) {
            cropClimateTypeMap.clear();
            CropGrowControlBuilder.clear();
            CROP_GROW_MAP.clear();
            DefaultCropClimateType.clear();
        }
        Registry cropClimateTypeRegistry = (Registry)agroClimaticZones.get();
        for (Holder.Reference agroClimaticZoneReference : ESSortInfo.sorted(cropClimateTypeRegistry.holders().toList())) {
            if (!agroClimaticZoneReference.isBound()) continue;
            HolderSet<Biome> biomes = ((AgroClimaticZone)agroClimaticZoneReference.value()).biomes();
            for (int i = 0; i < biomes.size(); ++i) {
                cropClimateTypeMap.put((Biome)biomes.get(i).value(), (Holder<AgroClimaticZone>)agroClimaticZoneReference);
            }
        }
        DefaultCropClimateType.put(isServer, (Holder<AgroClimaticZone>)((Holder)cropClimateTypeRegistry.getHolder(AgroClimateRegistry.TEMPERATE).orElse(null)));
        Registry itemRegistry = registryAccess.registryOrThrow(Registries.ITEM);
        Registry blockRegistry = registryAccess.registryOrThrow(Registries.BLOCK);
        for (Map.Entry entry : ESSortInfo.sorted(((Registry)cropGrowControlBuilders.get()).entrySet())) {
            TagKey itemTagKey;
            Optional itemNamed;
            int i;
            CropGrowControlBuilder builder = (CropGrowControlBuilder)entry.getValue();
            CropGrowControlBuilder.put(entry.getKey().location(), builder);
            Optional blocks = builder.applyTarget().blocks();
            Optional properties = builder.applyTarget().properties();
            if (blocks.isEmpty()) continue;
            Enum2ObjectMap<SolarTerm, GrowParameter> solarTermGrowParameterEnumMap = new Enum2ObjectMap<SolarTerm, GrowParameter>(builder.solarTermList());
            Enum2ObjectMap<Season, GrowParameter> seasonGrowParameterEnumMap = new Enum2ObjectMap<Season, GrowParameter>(builder.seasonList());
            Enum2ObjectMap<Humidity, GrowParameter> humidityGrowParameterEnumMap = new Enum2ObjectMap<Humidity, GrowParameter>(builder.humidList());
            Optional<GrowParameter> solarTermGrowParameter = builder.defaultSolarTermGrowParameter();
            Optional<GrowParameter> humidityGrowParameter = builder.defaultHumidityGrowParameter();
            Optional<BlockPredicate> notGreenHouse = builder.notGreenHouse();
            if (builder.parent().size() > 0) {
                ArrayList<HolderSet<CropGrowControlBuilder>> holderSets = new ArrayList<HolderSet<CropGrowControlBuilder>>();
                holderSets.add(builder.parent());
                while (!holderSets.isEmpty()) {
                    HolderSet currentParentSet = (HolderSet)holderSets.removeFirst();
                    for (i = 0; i < currentParentSet.size(); ++i) {
                        CropGrowControlBuilder parentBuilder = (CropGrowControlBuilder)builder.parent().get(i).value();
                        if (!builder.isChildClimateType(parentBuilder.cropClimateType())) continue;
                        for (Map.Entry<SolarTerm, GrowParameter> entry2 : parentBuilder.solarTermList().entrySet()) {
                            solarTermGrowParameterEnumMap.putIfAbsent(entry2.getKey(), entry2.getValue());
                        }
                        for (Map.Entry<Enum, GrowParameter> entry3 : parentBuilder.seasonList().entrySet()) {
                            seasonGrowParameterEnumMap.putIfAbsent((Season)entry3.getKey(), entry3.getValue());
                        }
                        for (Map.Entry<Enum, GrowParameter> entry4 : parentBuilder.humidList().entrySet()) {
                            humidityGrowParameterEnumMap.putIfAbsent((Humidity)entry4.getKey(), entry4.getValue());
                        }
                        if (solarTermGrowParameter.isEmpty() && parentBuilder.defaultSolarTermGrowParameter().isPresent()) {
                            solarTermGrowParameter = parentBuilder.defaultSolarTermGrowParameter();
                        }
                        if (humidityGrowParameter.isEmpty() && parentBuilder.defaultHumidityGrowParameter().isPresent()) {
                            humidityGrowParameter = parentBuilder.defaultHumidityGrowParameter();
                        }
                        if (notGreenHouse.isEmpty() && parentBuilder.notGreenHouse().isPresent()) {
                            notGreenHouse = parentBuilder.notGreenHouse();
                        }
                        if (parentBuilder.parent().size() <= 0) continue;
                        holderSets.add(parentBuilder.parent());
                    }
                }
            }
            if (!blocks.isPresent()) continue;
            HolderSet holders = (HolderSet)blocks.get();
            Optional blockTagKey = ((HolderSet)blocks.get()).unwrapKey();
            if (blockTagKey.isPresent() && ((TagKey)blockTagKey.get()).location().getNamespace().equals("eclipticseasons") && (itemNamed = itemRegistry.getTag(itemTagKey = ItemTags.create((ResourceLocation)((TagKey)blockTagKey.get()).location()))).isPresent()) {
                ArrayList holderArrayList = new ArrayList(holders.stream().toList());
                for (Holder blockHolder : (HolderSet.Named)itemNamed.get()) {
                    Object object = blockHolder.value();
                    if (!(object instanceof BlockItem)) continue;
                    BlockItem blockItem = (BlockItem)object;
                    holderArrayList.add(blockRegistry.getHolderOrThrow((ResourceKey)blockRegistry.getResourceKey((Object)blockItem.getBlock()).get()));
                }
                if (!holderArrayList.isEmpty()) {
                    holders = HolderSet.direct(holderArrayList);
                }
            }
            for (i = 0; i < holders.size(); ++i) {
                Block block2 = (Block)holders.get(i).value();
                Optional<Object> statesCheck = Optional.empty();
                if (properties.isPresent()) {
                    StatePropertiesPredicate statePropertiesPredicate = (StatePropertiesPredicate)properties.get();
                    statesCheck = Optional.of(block2.getStateDefinition().getPossibleStates().stream().filter(arg_0 -> ((StatePropertiesPredicate)statePropertiesPredicate).matches(arg_0)).toList());
                }
                Map map = CROP_GROW_MAP.computeIfAbsent(block2, block1 -> new HashMap());
                for (int j = 0; j < builder.cropClimateType().size(); ++j) {
                    CropGrow cropGrow = new CropGrow(solarTermGrowParameter, humidityGrowParameter, new Enum2ObjectMap<SolarTerm, GrowParameter>(solarTermGrowParameterEnumMap), new Enum2ObjectMap<Season, GrowParameter>(seasonGrowParameterEnumMap), new Enum2ObjectMap<Humidity, GrowParameter>(humidityGrowParameterEnumMap));
                    CropGrowControl newControlCache = new CropGrowControl(statesCheck.isEmpty() ? cropGrow : CropGrow.EMPTY, statesCheck.map(blockStates -> blockStates.stream().collect(Collectors.toMap(Function.identity(), bs -> cropGrow, (a, b) -> b, IdentityHashMap::new))), Optional.empty(), notGreenHouse);
                    Holder cropClimateTypeHolder = builder.cropClimateType().get(j);
                    if (cropClimateTypeHolder.getKey() == null) continue;
                    map.compute(cropClimateTypeHolder, (resourceLocation, oldControl) -> {
                        if (oldControl == null) {
                            return newControlCache;
                        }
                        return oldControl.merge(newControlCache);
                    });
                }
            }
        }
        CropInfoManager.CROP_SEASON_INFO.forEach((block, cropSeasonInfo) -> {
            CropSeasonType name = CropInfoManager.getCropSeasonTypeFrom(cropSeasonInfo);
            if (name != null) {
                ResourceLocation location = CropRegistry.createKey(name).location();
                CropGrowthHandler.generateInfoForTag(block, location);
            }
        });
        CropInfoManager.CROP_HUMIDITY_INFO.forEach((block, cropHumidityInfo) -> {
            CropHumidityType name = CropInfoManager.getCropHumidityTypeFrom(cropHumidityInfo);
            if (name != null) {
                ResourceLocation location = CropRegistry.createKey(name).location();
                CropGrowthHandler.generateInfoForTag(block, location);
            }
        });
        EclipticSeasons.logger("Reload crop data cost %s ms in %s side.".formatted(System.currentTimeMillis() - startTime, isServer ? "server" : "client"));
    }

    private static void generateInfoForTag(Block block, ResourceLocation location) {
        CropGrowControlBuilder builder = CropGrowControlBuilder.getOrDefault(location, null);
        if (builder != null) {
            CropGrow cropGrow = new CropGrow(builder.defaultSolarTermGrowParameter(), builder.defaultHumidityGrowParameter(), new Enum2ObjectMap<SolarTerm, GrowParameter>(builder.solarTermList()), new Enum2ObjectMap<Season, GrowParameter>(builder.seasonList()), new Enum2ObjectMap<Humidity, GrowParameter>(builder.humidList()));
            CropGrowControl newControlCache = new CropGrowControl(cropGrow, Optional.empty(), Optional.empty(), Optional.empty());
            Map blockClimateMap = CROP_GROW_MAP.computeIfAbsent(block, b1 -> new HashMap());
            for (int j = 0; j < builder.cropClimateType().size(); ++j) {
                Holder cropClimateTypeHolder = builder.cropClimateType().get(j);
                if (cropClimateTypeHolder.getKey() == null) continue;
                blockClimateMap.compute(cropClimateTypeHolder, (resourceLocation, oldControl) -> {
                    if (oldControl == null) {
                        return newControlCache;
                    }
                    return oldControl.merge(newControlCache);
                });
            }
        }
    }

    public static void clearOnClientExitOrServerClose() {
        wetterStructures.clear();
        cropClimateTypeMap.clear();
        CropGrowControlBuilder.clear();
        CROP_GROW_MAP.clear();
        DefaultCropClimateType.clear();
        CropInfoManager.CROP_HUMIDITY_INFO.clear();
        CropInfoManager.CROP_SEASON_INFO.clear();
    }

    public static float getGrowChance(Event event, GrowParameter growParameter) {
        return event instanceof BonemealEvent ? growParameter.fertile_chance() : growParameter.grow_chance();
    }

    @Deprecated(forRemoval=true, since="0.12")
    @Nullable
    public static GreenHouseCoreProvider getGreenHouseProvider(Level level, BlockPos pos, Map<Holder<AgroClimaticZone>, CropGrowControl> controlMap, Holder<AgroClimaticZone> agentClimateTypeHolder) {
        return CropGrowthHandler.getGreenHouseProvider(level, pos, null, controlMap, agentClimateTypeHolder);
    }

    @Deprecated(forRemoval=true, since="0.12")
    @NotNull
    public static List<Season> getLikeSeasonsInTemperate(Map<Holder<AgroClimaticZone>, CropGrowControl> controlMap, Holder<AgroClimaticZone> agentClimateTypeHolder) {
        return CropGrowthHandler.getLikeSeasonsInTemperate(null, controlMap, agentClimateTypeHolder);
    }

    @Deprecated(forRemoval=true, since="0.12")
    @Nullable
    public static GrowParameter getSeasonGrowParameter(CropGrowControl growControl, SolarTerm solarTerm, Map<Holder<AgroClimaticZone>, CropGrowControl> controlMap, Holder<AgroClimaticZone> agentClimateTypeHolder, Holder<AgroClimaticZone> climateTypeHolder) {
        return CropGrowthHandler.getSeasonGrowParameter(null, growControl, CropGrowthHandler.getCropGrowControl(controlMap, agentClimateTypeHolder), solarTerm, climateTypeHolder);
    }

    @Nullable
    public static GreenHouseCoreProvider getGreenHouseProvider(Level level, BlockPos pos, BlockState state, Map<Holder<AgroClimaticZone>, CropGrowControl> controlMap, Holder<AgroClimaticZone> agentClimateTypeHolder) {
        SolarDataManager saveData;
        List<Season> seasons = CropGrowthHandler.getLikeSeasonsInTemperate(state, controlMap, agentClimateTypeHolder);
        if (!seasons.isEmpty() && (saveData = SolarHolders.getSaveData(level)) != null) {
            return saveData.findNearGreenHouseProvider(pos, seasons);
        }
        return null;
    }

    @NotNull
    public static List<Season> getLikeSeasonsInTemperate(BlockState state, Map<Holder<AgroClimaticZone>, CropGrowControl> controlMap, Holder<AgroClimaticZone> agentClimateTypeHolder) {
        ArrayList<Season> seasons = new ArrayList<Season>();
        CropGrowControl growControl_Temp = CropGrowthHandler.getCropGrowControl(controlMap, agentClimateTypeHolder);
        if (growControl_Temp != null) {
            for (Season collectValue : Season.collectValues()) {
                GrowParameter parameter = growControl_Temp.getGrowParameter(collectValue, state);
                if (parameter == null || !(parameter.grow_chance() > 0.4f)) continue;
                seasons.add(collectValue);
            }
        }
        return seasons;
    }

    @NotNull
    public static List<Humidity> getLikeHumidityInTemperate(BlockState state, Map<Holder<AgroClimaticZone>, CropGrowControl> controlMap, Holder<AgroClimaticZone> agentClimateTypeHolder) {
        ArrayList<Humidity> humidities = new ArrayList<Humidity>();
        CropGrowControl growControl_Temp = CropGrowthHandler.getCropGrowControl(controlMap, agentClimateTypeHolder);
        if (growControl_Temp != null) {
            for (Humidity collectValue : Humidity.collectValues()) {
                GrowParameter parameter = growControl_Temp.getGrowParameter(collectValue, state);
                if (parameter == null || !(parameter.grow_chance() > 0.7f)) continue;
                humidities.add(collectValue);
            }
        }
        return humidities;
    }

    @Nullable
    public static GrowParameter getSeasonGrowParameter(BlockState state, CropGrowControl growControl, CropGrowControl deaultCropGrowControl, SolarTerm solarTerm, Holder<AgroClimaticZone> climateTypeHolder) {
        GrowParameter growParameter = null;
        if (growControl != null) {
            growParameter = growControl.getGrowParameter(solarTerm, state);
        }
        if (growParameter == null) {
            growParameter = ((AgroClimaticZone)climateTypeHolder.value()).getGrowParameterFromMapping(state, deaultCropGrowControl, solarTerm);
        }
        return growParameter;
    }

    @Nullable
    public static CropGrowControl getCropGrowControl(Map<Holder<AgroClimaticZone>, CropGrowControl> controlMap, Holder<AgroClimaticZone> climateTypeHolder) {
        return controlMap.getOrDefault(climateTypeHolder, null);
    }

    @Nullable
    public static Holder<AgroClimaticZone> getDefaultAgroClimaticZoneHolder(LevelAccessor level) {
        boolean isServerSide = level != null && !level.isClientSide();
        return DefaultCropClimateType.getOrDefault(isServerSide, null);
    }

    @Nullable
    public static Holder<AgroClimaticZone> getclimateTypeHolder(Holder<Biome> biomeHolder) {
        return cropClimateTypeMap.getOrDefault(biomeHolder.value(), null);
    }

    public static Holder<Biome> getCropBiome(LevelAccessor level, BlockPos pos) {
        int i = QuartPos.fromBlock((int)pos.getX());
        int j = QuartPos.fromBlock((int)pos.getY());
        int k = QuartPos.fromBlock((int)pos.getZ());
        return level.getNoiseBiome(i, j, k);
    }

    @Nullable
    public static Map<Holder<AgroClimaticZone>, CropGrowControl> getControlMap(Block block) {
        return CROP_GROW_MAP.get(block);
    }

    public static void beforeCropGrowUp(Event event, Level level, BlockPos pos, BlockState blockState) {
        Block block = blockState.getBlock();
        Map<Holder<AgroClimaticZone>, CropGrowControl> controlMap = CropGrowthHandler.getControlMap(block);
        if (controlMap == null) {
            return;
        }
        Holder<Biome> biomeHolder = CropGrowthHandler.getCropBiome((LevelAccessor)level, pos);
        Holder<AgroClimaticZone> climateTypeHolder = CropGrowthHandler.getclimateTypeHolder(biomeHolder);
        if (climateTypeHolder == null) {
            return;
        }
        Holder<AgroClimaticZone> agentClimateTypeHolder = CropGrowthHandler.getDefaultAgroClimaticZoneHolder((LevelAccessor)level);
        CropGrowControl growControl = CropGrowthHandler.getCropGrowControl(controlMap, climateTypeHolder);
        CropGrowControl agentGrowControl = CropGrowthHandler.getCropGrowControl(controlMap, agentClimateTypeHolder);
        if (growControl == null && agentGrowControl == null) {
            return;
        }
        boolean notCancel = false;
        SolarTerm solarTerm = EclipticSeasonsApi.getInstance().getSolarTerm(level);
        Season season = solarTerm.getSeason();
        RoomStatus roomStatus = RoomStatus.UNKNOWN;
        GrowParameter growParameter = CropGrowthHandler.getSeasonGrowParameter(blockState, growControl, agentGrowControl, solarTerm, climateTypeHolder);
        Optional<BlockPredicate> notGreenHouse = growControl != null ? growControl.notGreenHouse() : agentGrowControl.notGreenHouse();
        int randomKey = level.getRandom().nextInt(1000);
        float baseGrowthChance = 1.0f;
        if (growParameter != null && ((Boolean)CommonConfig.Crop.enableCrop.get()).booleanValue()) {
            float growChance = CropGrowthHandler.getGrowChance(event, growParameter);
            boolean bl = growChance * 1000.0f >= (float)randomKey;
            baseGrowthChance = growChance;
            if (!(notCancel |= bl)) {
                if (((Boolean)CommonConfig.Crop.simpleGreenHouse.get()).booleanValue()) {
                    if (CropGrowthHandler.isInRoom((LevelAccessor)level, pos, blockState, notGreenHouse)) {
                        notCancel = true;
                        roomStatus = RoomStatus.GREEN_HOUSE;
                    } else {
                        roomStatus = RoomStatus.NORMAL;
                    }
                } else {
                    GreenHouseCoreProvider nearGreenHouseProvider;
                    SolarDataManager saveData;
                    List<Season> seasons = CropGrowthHandler.getLikeSeasonsInTemperate(blockState, controlMap, agentClimateTypeHolder);
                    if (!seasons.isEmpty() && (saveData = SolarHolders.getSaveData(level)) != null && (nearGreenHouseProvider = saveData.findNearGreenHouseProvider(pos, seasons)) != null) {
                        RoomStatus roomStatus2 = roomStatus = CropGrowthHandler.isInRoom((LevelAccessor)level, pos, blockState, notGreenHouse) ? RoomStatus.GREEN_HOUSE : RoomStatus.NORMAL;
                        if (roomStatus == RoomStatus.GREEN_HOUSE) {
                            notCancel = true;
                            nearGreenHouseProvider.costAvailCost(2 / seasons.size() + 1);
                        }
                    }
                }
            }
        } else {
            notCancel = true;
        }
        float f = baseGrowthChance = notCancel ? baseGrowthChance : 0.0f;
        if (!notCancel) {
            CropGrowthHandler.setResult(event, 1, growParameter);
            if ((float)randomKey < growParameter.death_chance() * 1000.0f) {
                level.setBlockAndUpdate(pos, growParameter.deadState().isPresent() ? growParameter.deadState().get() : Blocks.DEAD_BUSH.defaultBlockState());
            }
        } else if (((Boolean)CommonConfig.Crop.enableCropHumidityControl.get()).booleanValue()) {
            float env = EclipticUtil.getHumidityLevelAt(level, solarTerm, biomeHolder, pos, !level.isClientSide());
            CropGrowthHandler.checkHumidity(event, level, growControl != null ? growControl : agentGrowControl, env, roomStatus, pos, blockState, season, false, randomKey, baseGrowthChance);
        } else {
            CropGrowthHandler.setResult(event, baseGrowthChance * 1000.0f - 1000.0f > (float)randomKey ? 3 : 2, growParameter);
        }
    }

    public static void checkHumidity(Event event, Level level, CropGrowControl growControl, float env, RoomStatus roomStatus, BlockPos pos, BlockState blockState, Season season, boolean hasUpdate, int randomKey, float baseGrowthChance) {
        if (blockState.getFluidState().isSource()) {
            return;
        }
        env = Mth.clamp((float)env, (float)0.0f, (float)(Humidity.collectValues().length - 1));
        if (growControl != null) {
            GrowParameter growParameter;
            if (!hasUpdate) {
                if (((Boolean)CommonConfig.Crop.simpleGreenHouse.get()).booleanValue()) {
                    RoomStatus roomStatus2 = roomStatus != RoomStatus.UNKNOWN ? roomStatus : (roomStatus = CropGrowthHandler.isInRoom((LevelAccessor)level, pos, blockState, growControl.notGreenHouse()) ? RoomStatus.GREEN_HOUSE : RoomStatus.NORMAL);
                    if (roomStatus == RoomStatus.GREEN_HOUSE) {
                        CropGrowthHandler.setResult(event, 2, null);
                        return;
                    }
                } else {
                    float modification;
                    SolarDataManager solarDataManager = SolarHolders.getSaveData(level);
                    if (solarDataManager instanceof SolarDataManager) {
                        SolarDataManager sd = solarDataManager;
                        v1 = sd.calculateHumidityModification(pos);
                    } else {
                        v1 = modification = 0.0f;
                    }
                    if (modification != 0.0f) {
                        RoomStatus roomStatus3 = roomStatus = CropGrowthHandler.isInRoom((LevelAccessor)level, pos, blockState, growControl.notGreenHouse()) ? RoomStatus.GREEN_HOUSE : RoomStatus.NORMAL;
                    }
                    if (modification != 0.0f && roomStatus == RoomStatus.GREEN_HOUSE) {
                        CropGrowthHandler.checkHumidity(event, level, growControl, env += modification, roomStatus, pos, blockState, season, true, randomKey, baseGrowthChance);
                        return;
                    }
                    if (level.isRainingAt(pos)) {
                        CropGrowthHandler.checkHumidity(event, level, growControl, env += 1.0f, roomStatus, pos, blockState, season, true, randomKey, baseGrowthChance);
                        return;
                    }
                }
            }
            if ((growParameter = growControl.getGrowParameter(env, blockState)) != null) {
                float f = CropGrowthHandler.getGrowChance(event, growParameter);
                int flag = 2;
                if (f == 0.0f) {
                    flag = 1;
                } else if (f > 1.0f) {
                    flag = f * baseGrowthChance * 1000.0f - 1000.0f > (float)randomKey ? 3 : 2;
                } else if (f != 1.0f && !((float)randomKey < 1000.0f * f)) {
                    flag = 1;
                }
                CropGrowthHandler.setResult(event, flag, growParameter);
                if (flag == 1 && (float)randomKey < growParameter.death_chance() * 1000.0f) {
                    level.setBlockAndUpdate(pos, growParameter.deadState().isPresent() ? growParameter.deadState().get() : Blocks.DEAD_BUSH.defaultBlockState());
                }
            } else {
                CropGrowthHandler.setResult(event, 2, null);
            }
        }
    }

    @Deprecated
    public static void setResult(Event event, int flag) {
        CropGrowthHandler.setResult(event, flag, null);
    }

    public static void setResult(Event event, int flag, @Nullable GrowParameter growParameter) {
        if (flag == 1) {
            if (event instanceof CropGrowEvent.Pre) {
                CropGrowEvent.Pre cropGrowEvent = (CropGrowEvent.Pre)event;
                cropGrowEvent.setResult(CropGrowEvent.Pre.Result.DO_NOT_GROW);
            } else if (event instanceof CanPlantGrowEvent) {
                CanPlantGrowEvent cropGrowEvent = (CanPlantGrowEvent)event;
                cropGrowEvent.setResult(CropGrowEvent.Pre.Result.DO_NOT_GROW);
            } else if (event instanceof BlockGrowFeatureEvent) {
                BlockGrowFeatureEvent blockGrowFeatureEvent = (BlockGrowFeatureEvent)event;
                blockGrowFeatureEvent.setCanceled(true);
            } else if (event instanceof BonemealEvent) {
                BonemealEvent bonemealEvent = (BonemealEvent)event;
                bonemealEvent.setSuccessful(((Boolean)CommonConfig.Crop.boneMealConsumeOnFailure.get()).booleanValue());
                bonemealEvent.setCanceled(true);
            }
        } else if (flag == 2) {
            if (event instanceof CropGrowEvent.Pre) {
                CropGrowEvent.Pre cropGrowEvent = (CropGrowEvent.Pre)event;
                cropGrowEvent.setResult(CropGrowEvent.Pre.Result.DEFAULT);
            } else if (event instanceof CanPlantGrowEvent) {
                CanPlantGrowEvent cropGrowEvent = (CanPlantGrowEvent)event;
                cropGrowEvent.setResult(CropGrowEvent.Pre.Result.DEFAULT);
            }
        } else if (flag == 3) {
            if (event instanceof CropGrowEvent.Pre) {
                CropGrowEvent.Pre cropGrowEvent = (CropGrowEvent.Pre)event;
                cropGrowEvent.setResult(CropGrowEvent.Pre.Result.GROW);
            } else if (event instanceof CanPlantGrowEvent) {
                CanPlantGrowEvent cropGrowEvent = (CanPlantGrowEvent)event;
                cropGrowEvent.setResult(CropGrowEvent.Pre.Result.GROW);
            }
        }
        CropGrowthHandler.postResult(event, flag, growParameter);
    }

    static void postResult(Event event, int flag, @Nullable GrowParameter growParameter) {
        ServerPlayer player;
        BonemealEvent bonemealEvent;
        Player player2;
        if (flag != 1) {
            ServerLevel serverLevel;
            BonemealEvent bonemealEvent2;
            Object object;
            if (event instanceof BonemealEvent && (object = (bonemealEvent2 = (BonemealEvent)event).getLevel()) instanceof ServerLevel && (object = SolarHolders.getSaveData((Level)(serverLevel = (ServerLevel)object))) instanceof SolarDataManager) {
                Object solarDataManager = object;
                ((SolarDataManager)((Object)solarDataManager)).addSkipNextCheck(bonemealEvent2.getPos(), bonemealEvent2.getState());
            }
        } else if (event instanceof BonemealEvent && (player2 = (bonemealEvent = (BonemealEvent)event).getPlayer()) instanceof ServerPlayer && !((player = (ServerPlayer)player2) instanceof FakePlayer) && ((Boolean)CommonConfig.Crop.boneMealFailureMessage.get()).booleanValue() && growParameter != null && growParameter.fertile_chance() == 0.0f) {
            player.sendSystemMessage((Component)Component.translatable((String)"info.eclipticseasons.bone_meal.failure"), true);
        }
    }

    public static BlockHitResult clip(LevelReader levelAccessor, SectionClipContext context, Optional<BlockPredicate> notCheck) {
        return (BlockHitResult)BlockGetter.traverseBlocks((Vec3)context.getFrom(), (Vec3)context.getTo(), (Object)((Object)context), (BiFunction)new BlockTester(levelAccessor, notCheck), (Function)FAIL_HANDLER);
    }

    public static boolean isInRoom(LevelAccessor level, BlockPos pos, BlockState state, Optional<BlockPredicate> notCheck) {
        int height;
        boolean isInLight;
        boolean bl = isInLight = level.getBrightness(LightLayer.SKY, pos.above()) > 12;
        if (isInLight && (height = level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ())) < pos.getY()) {
            return false;
        }
        boolean isConnected = true;
        int maxDistance = (Integer)CommonConfig.Crop.greenHouseMaxDiameter.get();
        int y_maxDistance = (Integer)CommonConfig.Crop.greenHouseMaxHeight.get();
        Vec3 centerVec = pos.getCenter();
        Vec3[] vec3s = (Boolean)CommonConfig.Crop.complexGreenHouseCheck.get() != false ? CHECK_DIRECTIONS : CHECK_DIRECTIONS_SIMPLE;
        float xr = (float)level.getRandom().nextGaussian() / 3.0f;
        float yr = (float)level.getRandom().nextGaussian() / 3.0f;
        for (Vec3 direction : vec3s) {
            direction = direction.x != 0.0 || direction.z != 0.0 ? direction.add((double)xr, 0.0, (double)yr) : direction;
            Vec3 startVec = centerVec;
            Vec3 endVec = (Boolean)CommonConfig.Crop.useBoxDistance.get() != false ? CropGrowthHandler.getClampedEndPoint(centerVec, direction, maxDistance, y_maxDistance) : centerVec.add(direction.scale(direction.y == 0.0 ? (double)maxDistance : (double)y_maxDistance));
            SectionClipContext context = new SectionClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.WATER, CollisionContext.empty());
            BlockHitResult hitResult = CropGrowthHandler.clip((LevelReader)level, context, notCheck);
            if (hitResult.getType() != HitResult.Type.MISS) continue;
            isConnected = false;
            break;
        }
        if (isConnected && !isInLight && level.getRandom().nextInt(10000) <= (Integer)CommonConfig.Crop.darkGreenhouseFailChance.get()) {
            isConnected = state.is(EclipticBlockTags.NATURAL_PLANTS);
        }
        return isConnected;
    }

    public static void unloadChunk(Level level, ChunkPos chunkPos) {
        SolarDataManager saveData = SolarHolders.getSaveData(level);
        if (saveData != null) {
            saveData.unloadChunk(chunkPos);
        }
    }

    public static void handleChunkTick(Level level, LevelChunk chunk) {
        SolarDataManager saveData = SolarHolders.getSaveData(level);
        if (saveData != null) {
            saveData.tickChunk(chunk);
        }
    }

    public static void handleRandomTick(ServerLevel level, BlockPos pos, BlockState state, List<WetterStructure> wetterStructureList) {
        SolarDataManager saveData = SolarHolders.getSaveData((Level)level);
        if (saveData == null) {
            return;
        }
        boolean hasFound = false;
        WetterStructure needAdd = null;
        int wetterStructuresSize = wetterStructureList.size();
        for (int j = 0; j < wetterStructuresSize; ++j) {
            WetterStructure structure = wetterStructureList.get(j);
            boolean needSkip = false;
            if (!needSkip && structure.enableAirCheck()) {
                boolean bl = needSkip = !level.getBlockState(pos.above()).isEmpty();
            }
            if (!needSkip) {
                List<PosAndBlockStateCheck> blockStatePredicate = structure.blockStatePredicate();
                int blockStatePredicateSize = blockStatePredicate.size();
                for (int i = 0; i < blockStatePredicateSize; ++i) {
                    PosAndBlockStateCheck check = blockStatePredicate.get(i);
                    if (check.block().matches(level, pos.offset(check.offset()))) continue;
                    needSkip = true;
                    break;
                }
            }
            if (needSkip) continue;
            hasFound = true;
            needAdd = structure;
            break;
        }
        if (hasFound) {
            saveData.addHumidityControlProvider(pos, new HumidityControlProvider(needAdd.level(), needAdd.range() * needAdd.range(), needAdd.lastingTime(), true));
        }
    }

    public static List<WetterStructure> validTick(BlockState state) {
        List wetterStructureList = wetterStructures.getOrDefault(state.getBlock(), List.of());
        ArrayList<WetterStructure> wetterStructureListFilter = null;
        for (WetterStructure wetterStructure : wetterStructureList) {
            boolean use = false;
            if (wetterStructure.core().isPresent() && wetterStructure.core().get().blocks().isPresent()) {
                BlockPredicate blockPredicate = wetterStructure.core().get();
                HolderSet holders = (HolderSet)blockPredicate.blocks().get();
                if (holders.contains(state.getBlockHolder()) && (blockPredicate.properties().isEmpty() || ((StatePropertiesPredicate)blockPredicate.properties().get()).matches(state))) {
                    use = true;
                }
            } else {
                use = true;
            }
            if (!use) continue;
            if (wetterStructureListFilter == null) {
                wetterStructureListFilter = new ArrayList<WetterStructure>();
            }
            wetterStructureListFilter.add(wetterStructure);
        }
        return wetterStructureListFilter == null ? List.of() : (wetterStructureList.size() == wetterStructureListFilter.size() ? wetterStructureList : wetterStructureListFilter);
    }

    public static Vec3 getClampedEndPoint(Vec3 centerVec, Vec3 direction, double maxXZDistance, double maxYDistance) {
        if (direction.lengthSqr() == 0.0) {
            return centerVec;
        }
        double dx = direction.x;
        double dy = direction.y;
        double dz = direction.z;
        double scaleX = dx == 0.0 ? Double.POSITIVE_INFINITY : maxXZDistance / Math.abs(dx);
        double scaleZ = dz == 0.0 ? Double.POSITIVE_INFINITY : maxXZDistance / Math.abs(dz);
        double scaleY = dy == 0.0 ? Double.POSITIVE_INFINITY : maxYDistance / Math.abs(dy);
        double scale = Math.min(scaleX, Math.min(scaleZ, scaleY));
        Vec3 scaled = direction.scale(scale);
        return centerVec.add(scaled);
    }

    public static boolean isWithinDistanceForGreenHouseWorker(Vec3 from, Vec3 to, float limit) {
        if (((Boolean)CommonConfig.Crop.useBoxDistance.get()).booleanValue()) {
            return Math.abs(from.x - to.x) < (double)limit + 0.1 && Math.abs(from.z - to.z) < (double)limit + 0.1 && Math.abs(from.y - to.y) < (double)limit + 0.1;
        }
        return from.distanceToSqr(to) < (double)(limit * limit) + 0.1;
    }

    public static List<Component> appendInfo(Level level, BlockState state) {
        List<Season> seasons;
        List<Humidity> humidityList;
        ArrayList<Component> toolTip = new ArrayList<Component>();
        if (!((Boolean)CommonConfig.Crop.enableCropHumidityControl.get()).booleanValue() && !((Boolean)CommonConfig.Crop.enableCrop.get()).booleanValue()) {
            return toolTip;
        }
        Map<Holder<AgroClimaticZone>, CropGrowControl> controlMap = CropGrowthHandler.getControlMap(state.getBlock());
        if (controlMap == null) {
            return toolTip;
        }
        Holder<AgroClimaticZone> defaultAgroClimaticZoneHolder = CropGrowthHandler.getDefaultAgroClimaticZoneHolder((LevelAccessor)level);
        if (defaultAgroClimaticZoneHolder == null) {
            return toolTip;
        }
        if (((Boolean)CommonConfig.Crop.enableCropHumidityControl.get()).booleanValue() && !(humidityList = CropGrowthHandler.getLikeHumidityInTemperate(state, controlMap, defaultAgroClimaticZoneHolder)).isEmpty()) {
            toolTip.addAll(CropHumidityInfo.getTooltip(humidityList.getFirst(), humidityList.getLast()));
        }
        if (((Boolean)CommonConfig.Crop.enableCrop.get()).booleanValue() && !(seasons = CropGrowthHandler.getLikeSeasonsInTemperate(state, controlMap, defaultAgroClimaticZoneHolder)).isEmpty()) {
            toolTip.addAll(CropSeasonInfo.getTooltip(CropSeasonInfo.getSeason(seasons)));
        }
        return toolTip;
    }

    public static enum RoomStatus {
        GREEN_HOUSE,
        NORMAL,
        UNKNOWN;

    }

    public static class SectionClipContext
    extends ClipContext {
        public final List<Pair<SectionPos, LevelChunkSection>> chunkAccessList = new ArrayList<Pair<SectionPos, LevelChunkSection>>(1);

        public SectionClipContext(Vec3 from, Vec3 to, ClipContext.Block block, ClipContext.Fluid fluid, CollisionContext collisionContext) {
            super(from, to, block, fluid, collisionContext);
        }

        public List<Pair<SectionPos, LevelChunkSection>> getChunkAccessList() {
            return this.chunkAccessList;
        }

        public BlockState getBlockState(LevelReader levelAccessor, BlockPos pos) {
            int x = SectionPos.blockToSectionCoord((int)pos.getX());
            int z = SectionPos.blockToSectionCoord((int)pos.getZ());
            int y = SectionPos.blockToSectionCoord((int)pos.getY());
            int size = this.chunkAccessList.size();
            for (int i = 0; i < size; ++i) {
                Pair<SectionPos, LevelChunkSection> chunkAccess = this.chunkAccessList.get(i);
                if (((SectionPos)chunkAccess.getFirst()).x() != x || ((SectionPos)chunkAccess.getFirst()).z() != z || ((SectionPos)chunkAccess.getFirst()).y() != y) continue;
                return ((LevelChunkSection)chunkAccess.getSecond()).getBlockState(pos.getX() & 0xF, pos.getY() & 0xF, pos.getZ() & 0xF);
            }
            ChunkAccess chunk1 = levelAccessor.getChunk(x, z);
            int sectionIndex = chunk1.getSectionIndex(pos.getY());
            LevelChunkSection[] sections = chunk1.getSections();
            if (sectionIndex < 0 || sectionIndex >= sections.length) {
                return Blocks.AIR.defaultBlockState();
            }
            LevelChunkSection chunk = sections[sectionIndex];
            this.chunkAccessList.add((Pair<SectionPos, LevelChunkSection>)Pair.of((Object)SectionPos.of((int)x, (int)y, (int)z), (Object)chunk));
            return chunk.getBlockState(pos.getX() & 0xF, pos.getY() & 0xF, pos.getZ() & 0xF);
        }

        public void release() {
            this.chunkAccessList.clear();
        }
    }

    public record BlockTester(LevelReader levelReader, Optional<BlockPredicate> notCheck) implements BiFunction<SectionClipContext, BlockPos, BlockHitResult>
    {
        @Override
        public BlockHitResult apply(SectionClipContext clipContext, BlockPos pos) {
            if (BlockPos.containing((Position)clipContext.getFrom()).distSqr((Vec3i)pos) == 0.0) {
                return null;
            }
            BlockState blockstate = clipContext.getBlockState(this.levelReader, pos);
            if (!blockstate.isSolid()) {
                return null;
            }
            Vec3 vec3 = clipContext.getFrom();
            Vec3 vec31 = clipContext.getTo();
            VoxelShape voxelshape = clipContext.getBlockShape(blockstate, (BlockGetter)this.levelReader, pos);
            BlockHitResult blockHitResult = voxelshape.clip(vec3, vec31, pos);
            if (blockHitResult != null) {
                clipContext.release();
                if (this.notCheck.isPresent() && this.notCheck.get().blocks().isPresent() && ((HolderSet)this.notCheck.get().blocks().get()).contains(blockstate.getBlockHolder())) {
                    blockHitResult = BlockHitResult.miss((Vec3)blockHitResult.getLocation(), (Direction)blockHitResult.getDirection(), (BlockPos)pos);
                }
            }
            return blockHitResult;
        }
    }

    public static class FailHandler
    implements Function<SectionClipContext, BlockHitResult> {
        @Override
        public BlockHitResult apply(SectionClipContext clipContext) {
            clipContext.release();
            Vec3 vec3 = clipContext.getFrom().subtract(clipContext.getTo());
            return BlockHitResult.miss((Vec3)clipContext.getTo(), (Direction)Direction.getNearest((double)vec3.x, (double)vec3.y, (double)vec3.z), (BlockPos)BlockPos.containing((Position)clipContext.getTo()));
        }
    }

    public static class SClipContext
    extends ClipContext {
        public List<ChunkAccess> chunkAccessList = new ArrayList<ChunkAccess>(1);

        public SClipContext(Vec3 from, Vec3 to, ClipContext.Block block, ClipContext.Fluid fluid, CollisionContext collisionContext) {
            super(from, to, block, fluid, collisionContext);
        }

        public SClipContext(Vec3 from, Vec3 to, ClipContext.Block block, ClipContext.Fluid fluid, Entity entity) {
            super(from, to, block, fluid, entity);
        }

        public BlockState getBlockState(LevelReader levelAccessor, BlockPos pos) {
            int x = SectionPos.blockToSectionCoord((int)pos.getX());
            int z = SectionPos.blockToSectionCoord((int)pos.getZ());
            int y = SectionPos.blockToSectionCoord((int)pos.getY());
            int size = this.chunkAccessList.size();
            for (int i = 0; i < size; ++i) {
                ChunkAccess chunkAccess = this.chunkAccessList.get(i);
                if (chunkAccess.getPos().x != x || chunkAccess.getPos().z != z) continue;
                return chunkAccess.getBlockState(pos);
            }
            ChunkAccess chunk = levelAccessor.getChunk(x, z);
            this.chunkAccessList.add(chunk);
            return chunk.getBlockState(pos);
        }

        public void release() {
            this.chunkAccessList.clear();
        }
    }
}

