/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.crop;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.misc.ESSortInfo;
import com.teamtea.eclipticseasons.api.data.season.definition.ChangeMode;
import com.teamtea.eclipticseasons.api.data.season.definition.ISeasonChangeContext;
import com.teamtea.eclipticseasons.api.data.season.definition.SeasonDefinition;
import com.teamtea.eclipticseasons.api.data.season.definition.selector.IChangeSelector;
import com.teamtea.eclipticseasons.api.misc.BiomeHolderPredicate;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.api.util.SimpleUtil;
import com.teamtea.eclipticseasons.api.util.fast.Enum2ObjectMap;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import com.teamtea.eclipticseasons.config.CommonConfig;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class NaturalPlantHandler {
    public static final Map<Block, EnumMap<SolarTerm, List<Pair<BiomeHolderPredicate, ChangeMode>>>> SEASON_DEFINITIONS = new IdentityHashMap<Block, EnumMap<SolarTerm, List<Pair<BiomeHolderPredicate, ChangeMode>>>>();
    private static final ThreadLocal<ISeasonChangeContext> SEASON_CHANGE_CONTEXT_THREAD_LOCAL = ThreadLocal.withInitial(ISeasonChangeContext::of);

    public static void resetUpdate(RegistryAccess registryAccess, boolean isServer) {
        if (isServer) {
            SEASON_DEFINITIONS.clear();
            Optional registry = registryAccess.registry(ESRegistries.SEASON_DEFINITION);
            if (registry.isEmpty()) {
                SimpleUtil.warningForModWrongCalling(ESRegistries.SEASON_DEFINITION);
            } else {
                for (SeasonDefinition seasonDefinition : ESSortInfo.sorted2((Registry)registry.get())) {
                    Enum2ObjectMap<SolarTerm, List<ChangeMode>> combine = seasonDefinition.changes().combine();
                    combine.forEach((solarTerm, changeModes) -> {
                        for (ChangeMode changeMode : changeModes) {
                            for (Block possibleBlock : changeMode.getPossibleBlocks()) {
                                EnumMap blockMap = SEASON_DEFINITIONS.computeIfAbsent(possibleBlock, b -> new EnumMap(SolarTerm.class));
                                List pairList = blockMap.computeIfAbsent(solarTerm, b -> new ArrayList());
                                if (seasonDefinition.biomes().isPresent()) {
                                    pairList.add(Pair.of((Object)BiomeHolderPredicate.of(seasonDefinition.biomes().get()), (Object)changeMode));
                                    continue;
                                }
                                pairList.add(Pair.of((Object)BiomeHolderPredicate.of(), (Object)changeMode));
                            }
                        }
                    });
                }
            }
        }
    }

    public static void clearOnClientExitOrServerClose() {
        SEASON_DEFINITIONS.clear();
    }

    public static boolean shouldTick(BlockState state) {
        EnumMap map = SEASON_DEFINITIONS.getOrDefault(state.getBlock(), null);
        if (map == null || map.isEmpty()) {
            return false;
        }
        for (List value : map.values()) {
            for (Pair pair : value) {
                if (!((ChangeMode)pair.getSecond()).matchesState(state)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean testChance(long seed, float chance) {
        long mixed = HashCommon.mix((long)seed);
        double rand = (double)(mixed & 0x1FFFFFFFFFFFFFL) / 9.007199254740992E15;
        return rand < (double)chance;
    }

    public static void tickBlock(ServerLevel level, BlockPos pos, BlockState state) {
        EnumMap mapMap;
        SolarTerm nowSolarTerm;
        if (CommonConfig.isSeasonDefinition() && (nowSolarTerm = EclipticUtil.getNowSolarTerm((Level)level)).isValid() && (mapMap = (EnumMap)SEASON_DEFINITIONS.getOrDefault(state.getBlock(), null)) != null) {
            List pairs = mapMap.getOrDefault(nowSolarTerm, null);
            if (pairs == null) {
                return;
            }
            Holder<Biome> cropBiome = null;
            long fixedSeedValue = -1L;
            boolean hasCheckFixedSeed = false;
            int pairsSize = pairs.size();
            for (int i = 0; i < pairsSize; ++i) {
                boolean applied;
                Pair pair = (Pair)pairs.get(i);
                ChangeMode changeMode = (ChangeMode)pair.getSecond();
                if (changeMode.fixedSeed()) {
                    if (!hasCheckFixedSeed) {
                        fixedSeedValue = level.getSeed();
                        fixedSeedValue ^= HashCommon.mix((long)state.getSeed(pos));
                        fixedSeedValue ^= (long)HashCommon.mix((int)EclipticSeasonsApi.getInstance().getSolarDays((Level)level));
                        fixedSeedValue ^= (long)HashCommon.mix((int)EclipticSeasonsApi.getInstance().getTimeInTerm((Level)level));
                        fixedSeedValue ^= (long)HashCommon.mix((int)EclipticSeasonsApi.getInstance().getLastingDaysOfEachTerm((Level)level));
                        hasCheckFixedSeed = true;
                    }
                    if (!NaturalPlantHandler.testChance(fixedSeedValue, changeMode.chance())) {
                        continue;
                    }
                } else if (level.getRandom().nextFloat() >= changeMode.chance()) continue;
                if (!changeMode.matches(state, (Level)level, pos)) continue;
                Holder<Biome> holder = cropBiome = cropBiome == null ? CropGrowthHandler.getCropBiome((LevelAccessor)level, pos) : cropBiome;
                if (!((BiomeHolderPredicate)pair.getFirst()).test(cropBiome)) continue;
                int totalWeight = 0;
                List<IChangeSelector> selectors = changeMode.selectors();
                ISeasonChangeContext context = SEASON_CHANGE_CONTEXT_THREAD_LOCAL.get();
                int selectorsSize = selectors.size();
                for (int j = 0; j < selectorsSize; ++j) {
                    IChangeSelector blockStatePlaced = selectors.get(j);
                    if (!blockStatePlaced.shouldApply((Level)level, pos, context)) continue;
                    totalWeight += blockStatePlaced.getWeight();
                }
                if (totalWeight <= 0) {
                    return;
                }
                int weightIndex = changeMode.fixedSeed() ? Math.floorMod(fixedSeedValue, totalWeight) : level.getRandom().nextInt(totalWeight);
                IChangeSelector chosen = null;
                List<IChangeSelector> selectorsed = changeMode.selectors();
                int selectorsedSize = selectorsed.size();
                for (int j = 0; j < selectorsedSize; ++j) {
                    IChangeSelector blockStatePlaced = selectorsed.get(j);
                    if (!blockStatePlaced.shouldApply((Level)level, pos, context) || (weightIndex -= blockStatePlaced.getWeight()) > 0) continue;
                    chosen = blockStatePlaced;
                    break;
                }
                if (chosen != null && (applied = chosen.place(level, pos, context)) && chosen.getLoot().isPresent() && chosen.dropWhenApplied((Level)level, pos, context)) {
                    NaturalPlantHandler.dropLootTable(level, pos, chosen.getLoot().get(), changeMode.fixedSeed() ? fixedSeedValue : level.getRandom().nextLong(), state);
                }
                return;
            }
        }
    }

    public static boolean setBlockAndSelfCheck(ServerLevel level, BlockPos pos, BlockState chosen) {
        return NaturalPlantHandler.setBlockAndSelfCheck(level, pos, chosen, level.getBlockState(pos));
    }

    public static boolean setBlockAndSelfCheck(ServerLevel level, BlockPos pos, BlockState chosen, BlockState old) {
        boolean set;
        if (old != chosen && (set = level.setBlock(pos, chosen, 2))) {
            SoundType soundType = chosen.getSoundType((LevelReader)level, pos, null);
            if (soundType != null) {
                level.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
            }
            return true;
        }
        return false;
    }

    public static void dropLootTable(ServerLevel level, BlockPos pos, ResourceKey<LootTable> resourcekey, long seed, BlockState state) {
        if (resourcekey != null && level != null) {
            LootTable loottable = level.getServer().reloadableRegistries().getLootTable(resourcekey);
            LootParams.Builder lootparams$builder = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)level.getBlockEntity(pos));
            for (ItemStack randomItem : loottable.getRandomItems(lootparams$builder.create(LootContextParamSets.BLOCK), seed)) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)randomItem);
            }
        }
    }
}

