/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.snow;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.map.ChunkInfoMap;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyMapChecker;
import com.teamtea.eclipticseasons.common.core.snow.WeatherStatusKeeper;
import com.teamtea.eclipticseasons.common.registry.AttachmentRegistry;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import org.jetbrains.annotations.NotNull;

public class SnowyStatusKeeper
implements Cloneable {
    public static final int FLAG_NONE = 0;
    public static final int FLAG_SNOW = 1;
    public static final int FLAG_NOT_RECORD = -1;
    public static final Codec<SnowyStatusKeeper> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)Codec.LONG.listOf().fieldOf("map").forGetter(o -> new ArrayList(o.posMap.keySet())), (App)Codec.BYTE.listOf().optionalFieldOf("status", List.of()).forGetter(o -> o.posMap.values().stream().map(Integer::byteValue).toList())).apply((Applicative)ins, SnowyStatusKeeper::new));
    private final Long2IntLinkedOpenHashMap posMap = new Long2IntLinkedOpenHashMap();
    private final Long2IntLinkedOpenHashMap stepCount = new Long2IntLinkedOpenHashMap();
    private final LongArrayList posListUpdate = new LongArrayList();
    private final IntArrayList statusListUpdate = new IntArrayList();
    private boolean change = false;
    public static final SnowyStatusKeeper EMPTY = SnowyStatusKeeper.create();
    private transient CompoundTag cacheTag = null;

    protected SnowyStatusKeeper() {
        this(List.of(), List.of());
    }

    public static SnowyStatusKeeper create() {
        return new SnowyStatusKeeper();
    }

    public SnowyStatusKeeper(List<Long> posList, List<Byte> status) {
        this.posMap.defaultReturnValue(-1);
        if (posList.size() == status.size() || status.isEmpty()) {
            int pairsSize = posList.size();
            for (int i = 0; i < pairsSize; ++i) {
                Long pair = posList.get(i);
                this.posMap.put(pair.longValue(), status.isEmpty() ? 1 : (int)status.get(i).byteValue());
            }
        }
        this.stepCount.defaultReturnValue(-1);
    }

    public boolean isSnowyBlock(BlockPos pos) {
        return this.getPosMap().containsKey(pos.asLong());
    }

    public void set(BlockPos pos, int flag) {
        long aLong = pos.asLong();
        if (this.set(aLong, flag)) {
            this.posListUpdate.add(aLong);
            this.statusListUpdate.add(flag);
            this.setChange();
            if (!this.stepCount.isEmpty() && flag == 0) {
                this.stepCount.remove(aLong);
            }
        }
    }

    public boolean set(long pos, int flag) {
        return switch (flag) {
            case 0 -> {
                if (this.posMap.remove(pos) != -1) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (this.posMap.put(pos, flag) != flag) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public void stepAndCheck(BlockPos pos) {
        int result;
        long aLong = pos.asLong();
        int n = result = !this.isSnowyBlock(pos) ? 0 : this.stepCount.addTo(aLong, 1);
        if (result > 8) {
            this.set(pos, 0);
        }
    }

    public void updateAndSend(ServerLevel serverLevel, LevelChunk chunk) {
        if (EclipticUtil.canSnowyBlockInteract() && this.change) {
            chunk.setUnsaved(true);
            if (!this.posListUpdate.isEmpty()) {
                chunk.syncData(AttachmentRegistry.SNOWY_STATUS_KEEPER);
                this.posListUpdate.clear();
                this.statusListUpdate.clear();
            }
        }
        this.change = false;
    }

    protected void setChange() {
        this.change = true;
        this.cacheTag = null;
    }

    public void tickChunk(ServerLevel level, LevelChunk chunk, ChunkPos chunkPos, BlockPos checkPos, ChunkInfoMap chunkInfoMap, WeatherStatusKeeper weatherStatusKeeper) {
        if (!EclipticUtil.canSnowyBlockInteract()) {
            return;
        }
        int height = chunkInfoMap.getHeight(checkPos);
        int surfaceHeight = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, checkPos.getX(), checkPos.getZ());
        if (height <= (checkPos = new BlockPos(checkPos.getX(), height < surfaceHeight ? level.getRandom().nextIntBetweenInclusive(0, surfaceHeight - height) + height : height, checkPos.getZ())).getY()) {
            Holder<Biome> biome = MapChecker.getSurfaceBiomeByChunk((Level)level, chunk, checkPos);
            weatherStatusKeeper.getBiomeUse().add(biome);
            BlockState state = chunk.getBlockState(checkPos);
            int flag = MapChecker.getDefaultBlockTypeFlag(state);
            WeatherManager.SnowRenderStatus snowStatus = flag == 0 ? WeatherManager.SnowRenderStatus.SNOW_MELT : WeatherManager.getSnowStatus(level, biome, checkPos, EclipticUtil.isRainingOrSnowingWithSurfaceBiome((Level)level, biome, checkPos));
            boolean forceMelt = false;
            if (snowStatus != WeatherManager.SnowRenderStatus.SNOW_MELT) {
                if (SnowyMapChecker.isTooLight((BlockAndTintGetter)level, checkPos, state, flag)) {
                    snowStatus = WeatherManager.SnowRenderStatus.SNOW_MELT;
                    forceMelt = true;
                }
                if (!forceMelt && !MapChecker.notLightAbove((Level)level, checkPos, 4)) {
                    snowStatus = WeatherManager.SnowRenderStatus.SNOW_MELT;
                    forceMelt = true;
                }
            }
            switch (snowStatus) {
                case SNOW: {
                    if ((long)WeatherManager.getSnowDepthAtBiome((Level)level, (Biome)biome.value()) <= Math.abs(state.getSeed(checkPos) % 100L)) break;
                    this.set(checkPos, 1);
                    break;
                }
                case SNOW_MELT: {
                    if (!forceMelt && (long)WeatherManager.getSnowDepthAtBiome((Level)level, (Biome)biome.value()) > Math.abs(state.getSeed(checkPos) % 100L) || chunk.getBlockState(checkPos).is(BlockTags.SNOW)) break;
                    this.set(checkPos, 0);
                }
            }
        }
    }

    public boolean checkPosValid(ChunkAccess chunk) {
        boolean anyIllgegalPos = false;
        ChunkPos chunkPos = chunk.getPos();
        int startX = chunkPos.getMinBlockX();
        int startZ = chunkPos.getMinBlockZ();
        int endX = chunkPos.getMaxBlockX();
        int endZ = chunkPos.getMaxBlockZ();
        int minBuildHeight = chunk.getMinBuildHeight();
        int maxBuildHeight = chunk.getMaxBuildHeight();
        LongIterator it = this.getPosMap().keySet().longIterator();
        while (it.hasNext()) {
            long key = it.nextLong();
            int x = BlockPos.getX((long)key);
            int z = BlockPos.getZ((long)key);
            int y = BlockPos.getY((long)key);
            boolean valid = x >= startX && x <= endX && z >= startZ && z <= endZ && y >= minBuildHeight && y < maxBuildHeight;
            if (valid) continue;
            it.remove();
            anyIllgegalPos = true;
        }
        if (anyIllgegalPos) {
            this.setChange();
        }
        return !anyIllgegalPos;
    }

    public SnowyStatusKeeper clone() {
        SnowyStatusKeeper newKepper = SnowyStatusKeeper.create();
        newKepper.posMap.putAll((Map)this.posMap);
        return newKepper;
    }

    @Generated
    public Long2IntLinkedOpenHashMap getPosMap() {
        return this.posMap;
    }

    @Generated
    public Long2IntLinkedOpenHashMap getStepCount() {
        return this.stepCount;
    }

    @Generated
    public LongArrayList getPosListUpdate() {
        return this.posListUpdate;
    }

    @Generated
    public IntArrayList getStatusListUpdate() {
        return this.statusListUpdate;
    }

    @Generated
    public boolean isChange() {
        return this.change;
    }

    @Generated
    public void setChange(boolean change) {
        this.change = change;
    }

    @Generated
    public void setCacheTag(CompoundTag cacheTag) {
        this.cacheTag = cacheTag;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnowyStatusKeeper)) {
            return false;
        }
        SnowyStatusKeeper other = (SnowyStatusKeeper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isChange() != other.isChange()) {
            return false;
        }
        Long2IntLinkedOpenHashMap this$posMap = this.getPosMap();
        Long2IntLinkedOpenHashMap other$posMap = other.getPosMap();
        if (this$posMap == null ? other$posMap != null : !this$posMap.equals(other$posMap)) {
            return false;
        }
        Long2IntLinkedOpenHashMap this$stepCount = this.getStepCount();
        Long2IntLinkedOpenHashMap other$stepCount = other.getStepCount();
        if (this$stepCount == null ? other$stepCount != null : !this$stepCount.equals(other$stepCount)) {
            return false;
        }
        LongArrayList this$posListUpdate = this.getPosListUpdate();
        LongArrayList other$posListUpdate = other.getPosListUpdate();
        if (this$posListUpdate == null ? other$posListUpdate != null : !this$posListUpdate.equals(other$posListUpdate)) {
            return false;
        }
        IntArrayList this$statusListUpdate = this.getStatusListUpdate();
        IntArrayList other$statusListUpdate = other.getStatusListUpdate();
        return !(this$statusListUpdate == null ? other$statusListUpdate != null : !this$statusListUpdate.equals(other$statusListUpdate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnowyStatusKeeper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isChange() ? 79 : 97);
        Long2IntLinkedOpenHashMap $posMap = this.getPosMap();
        result = result * 59 + ($posMap == null ? 43 : $posMap.hashCode());
        Long2IntLinkedOpenHashMap $stepCount = this.getStepCount();
        result = result * 59 + ($stepCount == null ? 43 : $stepCount.hashCode());
        LongArrayList $posListUpdate = this.getPosListUpdate();
        result = result * 59 + ($posListUpdate == null ? 43 : $posListUpdate.hashCode());
        IntArrayList $statusListUpdate = this.getStatusListUpdate();
        result = result * 59 + ($statusListUpdate == null ? 43 : $statusListUpdate.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SnowyStatusKeeper(posMap=" + String.valueOf(this.getPosMap()) + ", stepCount=" + String.valueOf(this.getStepCount()) + ", posListUpdate=" + String.valueOf(this.getPosListUpdate()) + ", statusListUpdate=" + String.valueOf(this.getStatusListUpdate()) + ", change=" + this.isChange() + ")";
    }

    public static class Serializer
    implements IAttachmentSerializer<Tag, SnowyStatusKeeper> {
        @NotNull
        public SnowyStatusKeeper read(@NotNull IAttachmentHolder holder, @NotNull Tag tag, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            if (!EclipticUtil.canSnowyBlockInteract()) {
                return SnowyStatusKeeper.create();
            }
            Optional result = CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result();
            return result.orElseGet(SnowyStatusKeeper::create);
        }

        public Tag write(@NotNull SnowyStatusKeeper attachment, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            if (!EclipticUtil.canSnowyBlockInteract()) {
                new CompoundTag();
            }
            if (attachment.cacheTag != null) {
                return attachment.cacheTag;
            }
            Optional result = CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)attachment).result();
            Object var5_4 = result.orElse(null);
            if (var5_4 instanceof CompoundTag) {
                CompoundTag compoundTag;
                attachment.cacheTag = compoundTag = (CompoundTag)var5_4;
                return compoundTag;
            }
            return new CompoundTag();
        }
    }
}

