/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.solar;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.event.SolarTermChangeEvent;
import com.teamtea.eclipticseasons.api.util.SimpleUtil;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.core.crop.GreenHouseCoreProvider;
import com.teamtea.eclipticseasons.common.core.crop.HumidityControlProvider;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.network.SimpleNetworkHandler;
import com.teamtea.eclipticseasons.common.network.message.SolarTermsMessage;
import com.teamtea.eclipticseasons.common.network.message.UpdateTempChangeMessage;
import com.teamtea.eclipticseasons.config.CommonConfig;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class SolarDataManager
extends SavedData {
    protected final int startSolarTermsDay;
    protected int solarTermsDay;
    protected int solarTermsTicks;
    private int biomeDataVersion;
    protected boolean isValidDimension;
    protected float solarTempChange;
    protected WeakReference<Level> levelWeakReference;
    private final Long2ObjectOpenHashMap<List<Pair<BlockPos, HumidityControlProvider>>> humidityCoreMap;
    private final Long2ObjectOpenHashMap<List<Pair<BlockPos, GreenHouseCoreProvider>>> greenHouseCoreMap;
    private final Long2LongOpenHashMap needTickMap;
    private final Long2ObjectOpenHashMap<BlockState> skipNextCheckInTickPosMap;
    public static final String KEY_ATTACH_SOLAR_DATA = EclipticSeasons.rl("attach_solar_data").toString();

    public SolarDataManager(Level level) {
        this.solarTermsDay = this.startSolarTermsDay = ((Integer)CommonConfig.Season.initialSolarTermIndex.get() - 1) * (Integer)CommonConfig.Season.lastingDaysOfEachTerm.get();
        this.solarTermsTicks = 0;
        this.biomeDataVersion = 0;
        this.isValidDimension = false;
        this.solarTempChange = 0.0f;
        this.levelWeakReference = new WeakReference<Level>(level);
        this.humidityCoreMap = new Long2ObjectOpenHashMap();
        this.greenHouseCoreMap = new Long2ObjectOpenHashMap();
        this.needTickMap = new Long2LongOpenHashMap();
        this.isValidDimension = MapChecker.isValidDimension(level);
        this.skipNextCheckInTickPosMap = new Long2ObjectOpenHashMap();
        this.solarTempChange = this.createTempChange(level);
    }

    protected float createTempChange(Level level) {
        return this.isValidDimension() ? (float)Mth.clamp((double)(level.getRandom().nextGaussian() * 0.125), (double)-0.25, (double)0.25) : 0.0f;
    }

    public SolarDataManager(Level level, CompoundTag nbt) {
        this(level);
        this.setSolarTermsDay(nbt.getInt("SolarTermsDay"));
        this.setSolarTermsTicks(nbt.getInt("SolarTermsTicks"));
        if (nbt.contains("SolarTempChange")) {
            this.setSolarTempChange(nbt.getFloat("SolarTempChange"));
        }
        this.biomeDataVersion = nbt.getInt("BiomeDataVersion");
        this.setLevelData(nbt);
    }

    protected void setLevelData(CompoundTag nbt) {
        if (this.levelWeakReference.get() != null) {
            ListTag listTag = nbt.getList("biomes", 10);
            ArrayList<WeatherManager.BiomeWeather> biomeWeathers = WeatherManager.getBiomeList((Level)this.levelWeakReference.get());
            int countCheck = 0;
            block0: for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compound = listTag.getCompound(i);
                String location = compound.getString("biome");
                if (biomeWeathers == null) continue;
                for (int j = 0; j < biomeWeathers.size(); ++j) {
                    WeatherManager.BiomeWeather biomeWeather = biomeWeathers.get(j);
                    if (!location.equals(biomeWeather.location.toString())) continue;
                    biomeWeather.deserializeNBT(compound);
                    if (i != j) continue block0;
                    ++countCheck;
                    continue block0;
                }
            }
            if (countCheck != listTag.size()) {
                ++this.biomeDataVersion;
                EclipticSeasons.logger("Warning for biome date need to be update with", listTag.size(), biomeWeathers == null ? 0 : biomeWeathers.size(), " new version is", this.biomeDataVersion);
            }
        }
    }

    public static SolarDataManager get(ServerLevel serverLevel) {
        DimensionDataStorage storage = serverLevel.getDataStorage();
        return (SolarDataManager)storage.computeIfAbsent(new SavedData.Factory(() -> SolarDataManager.create(serverLevel), (compoundTag, provider) -> SolarDataManager.load(serverLevel, compoundTag, provider)), "eclipticseasons");
    }

    private static SolarDataManager load(ServerLevel serverLevel, CompoundTag compoundTag, HolderLookup.Provider provider) {
        return new SolarDataManager((Level)serverLevel, compoundTag);
    }

    private static SolarDataManager create(ServerLevel serverLevel) {
        SolarDataManager manager = new SolarDataManager((Level)serverLevel);
        WeatherManager.initNewWorldWeather(serverLevel, serverLevel.random, manager.getSolarTerm());
        return manager;
    }

    public void updateTicks(ServerLevel world) {
        ++this.solarTermsTicks;
        int dayTime = Math.toIntExact(world.getDayTime() % 24000L);
        if (this.solarTermsTicks > dayTime + 100) {
            this.setSolarTermsDay(this.getSolarTermsDay() + 1);
            this.sendAndUpdate(world);
        }
        this.solarTermsTicks = dayTime;
        this.setDirty();
    }

    public boolean isValidDimension() {
        return this.isValidDimension;
    }

    public int getSolarTermIndex() {
        if (!this.isValidDimension()) {
            return SolarTerm.NONE.ordinal();
        }
        return (this.getSolarTermsDay() / (Integer)CommonConfig.Season.lastingDaysOfEachTerm.get() % 24 + 24) % 24;
    }

    public SolarTerm getSolarTerm() {
        return SolarTerm.get(this.getSolarTermIndex());
    }

    public SolarTerm getNextSolarTerm() {
        if (!this.isValidDimension()) {
            return SolarTerm.NONE;
        }
        return SolarTerm.get((this.getSolarTermIndex() + 1) % 24);
    }

    public int getSolarTermDaysInPeriod() {
        return Math.abs(this.getSolarTermsDay() % this.getSolarTermLastingDays());
    }

    public int getSolarTermLastingDays() {
        return (Integer)CommonConfig.Season.lastingDaysOfEachTerm.get();
    }

    public boolean isTodayLastDay() {
        int longTime = this.getSolarTermLastingDays();
        return (this.getSolarTermsDay() + 1) % longTime == 0;
    }

    public int getSolarYear() {
        return !this.isValidDimension() ? 0 : (this.getSolarTermsDay() - 0) / (24 * this.getSolarTermLastingDays()) + 1;
    }

    public int getSolarTermsDay() {
        return this.solarTermsDay;
    }

    public int getSolarTermsTicks() {
        return this.solarTermsTicks;
    }

    public int getBiomeDataVersion() {
        return this.biomeDataVersion;
    }

    public float getSolarTempChange() {
        return this.solarTempChange;
    }

    public void setSolarTermsDay(int solarTermsDay) {
        this.solarTermsDay = solarTermsDay;
        this.setDirty();
    }

    public void setSolarTermsTicks(int solarTermsTicks) {
        this.solarTermsTicks = solarTermsTicks;
        this.setDirty();
    }

    public void setSolarTempChange(float solarTempChange) {
        this.solarTempChange = solarTempChange;
        this.setDirty();
    }

    public void addHumidityControlProvider(BlockPos pos, HumidityControlProvider humidityControlProvider) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ArrayList<Pair> blockPosBlockStateMap = (ArrayList<Pair>)this.humidityCoreMap.get(chunkPos.toLong());
        if (blockPosBlockStateMap == null) {
            blockPosBlockStateMap = new ArrayList<Pair>();
            this.humidityCoreMap.put(chunkPos.toLong(), blockPosBlockStateMap);
        }
        for (int i = 0; i < blockPosBlockStateMap.size(); ++i) {
            Pair p = (Pair)blockPosBlockStateMap.get(i);
            if (!((BlockPos)p.first()).equals((Object)pos)) continue;
            if (p.second() != humidityControlProvider) {
                blockPosBlockStateMap.set(i, Pair.of((Object)pos, (Object)humidityControlProvider));
            }
            return;
        }
        blockPosBlockStateMap.add(Pair.of((Object)pos, (Object)humidityControlProvider));
    }

    public void addGreenHouseCoreProvider(BlockPos pos, GreenHouseCoreProvider provider) {
        this.addGreenHouseCoreProvider(pos, provider, SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
    }

    @ApiStatus.Experimental
    private void addGreenHouseCoreProvider(BlockPos pos, GreenHouseCoreProvider provider, int chunkX, int chunkZ) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        ArrayList<Pair> blockPosBlockStateMap = (ArrayList<Pair>)this.greenHouseCoreMap.get(chunkPos.toLong());
        if (blockPosBlockStateMap == null) {
            blockPosBlockStateMap = new ArrayList<Pair>();
            this.greenHouseCoreMap.put(chunkPos.toLong(), blockPosBlockStateMap);
        }
        for (int i = 0; i < blockPosBlockStateMap.size(); ++i) {
            Pair p = (Pair)blockPosBlockStateMap.get(i);
            if (!((BlockPos)p.first()).equals((Object)pos)) continue;
            if (((GreenHouseCoreProvider)p.second()).getSeason() == provider.getSeason()) {
                ((GreenHouseCoreProvider)p.second()).addAvailCost(provider.getAvailCost());
            }
            return;
        }
        blockPosBlockStateMap.add(Pair.of((Object)pos, (Object)provider));
    }

    public void unloadChunk(ChunkPos chunkPos) {
        this.humidityCoreMap.remove(chunkPos.toLong());
        this.greenHouseCoreMap.remove(chunkPos.toLong());
        this.needTickMap.remove(chunkPos.toLong());
    }

    public HumidityControlProvider queryHumidityControlProvider(BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        List lis = (List)this.humidityCoreMap.getOrDefault(chunkPos.toLong(), null);
        if (lis != null) {
            int lisSize = lis.size();
            for (int i = 0; i < lisSize; ++i) {
                Pair p = (Pair)lis.get(i);
                if (!((BlockPos)p.first()).equals((Object)blockPos)) continue;
                return (HumidityControlProvider)p.second();
            }
        }
        return null;
    }

    public HumidityControlProvider removeHumidityControlProvider(BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        List lis = (List)this.humidityCoreMap.getOrDefault(chunkPos.toLong(), null);
        if (lis != null) {
            int lisSize = lis.size();
            for (int i = 0; i < lisSize; ++i) {
                Pair p = (Pair)lis.get(i);
                if (!((BlockPos)p.first()).equals((Object)blockPos)) continue;
                lis.remove(i);
                if (lis.isEmpty()) {
                    this.greenHouseCoreMap.remove(chunkPos.toLong());
                }
                return (HumidityControlProvider)p.second();
            }
        }
        return null;
    }

    public float calculateHumidityModification(BlockPos blockPos) {
        return this.calculateHumidityModification(blockPos, true);
    }

    public float calculateHumidityModification(BlockPos blockPos, boolean growPlus) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        Vec3 center = blockPos.getCenter();
        int localX = blockPos.getX() & 0xF;
        int localZ = blockPos.getZ() & 0xF;
        boolean isLeftBorder = localX <= 6;
        boolean isRightBorder = localX >= 7;
        boolean isFrontBorder = localZ <= 6;
        boolean isBackBorder = localZ >= 7;
        float result = 0.0f;
        for (int dx = isLeftBorder ? -1 : 0; dx <= (isRightBorder ? 1 : 0); ++dx) {
            for (int dz = isFrontBorder ? -1 : 0; dz <= (isBackBorder ? 1 : 0); ++dz) {
                ChunkPos currentChunkPos = new ChunkPos(chunkPos.x + dx, chunkPos.z + dz);
                List lis = (List)this.humidityCoreMap.getOrDefault(currentChunkPos.toLong(), null);
                if (lis == null) continue;
                for (Pair p : lis) {
                    if (!CropGrowthHandler.isWithinDistanceForGreenHouseWorker(center, ((BlockPos)p.first()).getCenter(), ((HumidityControlProvider)p.second()).getRange())) continue;
                    result += ((HumidityControlProvider)p.second()).getLevel();
                }
            }
        }
        return result;
    }

    public GreenHouseCoreProvider queryGreenHouseProvider(BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        List lis = (List)this.greenHouseCoreMap.getOrDefault(chunkPos.toLong(), null);
        if (lis != null) {
            int lisSize = lis.size();
            for (int i = 0; i < lisSize; ++i) {
                Pair p = (Pair)lis.get(i);
                if (!((BlockPos)p.first()).equals((Object)blockPos)) continue;
                return (GreenHouseCoreProvider)p.second();
            }
        }
        return null;
    }

    public GreenHouseCoreProvider removeGreenHouseProvider(BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        List lis = (List)this.greenHouseCoreMap.getOrDefault(chunkPos.toLong(), null);
        if (lis != null) {
            int lisSize = lis.size();
            for (int i = 0; i < lisSize; ++i) {
                Pair p = (Pair)lis.get(i);
                if (!((BlockPos)p.first()).equals((Object)blockPos)) continue;
                lis.remove(i);
                if (lis.isEmpty()) {
                    this.greenHouseCoreMap.remove(chunkPos.toLong());
                }
                return (GreenHouseCoreProvider)p.second();
            }
        }
        return null;
    }

    public GreenHouseCoreProvider findNearGreenHouseProvider(BlockPos blockPos, List<Season> seasons) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        Vec3 center = blockPos.getCenter();
        int d = (Integer)CommonConfig.Crop.seasonCoreRange.get() / 16 + 1;
        for (int r = 0; r <= d; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    ChunkPos currentChunkPos;
                    GreenHouseCoreProvider greenHouseCoreProvider;
                    if (dx != -r && dx != r && dz != -r && dz != r || (greenHouseCoreProvider = this.checkSeasonProviderInChunk(seasons, currentChunkPos = new ChunkPos(chunkPos.x + dx, chunkPos.z + dz), center)) == null) continue;
                    return greenHouseCoreProvider;
                }
            }
        }
        return null;
    }

    protected GreenHouseCoreProvider checkSeasonProviderInChunk(List<Season> seasons, ChunkPos currentChunkPos, Vec3 center) {
        GreenHouseCoreProvider greenHouseCoreProvider = null;
        List lis = (List)this.greenHouseCoreMap.getOrDefault(currentChunkPos.toLong(), null);
        if (lis != null) {
            int seasonCoreRange = (Integer)CommonConfig.Crop.seasonCoreRange.get();
            for (Pair p : lis) {
                if (!seasons.contains(((GreenHouseCoreProvider)p.second()).getSeason()) || !CropGrowthHandler.isWithinDistanceForGreenHouseWorker(center, ((BlockPos)p.first()).getCenter(), seasonCoreRange)) continue;
                greenHouseCoreProvider = (GreenHouseCoreProvider)p.second();
                break;
            }
        }
        return greenHouseCoreProvider;
    }

    public void tickChunk(LevelChunk chunk) {
        if (this.humidityCoreMap.isEmpty()) {
            return;
        }
        ChunkPos pos = chunk.getPos();
        List list = (List)this.humidityCoreMap.get(pos.toLong());
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Pair pair = (Pair)list.get(i);
                if (((HumidityControlProvider)pair.second()).getRemainTime() <= 0) {
                    list.remove(i);
                    --i;
                    continue;
                }
                ((HumidityControlProvider)pair.second()).addRemainTime(-1);
            }
            if (list.isEmpty()) {
                this.humidityCoreMap.remove(pos.toLong());
            }
        }
    }

    public void sendAndUpdate(ServerLevel world) {
        boolean changeSolarTerm = this.getSolarTermsDay() % (Integer)CommonConfig.Season.lastingDaysOfEachTerm.get() == 0;
        boolean updateTempChange = false;
        SolarTerm solarTerm = this.getSolarTerm();
        if (changeSolarTerm) {
            SolarTerm old = SolarTerm.collectValues()[(this.getSolarTermIndex() + 24) % 24];
            NeoForge.EVENT_BUS.post((Event)new SolarTermChangeEvent(old, solarTerm, (Level)world, this.solarTermsDay));
            if (solarTerm == SolarTerm.SUMMER_SOLSTICE) {
                this.setSolarTempChange(this.createTempChange((Level)world));
                updateTempChange = true;
            }
        }
        if (solarTerm != SolarTerm.NONE) {
            for (ServerPlayer player : world.players()) {
                SimpleNetworkHandler.send(player, new SolarTermsMessage(this.getSolarTermsDay()));
                if (changeSolarTerm && ((Boolean)CommonConfig.Season.enableInform.get()).booleanValue()) {
                    SimpleUtil.sendSolarTermMessage(player, solarTerm, false);
                }
                if (updateTempChange) {
                    SimpleNetworkHandler.send(player, new UpdateTempChangeMessage(this.getSolarTempChange()));
                }
                if (!changeSolarTerm) continue;
                WeatherManager.tickPlayerForSeasonCheck(player, solarTerm);
            }
        }
    }

    @NotNull
    public CompoundTag save(CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        ArrayList<WeatherManager.BiomeWeather> list;
        compound.putInt("SolarTermsDay", this.getSolarTermsDay());
        compound.putInt("SolarTermsTicks", this.getSolarTermsTicks());
        compound.putFloat("SolarTempChange", this.getSolarTempChange());
        ListTag listTag = new ListTag();
        if (this.levelWeakReference.get() != null && (list = WeatherManager.getBiomeList((Level)this.levelWeakReference.get())) != null) {
            for (WeatherManager.BiomeWeather biomeWeather : list) {
                listTag.add((Object)biomeWeather.serializeNBT());
            }
        }
        compound.put("biomes", (Tag)listTag);
        compound.putInt("BiomeDataVersion", this.biomeDataVersion);
        return compound;
    }

    public boolean shouldTickChunk(ChunkPos chunkPos) {
        return this.needTickMap.containsKey(chunkPos.toLong());
    }

    public void tickLevel(ServerLevel level) {
        this.skipNextCheckInTickPosMap.clear();
        if (MapChecker.isValidDimension((Level)level)) {
            this.updateTicks(level);
        }
    }

    public BlockState addSkipNextCheck(BlockPos blockPos, BlockState blockState) {
        return (BlockState)this.skipNextCheckInTickPosMap.put(blockPos.asLong(), (Object)blockState);
    }

    public boolean shouldSkipNextCheck(BlockPos blockPos) {
        return this.skipNextCheckInTickPosMap.containsKey(blockPos.asLong());
    }

    public void saveChunk(ChunkPos pos, CompoundTag data) {
        Level level = (Level)this.levelWeakReference.get();
        if (level == null) {
            return;
        }
        if (!((Boolean)CommonConfig.Crop.saveChunkEnvironmentalHumidity.get()).booleanValue()) {
            return;
        }
        List list = (List)this.humidityCoreMap.getOrDefault(pos.toLong(), null);
        if (list != null) {
            ListTag compoundTag = new ListTag();
            for (Pair pair : list) {
                if (!((HumidityControlProvider)pair.right()).shouldSave()) continue;
                CompoundTag ct = new CompoundTag();
                ct.putLong("pos", ((BlockPos)pair.left()).asLong());
                ct.put("humidity_modifiers", (Tag)((HumidityControlProvider)pair.right()).serializeNBT((HolderLookup.Provider)level.registryAccess()));
                compoundTag.add((Object)ct);
            }
            if (!compoundTag.isEmpty()) {
                data.put(KEY_ATTACH_SOLAR_DATA, (Tag)compoundTag);
            }
        }
    }

    public void loadChunk(ChunkPos pos, CompoundTag data) {
        Level level = (Level)this.levelWeakReference.get();
        if (level == null) {
            return;
        }
        if (!data.contains(KEY_ATTACH_SOLAR_DATA)) {
            return;
        }
        ListTag attachSolarData = data.getList(KEY_ATTACH_SOLAR_DATA, 10);
        for (Tag attachSolarDatum : attachSolarData) {
            CompoundTag compoundTag = (CompoundTag)attachSolarDatum;
            long aLong = compoundTag.getLong("pos");
            BlockPos blockPos = BlockPos.of((long)aLong);
            CompoundTag humidity_modifier = compoundTag.getCompound("humidity_modifiers");
            if (humidity_modifier.isEmpty()) continue;
            HumidityControlProvider humidityControlProvider = new HumidityControlProvider(0.0f, 0.0f, 0, true);
            humidityControlProvider.deserializeNBT((HolderLookup.Provider)level.registryAccess(), humidity_modifier);
            this.addHumidityControlProvider(blockPos, humidityControlProvider);
        }
    }
}

