/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.solar;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.constant.solar.ISolarTerm;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.season.SeasonPhase;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.biome.BiomeClimateManager;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class SolarTermHelper {
    private static Map<SolarTerm, Holder<SeasonPhase>> getSolarTermHolderMap(Biome biome, boolean isServer) {
        return (isServer ? BiomeClimateManager.SEASON_PHASE_MAP : BiomeClimateManager.CLIENT_SEASON_PHASE_MAP).get(biome);
    }

    @Nonnull
    public static ISolarTerm get(Level level, BlockPos pos) {
        SolarTerm nowSolarTerm = EclipticUtil.getNowSolarTerm(level);
        Biome biome = (Biome)CropGrowthHandler.getCropBiome((LevelAccessor)level, pos).value();
        Map<SolarTerm, Holder<SeasonPhase>> solarTermHolderMap = SolarTermHelper.getSolarTermHolderMap(biome, level instanceof ServerLevel);
        return SolarTermHelper.get(solarTermHolderMap, nowSolarTerm);
    }

    @Nonnull
    public static ISolarTerm get(Level level, BlockPos pos, SolarTerm nowSolarTerm) {
        Biome biome = (Biome)CropGrowthHandler.getCropBiome((LevelAccessor)level, pos).value();
        Map<SolarTerm, Holder<SeasonPhase>> solarTermHolderMap = SolarTermHelper.getSolarTermHolderMap(biome, level instanceof ServerLevel);
        return SolarTermHelper.get(solarTermHolderMap, nowSolarTerm);
    }

    @Nonnull
    public static ISolarTerm get(Holder<Biome> biome, SolarTerm nowSolarTerm) {
        Map<SolarTerm, Holder<SeasonPhase>> solarTermHolderMap = SolarTermHelper.getSolarTermHolderMap((Biome)biome.value(), BiomeClimateManager.isServerInstance((Biome)biome.value()));
        return SolarTermHelper.get(solarTermHolderMap, nowSolarTerm);
    }

    @Nonnull
    public static ISolarTerm get(Map<SolarTerm, Holder<SeasonPhase>> solarTermHolderMap, SolarTerm nowSolarTerm) {
        return (Boolean)CommonConfig.Season.enableLocalInfoCalendar.get() != false && solarTermHolderMap != null && solarTermHolderMap.containsKey(nowSolarTerm) ? (ISolarTerm)solarTermHolderMap.get(nowSolarTerm).value() : nowSolarTerm;
    }

    @Nonnull
    public static ISolarTerm getNext(Holder<Biome> biome, SolarTerm nowSolarTerm) {
        return (ISolarTerm)SolarTermHelper.getNextTermAndStart(biome, nowSolarTerm).getSecond();
    }

    public static SolarTerm getNextStartTerm(Holder<Biome> biome, SolarTerm nowSolarTerm) {
        return (SolarTerm)SolarTermHelper.getNextTermAndStart(biome, nowSolarTerm).getFirst();
    }

    public static Pair<SolarTerm, ISolarTerm> getNextTermAndStart(Holder<Biome> biome, SolarTerm nowSolarTerm) {
        Map<SolarTerm, Holder<SeasonPhase>> solarTermHolderMap = SolarTermHelper.getSolarTermHolderMap((Biome)biome.value(), BiomeClimateManager.isServerInstance((Biome)biome.value()));
        ISolarTerm iSolarTerm = SolarTermHelper.get(solarTermHolderMap, nowSolarTerm);
        SolarTerm solarTermNext = nowSolarTerm.getNextSolarTerm();
        ISolarTerm iSolarTermNext = SolarTermHelper.get(solarTermHolderMap, solarTermNext);
        for (int count = 0; count < 24 && iSolarTermNext == iSolarTerm; ++count) {
            solarTermNext = solarTermNext.getNextSolarTerm();
            iSolarTermNext = SolarTermHelper.get(solarTermHolderMap, solarTermNext);
        }
        return Pair.of((Object)solarTermNext, (Object)iSolarTermNext);
    }

    public static boolean isChanged(Level level, BlockPos pos, SolarTerm solarTerm, SolarTerm solarTermLast) {
        Holder<Biome> biome = CropGrowthHandler.getCropBiome((LevelAccessor)level, pos);
        return SolarTermHelper.get(biome, solarTerm) == SolarTermHelper.get(biome, solarTermLast);
    }

    @Nullable
    public static ISolarTerm isChangedAndGet(Level level, BlockPos pos, SolarTerm solarTerm, SolarTerm solarTermLast, boolean ignoreChangeCheck) {
        Holder<Biome> biome = CropGrowthHandler.getCropBiome((LevelAccessor)level, pos);
        ISolarTerm iSolarTerm = SolarTermHelper.get(biome, solarTerm);
        if (ignoreChangeCheck || iSolarTerm != SolarTermHelper.get(biome, solarTermLast)) {
            return iSolarTerm;
        }
        return null;
    }
}

