/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.item;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.constant.biome.Humidity;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.data.crop.CropGrow;
import com.teamtea.eclipticseasons.api.data.crop.CropGrowControl;
import com.teamtea.eclipticseasons.api.data.crop.GrowParameter;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class GrowthDetectorItem
extends Item {
    public GrowthDetectorItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos clickedPos;
        Level level;
        BlockState state;
        Player player = context.getPlayer();
        if (player != null && !(state = (level = context.getLevel()).getBlockState(clickedPos = context.getClickedPos())).isAir() && CropGrowthHandler.getControlMap(state.getBlock()) != null) {
            if (level instanceof ServerLevel) {
                int i;
                Map<Holder<AgroClimaticZone>, CropGrowControl> controlMap;
                ServerLevel serverLevel = (ServerLevel)level;
                MutableComponent component = Component.translatable((String)"item.eclipticseasons.growth_detector.hint.title");
                Holder<Biome> biomeHolder = CropGrowthHandler.getCropBiome((LevelAccessor)level, clickedPos);
                Holder<AgroClimaticZone> climateTypeHolder = CropGrowthHandler.getclimateTypeHolder(biomeHolder);
                if (climateTypeHolder != null) {
                    component.append((Component)Component.translatable((String)"item.eclipticseasons.growth_detector.hint.agro_climatic_zone", (Object[])new Object[]{Component.translatable((String)AgroClimaticZone.getDescriptionId(EclipticSeasons.parse(climateTypeHolder.getRegisteredName())))}));
                }
                if ((controlMap = CropGrowthHandler.getControlMap(state.getBlock())) == null) {
                    return super.useOn(context);
                }
                CropGrowControl growControl = CropGrowthHandler.getCropGrowControl(controlMap, climateTypeHolder);
                Holder<AgroClimaticZone> agent = CropGrowthHandler.getDefaultAgroClimaticZoneHolder((LevelAccessor)level);
                if (growControl == null) {
                    growControl = CropGrowthHandler.getCropGrowControl(controlMap, agent);
                }
                if (growControl != null && growControl.base().equals(CropGrow.EMPTY) && (growControl.blocks().isEmpty() || !growControl.blocks().get().containsKey(state))) {
                    return super.useOn(context);
                }
                float chance = 0.0f;
                int chose = 0;
                if (growControl != null) {
                    for (i = 0; i < 100; ++i) {
                        chance += CropGrowthHandler.isInRoom((LevelAccessor)level, clickedPos, state, growControl.notGreenHouse()) ? 1.0f : 0.0f;
                    }
                    chose = chance > 50.0f ? 1 : (chance > 10.0f ? 2 : 3);
                    component.append((Component)Component.translatable((String)("item.eclipticseasons.growth_detector.hint.greenroom_" + chose), (Object[])new Object[]{state.getBlock().getName()}));
                }
                chance = 0.0f;
                for (i = 0; i < 100; ++i) {
                    chance += GrowthDetectorItem.getGrowChance(level, clickedPos, state);
                }
                int n = chance > 80.0f ? 1 : (chance > 60.0f ? 2 : (chance > 40.0f ? 3 : (chance > 20.0f ? 4 : (chose = chance > 0.0f ? 5 : 6))));
                if (chance <= 40.0f) {
                    List<Humidity> humidityList;
                    SolarDataManager saveData;
                    List<Season> seasons = CropGrowthHandler.getLikeSeasonsInTemperate(state, controlMap, agent);
                    if (!seasons.isEmpty() && (saveData = SolarHolders.getSaveData(level)) != null && saveData.findNearGreenHouseProvider(clickedPos, seasons) == null) {
                        component.append((Component)Component.translatable((String)"item.eclipticseasons.growth_detector.hint.season_core"));
                    }
                    if (!(humidityList = CropGrowthHandler.getLikeHumidityInTemperate(state, controlMap, agent)).isEmpty() && !humidityList.contains(EclipticSeasonsApi.getInstance().getAdjustedHumidity(serverLevel, clickedPos))) {
                        component.append((Component)Component.translatable((String)"item.eclipticseasons.growth_detector.hint.humidity"));
                    }
                }
                component.append((Component)Component.translatable((String)("item.eclipticseasons.growth_detector.hint.grow_chance_" + chose), (Object[])new Object[]{Float.valueOf(chance)}));
                player.sendSystemMessage((Component)component);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useOn(context);
    }

    public static float getGrowChance(Level level, BlockPos pos, BlockState blockState) {
        CropGrowthHandler.RoomStatus roomStatus;
        float result = 1.0f;
        Block block = blockState.getBlock();
        Map<Holder<AgroClimaticZone>, CropGrowControl> controlMap = CropGrowthHandler.getControlMap(block);
        if (controlMap == null) {
            return result;
        }
        Holder<Biome> biomeHolder = CropGrowthHandler.getCropBiome((LevelAccessor)level, pos);
        Holder<AgroClimaticZone> climateTypeHolder = CropGrowthHandler.getclimateTypeHolder(biomeHolder);
        if (climateTypeHolder == null) {
            return result;
        }
        Holder<AgroClimaticZone> agentClimateTypeHolder = CropGrowthHandler.getDefaultAgroClimaticZoneHolder((LevelAccessor)level);
        CropGrowControl growControl = CropGrowthHandler.getCropGrowControl(controlMap, climateTypeHolder);
        CropGrowControl agentGrowControl = CropGrowthHandler.getCropGrowControl(controlMap, agentClimateTypeHolder);
        if (growControl == null && agentGrowControl == null) {
            return result;
        }
        SolarTerm solarTerm = EclipticSeasonsApi.getInstance().getSolarTerm(level);
        Season season = solarTerm.getSeason();
        GrowParameter growParameter = CropGrowthHandler.getSeasonGrowParameter(blockState, growControl, agentGrowControl, solarTerm, climateTypeHolder);
        Optional<BlockPredicate> notGreenHouse = growControl != null ? growControl.notGreenHouse() : agentGrowControl.notGreenHouse();
        CropGrowthHandler.RoomStatus roomStatus2 = roomStatus = CropGrowthHandler.isInRoom((LevelAccessor)level, pos, blockState, notGreenHouse) ? CropGrowthHandler.RoomStatus.GREEN_HOUSE : CropGrowthHandler.RoomStatus.NORMAL;
        if (growParameter != null && ((Boolean)CommonConfig.Crop.enableCrop.get()).booleanValue() && (result *= growParameter.grow_chance()) < 1.0f && (((Boolean)CommonConfig.Crop.simpleGreenHouse.get()).booleanValue() || roomStatus == CropGrowthHandler.RoomStatus.GREEN_HOUSE) && CropGrowthHandler.getGreenHouseProvider(level, pos, blockState, controlMap, agentClimateTypeHolder) != null) {
            result = 1.0f;
        }
        if (((Boolean)CommonConfig.Crop.enableCropHumidityControl.get()).booleanValue()) {
            float env = EclipticUtil.getHumidityLevelAt(level, solarTerm, biomeHolder, pos, !level.isClientSide());
            result *= GrowthDetectorItem.getHumidityGrowChance(level, growControl != null ? growControl : agentGrowControl, env, roomStatus, pos, blockState, season, false);
        }
        return result;
    }

    public static float getHumidityGrowChance(Level level, CropGrowControl growControl, float env, CropGrowthHandler.RoomStatus roomStatus, BlockPos pos, BlockState blockState, Season season, boolean hasUpdate) {
        GrowParameter growParameter;
        float result = 1.0f;
        env = Mth.clamp((float)env, (float)0.0f, (float)(Humidity.collectValues().length - 1));
        if (growControl != null && (growParameter = growControl.getGrowParameter(env, blockState)) != null) {
            float f = growParameter.grow_chance();
            if (f > 1.0f) {
                result *= f;
            } else if (f <= 1.0f) {
                if (hasUpdate) {
                    result = f;
                } else {
                    float modification;
                    if (((Boolean)CommonConfig.Crop.simpleGreenHouse.get()).booleanValue() && roomStatus == CropGrowthHandler.RoomStatus.GREEN_HOUSE) {
                        result = 1.0f;
                        return result;
                    }
                    if (((Boolean)CommonConfig.Crop.simpleGreenHouse.get()).booleanValue()) {
                        v0 = 0.0f;
                    } else {
                        SolarDataManager solarDataManager = SolarHolders.getSaveData(level);
                        if (solarDataManager instanceof SolarDataManager) {
                            SolarDataManager sd = solarDataManager;
                            v0 = sd.calculateHumidityModification(pos);
                        } else {
                            v0 = modification = 0.0f;
                        }
                    }
                    result = modification != 0.0f && roomStatus == CropGrowthHandler.RoomStatus.GREEN_HOUSE ? GrowthDetectorItem.getHumidityGrowChance(level, growControl, env += modification, roomStatus, pos, blockState, season, true) : (level.isRainingAt(pos) ? GrowthDetectorItem.getHumidityGrowChance(level, growControl, env += 1.0f, roomStatus, pos, blockState, season, true) : (result *= f));
                }
            }
        }
        return result;
    }
}

