/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.item;

import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.map.SnowyRemover;
import com.teamtea.eclipticseasons.common.misc.SimplePair;
import com.teamtea.eclipticseasons.common.registry.AttachmentRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;

public class IceWandItem
extends Item {
    private static List<SimplePair<MakerMode, Integer>> preModels = List.of(SimplePair.of(MakerMode.BLOCK, 1), SimplePair.of(MakerMode.BLOCK, 3), SimplePair.of(MakerMode.BLOCK, 5), SimplePair.of(MakerMode.CHUNK, 1), SimplePair.of(MakerMode.CHUNK, 3), SimplePair.of(MakerMode.CHUNK, 5), SimplePair.of(MakerMode.CHUNK, 7));

    public IceWandItem(Item.Properties pProperties) {
        super(pProperties);
    }

    SimplePair<MakerMode, Integer> tryParse(String makerModeString) {
        String[] split = makerModeString.split("-");
        MakerMode makerMode = MakerMode.BLOCK;
        int range = 1;
        try {
            if (split.length == 2) {
                makerMode = MakerMode.valueOf(split[0].toUpperCase());
                range = Integer.parseInt(split[1]);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return SimplePair.of(makerMode, range);
    }

    public boolean canAttackBlock(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        ItemStack itemInHand = pPlayer.getItemInHand(InteractionHand.MAIN_HAND);
        if (itemInHand.is((Item)this)) {
            CustomData customData = (CustomData)itemInHand.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag unsafe = customData.getUnsafe();
            SimplePair<MakerMode, Integer> simplePair = this.tryParse(unsafe.getString("range"));
            int mode = unsafe.getInt("mode");
            if (!pPlayer.isShiftKeyDown()) {
                int index = preModels.indexOf(simplePair);
                int nextIndex = index > -1 && index < preModels.size() - 1 ? index + 1 : 0;
                simplePair = preModels.get(nextIndex);
            } else {
                mode = SnowyRemover.SnowyFlag.cycle(mode).ordinal();
            }
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putInt("mode", mode);
            compoundTag.putString("range", "%s-%s".formatted(new Object[]{simplePair.getKey(), simplePair.getValue()}));
            itemInHand.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compoundTag));
            MutableComponent mutableComponent = Component.literal((String)"%s %sx%s, ".formatted(simplePair.getKey().toString().toLowerCase(Locale.ROOT), simplePair.getValue(), simplePair.getValue()));
            mutableComponent.append(SnowyRemover.SnowyFlag.values()[mode].toString().toLowerCase(Locale.ROOT));
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                serverPlayer.sendSystemMessage((Component)mutableComponent, true);
            }
        }
        return false;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        if (pContext.getHand() == InteractionHand.MAIN_HAND) {
            Level level = pContext.getLevel();
            Player contextPlayer = pContext.getPlayer();
            BlockPos clickedPos = pContext.getClickedPos();
            ItemStack itemInHand = pContext.getItemInHand();
            CustomData customData = (CustomData)itemInHand.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag unsafe = customData.getUnsafe();
            SnowyRemover.SnowyFlag type = SnowyRemover.SnowyFlag.values()[unsafe.getInt("mode")];
            SimplePair<MakerMode, Integer> simplePair = this.tryParse(unsafe.getString("range"));
            MakerMode makerMode = simplePair.getKey();
            int range = simplePair.getValue();
            if (makerMode == MakerMode.CHUNK) {
                Stream chunkPosStream = ChunkPos.rangeClosed((ChunkPos)new ChunkPos(clickedPos), (int)((range - 1) / 2));
                chunkPosStream.forEach(chunkPos -> this.modifySnowyBlocks(level, contextPlayer, (ChunkPos)chunkPos, type));
            } else {
                int half = (range - 1) / 2;
                for (int i = -half; i <= half; ++i) {
                    for (int j = -half; j <= half; ++j) {
                        this.modifySnowyBlocks(level, contextPlayer, clickedPos.offset(i, 0, j), type);
                    }
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useOn(pContext);
    }

    private InteractionResult modifySnowyBlocks(Level level, Player contextPlayer, ChunkPos chunkPos, SnowyRemover.SnowyFlag type) {
        BlockPos worldPosition = chunkPos.getMiddleBlockPosition(MapChecker.getMCHeightWithCheck(level, new BlockPos(chunkPos.getMiddleBlockX(), 0, chunkPos.getMiddleBlockZ())));
        if (level.isLoaded(chunkPos.getWorldPosition()) && (contextPlayer == null || level.mayInteract(contextPlayer, worldPosition))) {
            if (level instanceof ServerLevel) {
                int[][] ints1;
                ServerLevel serverLevel = (ServerLevel)level;
                LevelChunk chunk = serverLevel.getChunk(chunkPos.x, chunkPos.z);
                if (!chunk.hasData(AttachmentRegistry.SNOWY_REMOVER)) {
                    chunk.setData(AttachmentRegistry.SNOWY_REMOVER, (Object)new SnowyRemover(new int[16][16]));
                }
                SnowyRemover data = (SnowyRemover)chunk.getData(AttachmentRegistry.SNOWY_REMOVER);
                for (int[] ints : ints1 = new int[16][16]) {
                    Arrays.fill(ints, type.ordinal());
                }
                data = new SnowyRemover(ints1);
                chunk.setData(AttachmentRegistry.SNOWY_REMOVER, (Object)data);
                ArrayList<Integer> ys = new ArrayList<Integer>();
                ArrayList<BlockPos> blockPoss = new ArrayList<BlockPos>();
                for (int i = chunkPos.getMinBlockX(); i <= chunkPos.getMaxBlockX(); ++i) {
                    for (int j = chunkPos.getMinBlockZ(); j <= chunkPos.getMaxBlockZ(); ++j) {
                        int k = level.getHeight(Heightmap.Types.MOTION_BLOCKING, i, j) - 1;
                        BlockPos newPos = new BlockPos(i, k, j);
                        int sk = SectionPos.of((BlockPos)newPos).y();
                        if (!ys.contains(sk)) {
                            ys.add(sk);
                        }
                        blockPoss.add(newPos);
                    }
                }
                for (ServerPlayer player : serverLevel.getChunkSource().chunkMap.getPlayers(chunkPos, false)) {
                    MapChecker.sendChunkInfo(chunk, chunkPos, player, ys, blockPoss);
                }
                if (data.allSnowAble()) {
                    chunk.removeData(AttachmentRegistry.SNOWY_REMOVER);
                }
                chunk.setUnsaved(true);
            } else {
                SnowyRemover data = (SnowyRemover)level.getChunk(chunkPos.x, chunkPos.z).getData(AttachmentRegistry.SNOWY_REMOVER);
                for (int i = chunkPos.getMinBlockX(); i <= chunkPos.getMaxBlockX(); ++i) {
                    for (int j = chunkPos.getMinBlockZ(); j <= chunkPos.getMaxBlockZ(); ++j) {
                        SnowyRemover.SnowyFlag notSnowyAtBefore = data.getSnowyFlag(new BlockPos(i, 64, j));
                        if (type == notSnowyAtBefore) continue;
                        ParticleOptions particleType = notSnowyAtBefore.getNextParticleOptions();
                        for (int k = 0; k < 10; ++k) {
                            level.addParticle(particleType, (double)((float)i + 0.5f), (double)(MapChecker.getHeight(level, new BlockPos(i, 0, j)) + 1), (double)((float)j + 0.5f), (double)(Mth.randomBetween((RandomSource)level.getRandom(), (float)-1.0f, (float)1.0f) * 0.083333336f), (double)0.05f, (double)(Mth.randomBetween((RandomSource)level.getRandom(), (float)-1.0f, (float)1.0f) * 0.083333336f));
                        }
                    }
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return null;
    }

    private InteractionResult modifySnowyBlocks(Level level, Player contextPlayer, BlockPos clickedPos, SnowyRemover.SnowyFlag type) {
        ChunkPos chunkPos = new ChunkPos(clickedPos);
        SectionPos sectionPos = SectionPos.of((BlockPos)clickedPos);
        if (level.isLoaded(clickedPos) && (contextPlayer == null || level.mayInteract(contextPlayer, clickedPos))) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                LevelChunk chunk = serverLevel.getChunkAt(clickedPos);
                if (!chunk.hasData(AttachmentRegistry.SNOWY_REMOVER)) {
                    chunk.setData(AttachmentRegistry.SNOWY_REMOVER, (Object)new SnowyRemover(new int[16][16]));
                }
                SnowyRemover data = (SnowyRemover)chunk.getData(AttachmentRegistry.SNOWY_REMOVER);
                data.setChunkPos(clickedPos, type.ordinal());
                int y = level.getHeight(Heightmap.Types.MOTION_BLOCKING, clickedPos.getX(), clickedPos.getZ()) - 1;
                BlockPos newPos = new BlockPos(clickedPos.getX(), y, clickedPos.getZ());
                int sk = SectionPos.of((BlockPos)newPos).y();
                for (ServerPlayer player : serverLevel.getChunkSource().chunkMap.getPlayers(chunkPos, false)) {
                    MapChecker.sendChunkInfo(chunk, chunkPos, player, List.of(Integer.valueOf(sk)), List.of(newPos));
                }
                if (data.allSnowAble()) {
                    chunk.removeData(AttachmentRegistry.SNOWY_REMOVER);
                }
                chunk.setUnsaved(true);
            } else {
                SnowyRemover data = (SnowyRemover)level.getChunkAt(clickedPos).getData(AttachmentRegistry.SNOWY_REMOVER);
                SnowyRemover.SnowyFlag notSnowyAtBefore = data.getSnowyFlag(new BlockPos((Vec3i)clickedPos));
                if (type != notSnowyAtBefore) {
                    ParticleOptions particleType = type.getNextParticleOptions();
                    for (int i = 0; i < 10; ++i) {
                        level.addParticle(particleType, (double)((float)clickedPos.getX() + 0.5f), (double)(clickedPos.getY() + 1), (double)((float)clickedPos.getZ() + 0.5f), (double)(Mth.randomBetween((RandomSource)level.getRandom(), (float)-1.0f, (float)1.0f) * 0.083333336f), (double)0.05f, (double)(Mth.randomBetween((RandomSource)level.getRandom(), (float)-1.0f, (float)1.0f) * 0.083333336f));
                    }
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return null;
    }

    public static enum MakerMode {
        BLOCK,
        CHUNK;

    }
}

