/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.misc;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class LazyGet<T> {
    private final Supplier<T> cache;
    private T lock;

    private LazyGet(Supplier<T> supplier) {
        this.cache = supplier;
    }

    public static <T> LazyGet<T> of(Supplier<T> supplier) {
        return new LazyGet<T>(supplier);
    }

    public T get() {
        if (this.lock == null) {
            this.lock = this.cache.get();
        }
        return this.lock;
    }

    public void ifPresent(Consumer<T> consumer) {
        consumer.accept(this.get());
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return this.isPresent() ? Optional.of(mapper.apply(this.getValueUnsafe())) : Optional.empty();
    }

    private T getValueUnsafe() {
        return this.cache.get();
    }

    public boolean isPresent() {
        this.get();
        return this.lock == null;
    }

    public T orElse(T t) {
        this.get();
        return (T)(this.lock == null ? t : null);
    }
}

