/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.misc;

import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.core.map.ChunkInfoMap;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class MapExporter {
    public static int exportMap(CommandSourceStack source, BlockPos pos) {
        int x = MapChecker.blockToRegionCoord(pos.getX());
        int z = MapChecker.blockToRegionCoord(pos.getZ());
        Level level = source.getUnsidedLevel();
        ChunkInfoMap map = MapChecker.getChunkMap(level, x, z);
        if (map == null) {
            return 0;
        }
        int size = 512;
        int ax = 9;
        int offset = 200;
        BufferedImage image = new BufferedImage(size + offset, size, 1);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, offset, size);
        HashMap<Holder<Biome>, Color> hashSet = new HashMap<Holder<Biome>, Color>();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                Object color;
                BlockPos biomePos = new BlockPos((x << ax) + i, pos.getY(), (z << ax) + j);
                Holder<Biome> biome = MapChecker.getSurfaceBiome(level, biomePos);
                if (biome.is(Biomes.THE_VOID)) {
                    color = Color.BLACK;
                } else if (!MapChecker.isLoadNearBy(level, biomePos) && biome == level.getUncachedNoiseBiome(pos.getX() >> 2, pos.getY() >> 2, pos.getZ() >> 2)) {
                    color = Color.LIGHT_GRAY;
                    biome = null;
                } else {
                    color = biome.is(Biomes.PLAINS) ? Color.RED : new Color(RandomSource.create((long)biome.getRegisteredName().hashCode()).nextInt(0x1000000));
                }
                graphics2D.setColor((Color)color);
                graphics2D.fillRect(i + offset, j, 1, 1);
                hashSet.put(biome, (Color)color);
            }
        }
        int xp = ChunkInfoMap.getChunkValue(pos.getX()) - 5;
        int zp = ChunkInfoMap.getChunkValue(pos.getZ()) - 5;
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawLine(offset, zp, size + offset, zp);
        graphics2D.drawLine(xp + offset, 0, xp + offset, size);
        graphics2D.setColor(Color.YELLOW);
        Font monospaced = new Font("Monospaced", 0, 12);
        graphics2D.setFont(monospaced);
        graphics2D.drawString("\u2b50", xp + offset, zp);
        int i = 0;
        for (Map.Entry entry : hashSet.entrySet()) {
            graphics2D.setColor((Color)entry.getValue());
            graphics2D.drawString((String)(entry.getKey() == null ? "not load" : ((Holder)entry.getKey()).getRegisteredName() + "," + Component.translatable((String)Util.makeDescriptionId((String)"biome", (ResourceLocation)((Holder)entry.getKey()).getKey().location())).getString()), 5, 20 * ++i);
        }
        graphics2D.dispose();
        try {
            String string;
            if (!new File("eclipticseasons").exists()) {
                new File("eclipticseasons").mkdir();
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                string = serverLevel.toString().split("\\[")[1].split("]")[0];
            } else {
                string = ServerLifecycleHooks.getCurrentServer() == null ? ClientCon.ServerName : ServerLifecycleHooks.getCurrentServer().getMotd();
            }
            Object s = string;
            s = (String)s + "~" + level.dimension().location().toString().replace(":", "_");
            if (!new File("eclipticseasons/" + (String)s).exists()) {
                new File("eclipticseasons/" + (String)s).mkdir();
            }
            String string2 = "%s/%s/%s_%s.png".formatted("eclipticseasons", s, x, z);
            ImageIO.write((RenderedImage)image, "png", new File(string2));
            source.sendSystemMessage((Component)Component.literal((String)("export ok for " + string2)));
        }
        catch (IOException e) {
            source.sendSystemMessage((Component)Component.literal((String)"export fail \n%s".formatted(e.getMessage())));
        }
        return 1;
    }
}

