/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.climate.MonsoonRain;
import com.teamtea.eclipticseasons.api.data.climate.BiomesClimateSettings;
import com.teamtea.eclipticseasons.api.data.misc.SolarTermValueMap;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.Optional;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.Tags;

public class BiomeClimateSettingsRegistry {
    public static final ResourceKey<BiomesClimateSettings> SAVANNA = BiomeClimateSettingsRegistry.createKey("savanna");

    private static ResourceKey<BiomesClimateSettings> createKey(String name) {
        return ResourceKey.create(ESRegistries.BIOME_CLIMATE_SETTING, (ResourceLocation)EclipticSeasons.rl(name));
    }

    public static void bootstrap(BootstrapContext<BiomesClimateSettings> context) {
        HolderGetter holderGetter = context.lookup(Registries.BIOME);
        Optional<Float> empty = Optional.empty();
        Optional<SolarTermValueMap<Float>> emptyMap = Optional.empty();
        SolarTermValueMap.Builder<Float> builder = SolarTermValueMap.builder();
        for (MonsoonRain monsoonRain : MonsoonRain.collectValues()) {
            if (!(monsoonRain.getRainChance() > 0.0f)) continue;
            builder.putSolarTerm(monsoonRain.getSolarTerm(), Float.valueOf((float)Math.round(monsoonRain.getRainChance() / 1.5f * 1000.0f) / 1000.0f));
        }
        context.register(SAVANNA, (Object)new BiomesClimateSettings((HolderSet<Biome>)holderGetter.getOrThrow(Tags.Biomes.IS_SAVANNA), empty, empty, emptyMap, Optional.of(builder.build())));
    }
}

