/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.data.misc.ESSortInfo;
import com.teamtea.eclipticseasons.common.registry.AgroClimateRegistry;
import com.teamtea.eclipticseasons.common.registry.BiomeClimateSettingsRegistry;
import com.teamtea.eclipticseasons.common.registry.CropRegistry;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import com.teamtea.eclipticseasons.common.registry.SeasonCycleRegistry;
import com.teamtea.eclipticseasons.common.registry.SeasonQuestRegistry;
import com.teamtea.eclipticseasons.common.registry.SnowDefinitionsRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class ESSortInfoRegistry {
    private static ResourceKey<ESSortInfo> createKey(ResourceKey<? extends Registry<?>> name) {
        return ResourceKey.create(ESRegistries.EXTRA_INFO, (ResourceLocation)name.location());
    }

    public static List<ResourceLocation> getAllKeys(Class<?> classType) {
        ArrayList<ResourceLocation> keys = new ArrayList<ResourceLocation>();
        try {
            for (Field field : classType.getDeclaredFields()) {
                Object value;
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !ResourceKey.class.isAssignableFrom(field.getType()) || !((value = field.get(null)) instanceof ResourceKey)) continue;
                ResourceKey key = (ResourceKey)value;
                keys.add(key.location());
            }
        }
        catch (IllegalAccessException e) {
            EclipticSeasons.logger(e);
        }
        return keys;
    }

    public static void bootstrap(BootstrapContext<ESSortInfo> context) {
        ESSortInfoRegistry.add(context, ESRegistries.AGRO_CLIMATE, AgroClimateRegistry.class);
        ESSortInfoRegistry.add(context, ESRegistries.CROP, CropRegistry.class);
        ESSortInfoRegistry.add(context, ESRegistries.BIOME_CLIMATE_SETTING, BiomeClimateSettingsRegistry.class);
        ESSortInfoRegistry.add(context, ESRegistries.SEASON_CYCLE, SeasonCycleRegistry.class);
        ESSortInfoRegistry.add(context, ESRegistries.SEASON_QUEST, SeasonQuestRegistry.class);
        ESSortInfoRegistry.add(context, ESRegistries.SNOW_DEFINITIONS, SnowDefinitionsRegistry.class);
    }

    private static void add(BootstrapContext<ESSortInfo> context, ResourceKey<? extends Registry<?>> name, Class<?> classType) {
        context.register(ESSortInfoRegistry.createKey(name), (Object)new ESSortInfo(name.location(), ESSortInfoRegistry.getAllKeys(classType), 800, false));
    }
}

