/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.data.misc.SolarTermValueMap;
import com.teamtea.eclipticseasons.api.data.season.definition.ChangeMode;
import com.teamtea.eclipticseasons.api.data.season.definition.SeasonDefinition;
import com.teamtea.eclipticseasons.api.data.season.definition.condition.EmptyAboveCondition;
import com.teamtea.eclipticseasons.api.data.season.definition.selector.BlockSelector;
import com.teamtea.eclipticseasons.api.data.season.definition.selector.MultiBlockSelector;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class SeasonDefinitionRegistry {
    public static final ResourceKey<SeasonDefinition> test = SeasonDefinitionRegistry.createKey("test");

    private static ResourceKey<SeasonDefinition> createKey(String name) {
        return ResourceKey.create(ESRegistries.SEASON_DEFINITION, (ResourceLocation)EclipticSeasons.rl(name));
    }

    public static void bootstrap2(BootstrapContext<SeasonDefinition> context) {
        HolderGetter holderGetter = context.lookup(Registries.BIOME);
        HolderSet.Direct plains = HolderSet.direct((Holder[])new Holder[]{holderGetter.getOrThrow(Biomes.THE_VOID)});
        Vec3i above = new Vec3i(0, 1, 0);
        List<EmptyAboveCondition> condition = List.of(EmptyAboveCondition.builder().above(true).build());
        context.register(test, (Object)new SeasonDefinition(Optional.of(plains), SolarTermValueMap.builder().putSeason(Season.SPRING, List.of(ChangeMode.builder().original(BlockPredicate.Builder.block().of(new Block[]{Blocks.GRASS_BLOCK}).build()).fixedSeed(true).chance(0.0625f).selector(BlockSelector.builder().conditions(condition).state(Optional.of(Blocks.SHORT_GRASS.defaultBlockState())).weight(22).offset(Optional.of(above)).build()).selector(BlockSelector.builder().conditions(condition).state(Optional.of(Blocks.DANDELION.defaultBlockState())).weight(1).offset(Optional.of(above)).build()).selector(BlockSelector.builder().conditions(condition).state(Optional.of(Blocks.OXEYE_DAISY.defaultBlockState())).weight(1).offset(Optional.of(above)).build()).build())).putSeason(Season.SUMMER, List.of(ChangeMode.builder().original(BlockPredicate.Builder.block().of(new Block[]{Blocks.SHORT_GRASS}).build()).fixedSeed(true).chance(0.0625f).selector(MultiBlockSelector.builder().conditions(condition).multiBlock(MultiBlockSelector.Part.builder().state((BlockState)Blocks.TALL_GRASS.defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)).build()).multiBlock(MultiBlockSelector.Part.builder().state((BlockState)Blocks.TALL_GRASS.defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)).build()).build()).build())).putSeason(Season.AUTUMN, List.of(ChangeMode.builder().original(BlockPredicate.Builder.block().of(new Block[]{Blocks.TALL_GRASS}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)).build()).fixedSeed(false).chance(0.0625f).selector(BlockSelector.builder().state(Optional.of(Blocks.SHORT_GRASS.defaultBlockState())).build()).build(), ChangeMode.builder().original(BlockPredicate.Builder.block().of(new Block[]{Blocks.TALL_GRASS}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)).build()).fixedSeed(false).chance(0.0625f).selector(BlockSelector.builder().build()).build())).putSeason(Season.WINTER, List.of(ChangeMode.builder().original(BlockPredicate.Builder.block().of(new Block[]{Blocks.SHORT_GRASS}).build()).fixedSeed(false).chance(0.0625f).build(), ChangeMode.builder().original(BlockPredicate.Builder.block().of(new Block[]{Blocks.DANDELION}).build()).fixedSeed(false).chance(0.0625f).build(), ChangeMode.builder().original(BlockPredicate.Builder.block().of(new Block[]{Blocks.OXEYE_DAISY}).build()).fixedSeed(false).chance(0.0625f).build())).build()));
    }
}

