/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.season.SeasonPhase;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class SeasonPhaseRegistry {
    public static final ResourceKey<SeasonPhase> DRY_START = SeasonPhaseRegistry.createKey("dry_start");
    public static final ResourceKey<SeasonPhase> DRY_MIDDLE = SeasonPhaseRegistry.createKey("dry_middle");
    public static final ResourceKey<SeasonPhase> DRY_END = SeasonPhaseRegistry.createKey("dry_end");
    public static final ResourceKey<SeasonPhase> RAIN_START = SeasonPhaseRegistry.createKey("rain_start");
    public static final ResourceKey<SeasonPhase> RAIN_MIDDLE = SeasonPhaseRegistry.createKey("rain_middle");
    public static final ResourceKey<SeasonPhase> RAIN_END = SeasonPhaseRegistry.createKey("rain_end");
    public static final ResourceKey<SeasonPhase> WET_START = SeasonPhaseRegistry.createKey("wet_start");
    public static final ResourceKey<SeasonPhase> WET_MIDDLE = SeasonPhaseRegistry.createKey("wet_middle");
    public static final ResourceKey<SeasonPhase> WET_END = SeasonPhaseRegistry.createKey("wet_end");
    public static final ResourceKey<SeasonPhase> COLD_BEGINNING_OF_SPRING = SeasonPhaseRegistry.createKey("cold_beginning_of_spring");
    public static final ResourceKey<SeasonPhase> COLD_RAIN_WATER = SeasonPhaseRegistry.createKey("cold_rain_water");
    public static final ResourceKey<SeasonPhase> COLD_INSECTS_AWAKENING = SeasonPhaseRegistry.createKey("cold_insects_awakening");
    public static final ResourceKey<SeasonPhase> COLD_SPRING_EQUINOX = SeasonPhaseRegistry.createKey("cold_spring_equinox");
    public static final ResourceKey<SeasonPhase> COLD_FRESH_GREEN = SeasonPhaseRegistry.createKey("cold_fresh_green");
    public static final ResourceKey<SeasonPhase> COLD_GRAIN_RAIN = SeasonPhaseRegistry.createKey("cold_grain_rain");
    public static final ResourceKey<SeasonPhase> COLD_BEGINNING_OF_SUMMER = SeasonPhaseRegistry.createKey("cold_beginning_of_summer");
    public static final ResourceKey<SeasonPhase> COLD_LESSER_FULLNESS = SeasonPhaseRegistry.createKey("cold_lesser_fullness");
    public static final ResourceKey<SeasonPhase> COLD_GRAIN_IN_EAR = SeasonPhaseRegistry.createKey("cold_grain_in_ear");
    public static final ResourceKey<SeasonPhase> COLD_SUMMER_SOLSTICE = SeasonPhaseRegistry.createKey("cold_summer_solstice");
    public static final ResourceKey<SeasonPhase> COLD_LESSER_HEAT = SeasonPhaseRegistry.createKey("cold_lesser_heat");
    public static final ResourceKey<SeasonPhase> COLD_GREATER_HEAT = SeasonPhaseRegistry.createKey("cold_greater_heat");
    public static final ResourceKey<SeasonPhase> COLD_BEGINNING_OF_AUTUMN = SeasonPhaseRegistry.createKey("cold_beginning_of_autumn");
    public static final ResourceKey<SeasonPhase> COLD_END_OF_HEAT = SeasonPhaseRegistry.createKey("cold_end_of_heat");
    public static final ResourceKey<SeasonPhase> COLD_WHITE_DEW = SeasonPhaseRegistry.createKey("cold_white_dew");
    public static final ResourceKey<SeasonPhase> COLD_AUTUMNAL_EQUINOX = SeasonPhaseRegistry.createKey("cold_autumnal_equinox");
    public static final ResourceKey<SeasonPhase> COLD_COLD_DEW = SeasonPhaseRegistry.createKey("cold_cold_dew");
    public static final ResourceKey<SeasonPhase> COLD_FIRST_FROST = SeasonPhaseRegistry.createKey("cold_first_frost");
    public static final ResourceKey<SeasonPhase> COLD_BEGINNING_OF_WINTER = SeasonPhaseRegistry.createKey("cold_beginning_of_winter");
    public static final ResourceKey<SeasonPhase> COLD_LIGHT_SNOW = SeasonPhaseRegistry.createKey("cold_light_snow");
    public static final ResourceKey<SeasonPhase> COLD_HEAVY_SNOW = SeasonPhaseRegistry.createKey("cold_heavy_snow");
    public static final ResourceKey<SeasonPhase> COLD_WINTER_SOLSTICE = SeasonPhaseRegistry.createKey("cold_winter_solstice");
    public static final ResourceKey<SeasonPhase> COLD_LESSER_COLD = SeasonPhaseRegistry.createKey("cold_lesser_cold");
    public static final ResourceKey<SeasonPhase> COLD_GREATER_COLD = SeasonPhaseRegistry.createKey("cold_greater_cold");
    public static final ResourceKey<SeasonPhase> HOT_BEGINNING_OF_SPRING = SeasonPhaseRegistry.createKey("hot_beginning_of_spring");
    public static final ResourceKey<SeasonPhase> HOT_RAIN_WATER = SeasonPhaseRegistry.createKey("hot_rain_water");
    public static final ResourceKey<SeasonPhase> HOT_INSECTS_AWAKENING = SeasonPhaseRegistry.createKey("hot_insects_awakening");
    public static final ResourceKey<SeasonPhase> HOT_SPRING_EQUINOX = SeasonPhaseRegistry.createKey("hot_spring_equinox");
    public static final ResourceKey<SeasonPhase> HOT_FRESH_GREEN = SeasonPhaseRegistry.createKey("hot_fresh_green");
    public static final ResourceKey<SeasonPhase> HOT_GRAIN_RAIN = SeasonPhaseRegistry.createKey("hot_grain_rain");
    public static final ResourceKey<SeasonPhase> HOT_BEGINNING_OF_SUMMER = SeasonPhaseRegistry.createKey("hot_beginning_of_summer");
    public static final ResourceKey<SeasonPhase> HOT_LESSER_FULLNESS = SeasonPhaseRegistry.createKey("hot_lesser_fullness");
    public static final ResourceKey<SeasonPhase> HOT_GRAIN_IN_EAR = SeasonPhaseRegistry.createKey("hot_grain_in_ear");
    public static final ResourceKey<SeasonPhase> HOT_SUMMER_SOLSTICE = SeasonPhaseRegistry.createKey("hot_summer_solstice");
    public static final ResourceKey<SeasonPhase> HOT_LESSER_HEAT = SeasonPhaseRegistry.createKey("hot_lesser_heat");
    public static final ResourceKey<SeasonPhase> HOT_GREATER_HEAT = SeasonPhaseRegistry.createKey("hot_greater_heat");
    public static final ResourceKey<SeasonPhase> HOT_BEGINNING_OF_AUTUMN = SeasonPhaseRegistry.createKey("hot_beginning_of_autumn");
    public static final ResourceKey<SeasonPhase> HOT_END_OF_HEAT = SeasonPhaseRegistry.createKey("hot_end_of_heat");
    public static final ResourceKey<SeasonPhase> HOT_WHITE_DEW = SeasonPhaseRegistry.createKey("hot_white_dew");
    public static final ResourceKey<SeasonPhase> HOT_AUTUMNAL_EQUINOX = SeasonPhaseRegistry.createKey("hot_autumnal_equinox");
    public static final ResourceKey<SeasonPhase> HOT_COLD_DEW = SeasonPhaseRegistry.createKey("hot_cold_dew");
    public static final ResourceKey<SeasonPhase> HOT_FIRST_FROST = SeasonPhaseRegistry.createKey("hot_first_frost");
    public static final ResourceKey<SeasonPhase> HOT_BEGINNING_OF_WINTER = SeasonPhaseRegistry.createKey("hot_beginning_of_winter");
    public static final ResourceKey<SeasonPhase> HOT_LIGHT_SNOW = SeasonPhaseRegistry.createKey("hot_light_snow");
    public static final ResourceKey<SeasonPhase> HOT_HEAVY_SNOW = SeasonPhaseRegistry.createKey("hot_heavy_snow");
    public static final ResourceKey<SeasonPhase> HOT_WINTER_SOLSTICE = SeasonPhaseRegistry.createKey("hot_winter_solstice");
    public static final ResourceKey<SeasonPhase> HOT_LESSER_COLD = SeasonPhaseRegistry.createKey("hot_lesser_cold");
    public static final ResourceKey<SeasonPhase> HOT_GREATER_COLD = SeasonPhaseRegistry.createKey("hot_greater_cold");

    private static ResourceKey<SeasonPhase> createKey(String name) {
        return ResourceKey.create(ESRegistries.SEASON_PHASE, (ResourceLocation)EclipticSeasons.rl(name));
    }

    public static void bootstrap(BootstrapContext<SeasonPhase> context) {
        ResourceLocation monsoonIcons = EclipticSeasons.rl("monsoon_icons");
        context.register(DRY_START, (Object)new SeasonPhase(Season.SUMMER, EclipticSeasons.rl("dry_start"), ChatFormatting.RED, Optional.empty(), new SeasonPhase.FontIcon(monsoonIcons, "a")));
        context.register(DRY_MIDDLE, (Object)new SeasonPhase(Season.SUMMER, EclipticSeasons.rl("dry_middle"), ChatFormatting.RED, Optional.empty(), new SeasonPhase.FontIcon(monsoonIcons, "b")));
        context.register(DRY_END, (Object)new SeasonPhase(Season.SUMMER, EclipticSeasons.rl("dry_end"), ChatFormatting.RED, Optional.empty(), new SeasonPhase.FontIcon(monsoonIcons, "c")));
        context.register(RAIN_START, (Object)new SeasonPhase(Season.SUMMER, EclipticSeasons.rl("rain_start"), ChatFormatting.DARK_BLUE, Optional.empty(), new SeasonPhase.FontIcon(monsoonIcons, "d")));
        context.register(RAIN_MIDDLE, (Object)new SeasonPhase(Season.SUMMER, EclipticSeasons.rl("rain_middle"), ChatFormatting.DARK_BLUE, Optional.empty(), new SeasonPhase.FontIcon(monsoonIcons, "e")));
        context.register(RAIN_END, (Object)new SeasonPhase(Season.SUMMER, EclipticSeasons.rl("rain_end"), ChatFormatting.DARK_BLUE, Optional.empty(), new SeasonPhase.FontIcon(monsoonIcons, "f")));
        context.register(WET_START, (Object)new SeasonPhase(Season.SUMMER, EclipticSeasons.rl("wet_start"), ChatFormatting.DARK_GREEN, Optional.empty(), new SeasonPhase.FontIcon(monsoonIcons, "g")));
        context.register(WET_MIDDLE, (Object)new SeasonPhase(Season.SUMMER, EclipticSeasons.rl("wet_middle"), ChatFormatting.DARK_GREEN, Optional.empty(), new SeasonPhase.FontIcon(monsoonIcons, "h")));
        context.register(WET_END, (Object)new SeasonPhase(Season.SUMMER, EclipticSeasons.rl("wet_end"), ChatFormatting.DARK_GREEN, Optional.empty(), new SeasonPhase.FontIcon(monsoonIcons, "i")));
        ResourceLocation solarIcons = EclipticSeasons.rl("solar_icons");
        ResourceLocation seasonsIcons = EclipticSeasons.rl("seasons_icons").withPrefix("font/");
        for (SolarTerm solarTerm : SolarTerm.collectValidValues()) {
            ResourceKey<SeasonPhase> coldKey = SeasonPhaseRegistry.createKey("cold_" + solarTerm.getName());
            context.register(coldKey, (Object)new SeasonPhase(solarTerm.getSeason(), coldKey.location(), solarTerm.getSeason().getColor(), Optional.of(new SeasonPhase.Icon(seasonsIcons, solarTerm.getIconWidth(), solarTerm.getIconHeight(), solarTerm.getIconAtlasSize(), solarTerm.getIconPosition().getKey(), solarTerm.getIconPosition().getValue())), new SeasonPhase.FontIcon(solarIcons, solarTerm.getFontLabel())));
            ResourceKey<SeasonPhase> hotKey = SeasonPhaseRegistry.createKey("hot_" + solarTerm.getName());
            context.register(hotKey, (Object)new SeasonPhase(solarTerm.getSeason(), hotKey.location(), solarTerm.getSeason().getColor(), Optional.of(new SeasonPhase.Icon(seasonsIcons, solarTerm.getIconWidth(), solarTerm.getIconHeight(), solarTerm.getIconAtlasSize(), solarTerm.getIconPosition().getKey(), solarTerm.getIconPosition().getValue())), new SeasonPhase.FontIcon(solarIcons, solarTerm.getFontLabel())));
        }
    }
}

