/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.data.season.SnowDefinition;
import com.teamtea.eclipticseasons.common.core.snow.ClientModelDefinitions;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.function.BiFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class SnowDefinitionsRegistry {
    private static final ResourceKey<SnowDefinition> OVERLAY = SnowDefinitionsRegistry.createKey("test/overlay");
    public static final ResourceKey<SnowDefinition> SNOWY_GRASS_BLOCK = SnowDefinitionsRegistry.createKey("snowy_grass_block");
    public static final ResourceKey<SnowDefinition> SNOWY_SWEET_BERRY_BUSH = SnowDefinitionsRegistry.createKey("snowy_sweet_berry_bush");
    public static final ResourceKey<SnowDefinition> SNOWY_DEAD_BUSH = SnowDefinitionsRegistry.createKey("snowy_dead_bush");
    public static final ResourceKey<SnowDefinition> SNOWY_SUGAR_CANE = SnowDefinitionsRegistry.createKey("snowy_sugar_cane");
    public static final ResourceKey<SnowDefinition> SNOWY_BAMBOO = SnowDefinitionsRegistry.createKey("snowy_bamboo");
    public static final ResourceKey<SnowDefinition> SNOWY_BAMBOO_SAPLING = SnowDefinitionsRegistry.createKey("snowy_bamboo_sapling");

    private static ResourceKey<SnowDefinition> createKey(String name) {
        return ResourceKey.create(ESRegistries.SNOW_DEFINITIONS, (ResourceLocation)EclipticSeasons.rl(name));
    }

    private static ResourceKey<SnowDefinition> createKey(Block block) {
        return ResourceKey.create(ESRegistries.SNOW_DEFINITIONS, (ResourceLocation)EclipticSeasons.rl("snowy_" + block.builtInRegistryHolder().key().location().getPath()));
    }

    public static void bootstrap2(BootstrapContext<SnowDefinition> context) {
        context.register(OVERLAY, (Object)SnowDefinition.builder().blocks((HolderSet<Block>)HolderSet.empty()).info(SnowDefinition.Info.builder().mid(ClientModelDefinitions.OVERLAY).build()).build());
    }

    public static void bootstrap(BootstrapContext<SnowDefinition> context) {
        context.register(SNOWY_GRASS_BLOCK, (Object)SnowDefinition.builder().blocks((HolderSet<Block>)SnowDefinitionsRegistry.set(Blocks.GRASS_BLOCK)).info(SnowDefinition.Info.builder().mid(ClientModelDefinitions.SNOWY_GRASS_BLOCK_OVERLAY).build()).build());
        SnowDefinitionsRegistry.addPlant(context, Blocks.SUGAR_CANE, 1200);
        SnowDefinitionsRegistry.addPlant(context, Blocks.DEAD_BUSH);
        SnowDefinitionsRegistry.addPlant(context, Blocks.SWEET_BERRY_BUSH);
        SnowDefinitionsRegistry.addPlant(context, Blocks.BAMBOO_SAPLING);
        SnowDefinitionsRegistry.register(context, Blocks.BAMBOO, (b, s) -> s.info(SnowDefinition.Info.builder().flag(1100).snowPassable(true).mid2(SnowDefinitionsRegistry.getSnowModelPath(b)).mid(SnowDefinitionsRegistry.getSnowModelPath(b).withSuffix("_top")).build()));
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull HolderSet.Direct<Block> set(Block bamboo) {
        return HolderSet.direct((Holder[])new Holder[]{bamboo.builtInRegistryHolder()});
    }

    public static void register(BootstrapContext<SnowDefinition> context, Block block, BiFunction<Block, SnowDefinition.SnowDefinitionBuilder, SnowDefinition.SnowDefinitionBuilder> function) {
        context.register(SnowDefinitionsRegistry.createSnowyKey(block), (Object)function.apply(block, SnowDefinition.builder()).blocks((HolderSet<Block>)SnowDefinitionsRegistry.set(block)).build());
    }

    public static void addPlant(BootstrapContext<SnowDefinition> context, Block block) {
        SnowDefinitionsRegistry.addPlant(context, block, 1001);
    }

    public static void addPlant(BootstrapContext<SnowDefinition> context, Block block, int flag) {
        String path = SnowDefinitionsRegistry.path(block);
        context.register(SnowDefinitionsRegistry.createSnowyKey(path), (Object)SnowDefinition.builder().blocks((HolderSet<Block>)SnowDefinitionsRegistry.set(block)).info(SnowDefinition.Info.builder().offset(1).flag(flag).mid(SnowDefinitionsRegistry.getSnowModelPath(path)).build()).build());
    }

    @NotNull
    private static ResourceKey<SnowDefinition> createSnowyKey(String path) {
        return SnowDefinitionsRegistry.createKey("snowy_" + path);
    }

    @NotNull
    private static ResourceKey<SnowDefinition> createSnowyKey(Block block) {
        return SnowDefinitionsRegistry.createKey("snowy_" + SnowDefinitionsRegistry.path(block));
    }

    @NotNull
    public static String path(Block block) {
        return block.builtInRegistryHolder().key().location().getPath();
    }

    @NotNull
    public static ResourceLocation getSnowModelPath(String path) {
        return EclipticSeasons.rl("snowy/" + path);
    }

    @NotNull
    public static ResourceLocation getSnowModelPath(Block block) {
        return EclipticSeasons.rl("snowy/" + SnowDefinitionsRegistry.path(block));
    }

    @NotNull
    public static ResourceLocation getSnowModelPath(String modid, Block block) {
        return ResourceLocation.fromNamespaceAndPath((String)modid, (String)("snowy/" + SnowDefinitionsRegistry.path(block)));
    }

    public static void bootstrap_extra(BootstrapContext<SnowDefinition> context) {
        SnowDefinitionsRegistry.addPlant(context, Blocks.OAK_SAPLING);
        SnowDefinitionsRegistry.addPlant(context, Blocks.DARK_OAK_SAPLING);
        SnowDefinitionsRegistry.addPlant(context, Blocks.ACACIA_SAPLING);
        SnowDefinitionsRegistry.addPlant(context, Blocks.BIRCH_SAPLING);
        SnowDefinitionsRegistry.addPlant(context, Blocks.JUNGLE_SAPLING);
        SnowDefinitionsRegistry.addPlant(context, Blocks.SPRUCE_SAPLING);
        SnowDefinitionsRegistry.addPlant(context, Blocks.CHERRY_SAPLING);
        context.register(SnowDefinitionsRegistry.createSnowyKey("mangrove_propagule"), (Object)SnowDefinition.builder().blocks((HolderSet<Block>)HolderSet.direct((Holder[])new Holder[]{Blocks.MANGROVE_PROPAGULE.builtInRegistryHolder()})).info(SnowDefinition.Info.builder().offset(1).flag(1001).mid(SnowDefinitionsRegistry.getSnowModelPath("mangrove_propagule")).build()).build());
        SnowDefinitionsRegistry.addPlant(context, Blocks.RED_MUSHROOM);
        SnowDefinitionsRegistry.addPlant(context, Blocks.BROWN_MUSHROOM);
        SnowDefinitionsRegistry.addPlant(context, Blocks.ALLIUM);
        SnowDefinitionsRegistry.addPlant(context, Blocks.AZURE_BLUET);
        SnowDefinitionsRegistry.addPlant(context, Blocks.BLUE_ORCHID);
        SnowDefinitionsRegistry.addPlant(context, Blocks.CORNFLOWER);
        SnowDefinitionsRegistry.addPlant(context, Blocks.DANDELION);
        SnowDefinitionsRegistry.addPlant(context, Blocks.LILY_OF_THE_VALLEY);
        SnowDefinitionsRegistry.addPlant(context, Blocks.ORANGE_TULIP);
        SnowDefinitionsRegistry.addPlant(context, Blocks.PINK_TULIP);
        SnowDefinitionsRegistry.addPlant(context, Blocks.WHITE_TULIP);
        SnowDefinitionsRegistry.addPlant(context, Blocks.RED_TULIP);
        SnowDefinitionsRegistry.addPlant(context, Blocks.OXEYE_DAISY);
        SnowDefinitionsRegistry.addPlant(context, Blocks.POPPY);
        SnowDefinitionsRegistry.addPlant(context, Blocks.WITHER_ROSE);
        SnowDefinitionsRegistry.addPlant(context, Blocks.SUNFLOWER, 1001);
        SnowDefinitionsRegistry.addPlant(context, Blocks.LILAC, 1001);
        SnowDefinitionsRegistry.addPlant(context, Blocks.PEONY, 1001);
        SnowDefinitionsRegistry.addPlant(context, Blocks.ROSE_BUSH, 1001);
        SnowDefinitionsRegistry.addPlant(context, Blocks.TORCHFLOWER);
        SnowDefinitionsRegistry.addPlant(context, Blocks.TORCHFLOWER_CROP);
        SnowDefinitionsRegistry.addPlant(context, Blocks.PITCHER_CROP, 1001);
        SnowDefinitionsRegistry.addPlant(context, Blocks.PITCHER_PLANT, 1001);
        SnowDefinitionsRegistry.addPlant(context, Blocks.BEETROOTS);
        SnowDefinitionsRegistry.addPlant(context, Blocks.CARROTS);
        SnowDefinitionsRegistry.addPlant(context, Blocks.POTATOES);
        SnowDefinitionsRegistry.addPlant(context, Blocks.WHEAT);
        SnowDefinitionsRegistry.addPlant(context, Blocks.MELON_STEM);
        SnowDefinitionsRegistry.addPlant(context, Blocks.ATTACHED_MELON_STEM);
        SnowDefinitionsRegistry.addPlant(context, Blocks.PUMPKIN_STEM);
        SnowDefinitionsRegistry.addPlant(context, Blocks.ATTACHED_PUMPKIN_STEM);
    }
}

