/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.climate.SnowTerm;
import com.teamtea.eclipticseasons.api.data.weather.CustomSnowTerm;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class SnowTermRegistry {
    public static final ResourceKey<CustomSnowTerm> PLAIN = SnowTermRegistry.createKey("plain");
    public static final ResourceKey<CustomSnowTerm> SUNFLOWER_PLAINS = SnowTermRegistry.createKey("sunflower_plains");

    private static ResourceKey<CustomSnowTerm> createKey(String name) {
        return ResourceKey.create(ESRegistries.SNOW_TERM, (ResourceLocation)EclipticSeasons.rl(name));
    }

    public static void bootstrap2(BootstrapContext<CustomSnowTerm> context) {
        HolderGetter holderGetter = context.lookup(Registries.BIOME);
        context.register(PLAIN, (Object)new CustomSnowTerm((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{holderGetter.getOrThrow(Biomes.PLAINS)}), SnowTerm.T08.getStart(), SnowTerm.T08.getEnd(), List.of()));
        context.register(SUNFLOWER_PLAINS, (Object)new CustomSnowTerm((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{holderGetter.getOrThrow(Biomes.SUNFLOWER_PLAINS)}), SnowTerm.T08.getStart(), SnowTerm.T08.getEnd(), List.of(new CustomSnowTerm.TempEvent(0.1f, SnowTerm.T1.getStart(), SnowTerm.T1.getEnd()))));
    }
}

