/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.data.weather.WeatherRegion;
import com.teamtea.eclipticseasons.common.registry.AgroClimateRegistry;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.registries.holdersets.AndHolderSet;
import net.neoforged.neoforge.registries.holdersets.OrHolderSet;

public class WeatherRegionRegistry {
    public static final ResourceKey<WeatherRegion> PLAINS = WeatherRegionRegistry.createKey("plains");
    public static final ResourceKey<WeatherRegion> FOREST = WeatherRegionRegistry.createKey("forest");

    private static ResourceKey<WeatherRegion> createKey(String name) {
        return ResourceKey.create(ESRegistries.WEATHER_REGION, (ResourceLocation)EclipticSeasons.rl(name));
    }

    @SafeVarargs
    private static <T> HolderSet<T> and(HolderSet<T> ... values) {
        return new AndHolderSet(values);
    }

    @SafeVarargs
    private static <T> HolderSet<T> or(HolderSet<T> ... values) {
        return new OrHolderSet(values);
    }

    public static void bootstrap2(BootstrapContext<WeatherRegion> context) {
        HolderGetter getter = context.lookup(Registries.BIOME);
        AgroClimateRegistry.BiomeRegistryLookup BIOME_REGISTRY_LOOKUP = new AgroClimateRegistry.BiomeRegistryLookup((HolderGetter<Biome>)getter);
        context.register(PLAINS, (Object)new WeatherRegion((Holder<Biome>)getter.getOrThrow(Biomes.PLAINS), (HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{Holder.Reference.createStandAlone((HolderOwner)BIOME_REGISTRY_LOOKUP, (ResourceKey)Biomes.SUNFLOWER_PLAINS)})));
        context.register(FOREST, (Object)new WeatherRegion((Holder<Biome>)getter.getOrThrow(Biomes.FOREST), (HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{Holder.Reference.createStandAlone((HolderOwner)BIOME_REGISTRY_LOOKUP, (ResourceKey)Biomes.FLOWER_FOREST), Holder.Reference.createStandAlone((HolderOwner)BIOME_REGISTRY_LOOKUP, (ResourceKey)Biomes.DARK_FOREST), Holder.Reference.createStandAlone((HolderOwner)BIOME_REGISTRY_LOOKUP, (ResourceKey)Biomes.BIRCH_FOREST)}), 1000, List.of(new ModLoadedCondition("xxxx"))));
    }
}

