/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.data.craft.WetterStructure;
import com.teamtea.eclipticseasons.api.data.misc.PosAndBlockStateCheck;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class WetterStructureRegistry {
    public static final ResourceKey<WetterStructure> BUBBLE_COLUMN_ON_MAGMA = WetterStructureRegistry.createKey("bubble_column_on_magma");

    private static ResourceKey<WetterStructure> createKey(String name) {
        return ResourceKey.create(ESRegistries.WETTER, (ResourceLocation)EclipticSeasons.rl(name));
    }

    private static ResourceKey<Block> createBlockKey(ResourceLocation resourceLocation) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)resourceLocation);
    }

    public static void bootstrap(BootstrapContext<WetterStructure> context) {
        HolderGetter blockHolderGetter = context.lookup(Registries.BLOCK);
        context.register(BUBBLE_COLUMN_ON_MAGMA, (Object)new WetterStructure(0.75f, 4.0f, 600, true, Optional.of(new BlockPredicate(Optional.of(HolderSet.direct((Holder[])new Holder[]{Blocks.BUBBLE_COLUMN.builtInRegistryHolder()})), Optional.empty(), Optional.empty())), List.of(new PosAndBlockStateCheck(Vec3i.ZERO.below(), BlockPredicate.Builder.block().of(new Block[]{Blocks.MAGMA_BLOCK}).build()))));
    }
}

