/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.compat;

import com.teamtea.eclipticseasons.compat.Platform;
import com.teamtea.eclipticseasons.compat.theoneprobe.TOPHook;
import java.util.List;
import lombok.Generated;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CompatModule {
    private static boolean ctm = false;
    private static boolean continuity = false;
    private static boolean fabric_renderer_indigo = false;
    private static boolean sodium = false;
    private static boolean iris = false;

    public static void init() {
        ctm = Platform.isModLoaded("ctm");
        continuity = Platform.isModLoaded("continuity");
        fabric_renderer_indigo = Platform.isModLoaded("fabric_renderer_indigo");
        sodium = Platform.isModLoaded("sodium");
        iris = Platform.isModLoaded("iris");
    }

    public static void register(IEventBus gameBus, IEventBus modBus) {
    }

    public static void onInterModEnqueue(InterModEnqueueEvent event) {
        event.enqueueWork(TOPHook::init);
    }

    public static void setup() {
    }

    @Generated
    public static boolean isFabric_renderer_indigo() {
        return fabric_renderer_indigo;
    }

    @Generated
    public static boolean isSodium() {
        return sodium;
    }

    @Generated
    public static boolean isIris() {
        return iris;
    }

    public static class ClientConfig {
        public static ModConfigSpec.BooleanValue unifiedSnowyBlockShading;
        public static ModConfigSpec.BooleanValue unifiedSnowyBlockSides;

        public static void load(ModConfigSpec.Builder builder) {
            builder.push("Compat");
            if (CompatModule.isIris()) {
                builder.push("Iris");
                unifiedSnowyBlockShading = builder.comment("Unify the shading and surface parameters of snow-covered blocks.").define("UnifiedSnowyBlockShading", true);
                unifiedSnowyBlockSides = builder.comment("Whether to also unify the shading on the sides of snow-covered blocks.").define("UnifiedSnowyBlockSides", true);
                builder.pop();
            }
            builder.pop();
        }
    }

    public static class CommonConfig {
        public static ModConfigSpec.BooleanValue sereneSeasons;
        public static ModConfigSpec.BooleanValue sereneSeasonsIgnoreSapling;
        public static ModConfigSpec.BooleanValue sereneSeasonBasedHumidity;
        public static ModConfigSpec.ConfigValue<List<? extends String>> modsWithoutSereneSeasonBasedHumidity;
        public static ModConfigSpec.BooleanValue fixBiome;
        public static ModConfigSpec.DoubleValue weatherVotePercent;

        public static void load(ModConfigSpec.Builder builder) {
            builder.push("Compat");
            sereneSeasons = builder.comment("Compatible with mods using SereneSeasons' CropTag.").define("SereneSeasonsCropTag", true);
            sereneSeasonsIgnoreSapling = builder.comment("If true, saplings will be ignored when applying Serene Seasons crop tags.\nSet to false if you want saplings to also follow seasonal crop rules.").define("SereneSeasonsCropTagIgnoreSapling", true);
            sereneSeasonBasedHumidity = builder.comment("Crops should get automatic humidity values based on seasons from Serene Season Crop Tag.").define("SereneSeasonCropTagBasedHumidity", true);
            modsWithoutSereneSeasonBasedHumidity = builder.comment("A blacklist of mods whose crops should NOT get automatic humidity values based on seasons.\nAdd mod IDs here to prevent seasonal humidity assignment.\nExample: [\"vinery\", \"meadow\"]").defineListAllowEmpty("ModsWithoutSereneSeasonBasedHumidity", List::of, () -> "", o -> o instanceof String);
            fixBiome = builder.comment("If a mod tries to query biome precipitation using the raw method, would adjust it to correctly ignore small biomes like rivers.").define("FixBiomePrecipitation", true);
            weatherVotePercent = builder.comment("When a mod tries to query global weather parameters directly instead of using our API, Solar Weather will determine the result based on a weighted vote from the areas around players.").defineInRange("WeatherVotePercent", 0.5, 0.0, 1.0);
            builder.pop();
        }
    }
}

