/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.compat.distanthorizons;

import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.level.ClientLevelModule;
import com.seibel.distanthorizons.core.level.DhClientLevel;
import com.seibel.distanthorizons.core.level.DhClientServerLevel;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPosMutable;
import com.seibel.distanthorizons.core.render.LodQuadTree;
import com.seibel.distanthorizons.core.render.LodRenderSection;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.util.gridList.MovableGridRingList;
import com.seibel.distanthorizons.core.util.objects.quadTree.QuadNode;
import com.seibel.distanthorizons.core.world.IDhClientWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.config.ClientConfig;
import com.teamtea.eclipticseasons.config.CommonConfig;
import com.teamtea.eclipticseasons.mixin.compat.distanthorizons.MixinQuadTree;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;

public class DHTool {
    public static void forceReloadAll() {
        ClientLevelWrapper clientLevelWrapper;
        IClientLevelWrapper iClientLevelWrapper;
        IDhClientWorld clientWorld = SharedApi.getIDhClientWorld();
        if (Minecraft.getInstance().level != null && (iClientLevelWrapper = ClientLevelWrapper.getWrapper((ClientLevel)Minecraft.getInstance().level)) instanceof ClientLevelWrapper && (iClientLevelWrapper = clientWorld.getLevel((ILevelWrapper)(clientLevelWrapper = (ClientLevelWrapper)iClientLevelWrapper))) instanceof IDhClientLevel) {
            IDhClientLevel clientLevel = (IDhClientLevel)iClientLevelWrapper;
            AtomicReference clientRenderStateAtomicReference = null;
            if (clientLevel instanceof DhClientServerLevel) {
                DhClientServerLevel dhClientServerLevel = (DhClientServerLevel)clientLevel;
                clientRenderStateAtomicReference = dhClientServerLevel.clientside.ClientRenderStateRef;
            } else if (clientLevel instanceof DhClientLevel) {
                DhClientLevel dhClientLevel = (DhClientLevel)clientLevel;
                clientRenderStateAtomicReference = dhClientLevel.clientside.ClientRenderStateRef;
            }
            if (clientRenderStateAtomicReference != null) {
                LodQuadTree quadtree = ((ClientLevelModule.ClientRenderState)clientRenderStateAtomicReference.get()).quadtree;
                MixinQuadTree quadtree1 = (MixinQuadTree)quadtree;
                ArrayList<Long> reloadList = new ArrayList<Long>();
                MovableGridRingList<QuadNode> topRingList = quadtree1.getTopRingList();
                Stack<QuadNode> stack = new Stack<QuadNode>();
                int topRingListSize = topRingList.size();
                for (int i = 0; i < topRingListSize; ++i) {
                    stack.push((QuadNode)topRingList.get(i));
                }
                while (!stack.isEmpty()) {
                    LodRenderSection lodRenderSection;
                    QuadNode node = (QuadNode)stack.pop();
                    if (node == null || node.value == null) continue;
                    Object object = node.value;
                    if (!(object instanceof LodRenderSection) || (lodRenderSection = (LodRenderSection)object).getRenderingEnabled()) {
                        reloadList.add(node.sectionPos);
                    }
                    for (int i = 3; i >= 0; --i) {
                        stack.push(node.getChildByIndex(i));
                    }
                }
                LongLinkedOpenHashSet setsLong = new LongLinkedOpenHashSet();
                Iterator iterator = reloadList.iterator();
                while (iterator.hasNext()) {
                    long pos = (Long)iterator.next();
                    if (setsLong.contains(pos)) continue;
                    quadtree.reloadPos(pos);
                    setsLong.add(pos);
                    for (EDhDirection direction : EDhDirection.ADJ_DIRECTIONS) {
                        long adjacentPos = DhSectionPos.getAdjacentPos((long)pos, (EDhDirection)direction);
                        setsLong.add(adjacentPos);
                    }
                }
            }
        }
    }

    public static MapColor computeBaseColor(IClientLevelWrapper instance, DhBlockPos dhBlockPos, IBiomeWrapper iBiomeWrapper, IBlockStateWrapper iBlockStateWrapper, FullDataPointIdMap fullDataMapping, LongArrayList fullColumnData, IWrapperFactory WRAPPER_FACTORY) {
        BlockStateWrapper blockStateWrapper;
        if (CommonConfig.isSnowyWinter() && !dhBlockPos.equals((Object)DhBlockPos.ZERO) && iBlockStateWrapper instanceof BlockStateWrapper && !(blockStateWrapper = (BlockStateWrapper)iBlockStateWrapper).isAir()) {
            BlockPos mcPos = McObjectConverter.Convert((DhBlockPos)dhBlockPos);
            ClientLevel level = Minecraft.getInstance().level;
            BlockState blockState = blockStateWrapper.blockState;
            if (instance instanceof ClientLevelWrapper) {
                ClientLevelWrapper clientLevelWrapper = (ClientLevelWrapper)instance;
                ResourceKey holderKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)iBiomeWrapper.getSerialString()));
                Holder.Reference holder = clientLevelWrapper.getLevel().registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(holderKey);
                if (MapChecker.shouldSnowAtBiome((Level)level, (Biome)holder.value(), blockState, level.getRandom(), blockState.getSeed(mcPos), mcPos)) {
                    HashSet blockStatesToIgnore = WRAPPER_FACTORY.getRendererIgnoredBlocks((ILevelWrapper)instance);
                    for (int i = 0; i < fullColumnData.size(); ++i) {
                        int belowBottomY;
                        BlockStateWrapper blockStateWrapper_NowQuery;
                        IBlockStateWrapper iBlockStateWrapper_NowQuery;
                        long fullData = fullColumnData.getLong(i);
                        int id = FullDataPointUtil.getId((long)fullData);
                        try {
                            iBlockStateWrapper_NowQuery = fullDataMapping.getBlockStateWrapper(id);
                        }
                        catch (IndexOutOfBoundsException e) {
                            continue;
                        }
                        int bottomY = FullDataPointUtil.getBottomY((long)fullData);
                        int blockHeight = FullDataPointUtil.getHeight((long)fullData);
                        int topY = bottomY + blockHeight;
                        if (((Boolean)CommonConfig.Debug.notLightAbove.get()).booleanValue() && iBlockStateWrapper_NowQuery instanceof BlockStateWrapper) {
                            blockStateWrapper_NowQuery = (BlockStateWrapper)iBlockStateWrapper_NowQuery;
                            if (blockStateWrapper_NowQuery.blockState != null && blockStateWrapper_NowQuery.blockState.getBlock() instanceof LightBlock && blockStateWrapper_NowQuery.blockState.hasProperty((Property)LightBlock.LEVEL) && (Integer)blockStateWrapper_NowQuery.blockState.getValue((Property)LightBlock.LEVEL) == 0) break;
                        }
                        if (!(iBlockStateWrapper_NowQuery instanceof BlockStateWrapper)) continue;
                        blockStateWrapper_NowQuery = (BlockStateWrapper)iBlockStateWrapper_NowQuery;
                        if (iBlockStateWrapper_NowQuery.isAir() || blockStatesToIgnore.contains(iBlockStateWrapper_NowQuery)) continue;
                        if (bottomY + instance.getMinHeight() == dhBlockPos.getY() && (MapChecker.getDefaultBlockTypeFlag(blockStateWrapper_NowQuery.blockState) != 0 || !blockStateWrapper_NowQuery.isSolid() && !blockStateWrapper_NowQuery.isLiquid())) {
                            return MapColor.SNOW;
                        }
                        if (blockStateWrapper_NowQuery.isLiquid() || blockStateWrapper_NowQuery.blockState.blocksMotion()) continue;
                        if (i + 1 >= fullColumnData.size() || (belowBottomY = FullDataPointUtil.getBottomY((long)fullColumnData.getLong(i + 1))) + instance.getMinHeight() != dhBlockPos.getY()) break;
                        return MapColor.SNOW;
                    }
                }
            }
        }
        return null;
    }

    public static Biome recoverBiomeObject(BiomeWrapper biomeWrapper, IClientLevelWrapper iClientLevelWrapper) {
        return null;
    }

    public static void clearRenderCache() {
        ClientLevelWrapper clientLevelWrapper;
        IClientLevelWrapper iClientLevelWrapper;
        IDhClientWorld clientWorld = SharedApi.getIDhClientWorld();
        if (Minecraft.getInstance().level != null && (iClientLevelWrapper = ClientLevelWrapper.getWrapper((ClientLevel)Minecraft.getInstance().level)) instanceof ClientLevelWrapper && (iClientLevelWrapper = clientWorld.getLevel((ILevelWrapper)(clientLevelWrapper = (ClientLevelWrapper)iClientLevelWrapper))) instanceof IDhClientLevel) {
            IDhClientLevel clientLevel = (IDhClientLevel)iClientLevelWrapper;
            clientLevel.clearRenderCache();
        }
    }

    public static IBlockStateWrapper shouldFrozen(ClientLevelWrapper instance, IBiomeWrapper biomeWrapper, DhBlockPosMutable dhBlockPosMutable, BlockState blockState, FullDataPointIdMap fullDataMapping, LongArrayList fullColumnData, int index) {
        Holder holder;
        Object object;
        if (((Boolean)ClientConfig.Debug.frozenWater.get()).booleanValue() && (object = biomeWrapper.getWrappedMcObject()) instanceof Holder && (object = (holder = (Holder)object).value()) instanceof Biome) {
            Biome biome = (Biome)object;
            if (blockState.is(Blocks.WATER) && blockState.getFluidState().isSourceOfType((Fluid)Fluids.WATER)) {
                if (index > 0 && index < fullColumnData.size() - 1) {
                    try {
                        int id = FullDataPointUtil.getId((long)fullColumnData.getLong(index - 1));
                        if (!fullDataMapping.getBlockStateWrapper(id).isAir()) {
                            return null;
                        }
                    }
                    catch (IndexOutOfBoundsException id) {
                        // empty catch block
                    }
                }
                BlockPos mcPos = McObjectConverter.Convert((DhBlockPos)dhBlockPosMutable);
                ClientLevel level = instance.getLevel();
                if (MapChecker.shouldSnowAtBiome((Level)level, biome, blockState, level.getRandom(), blockState.getSeed(mcPos), mcPos)) {
                    return BlockStateWrapper.fromBlockState((BlockState)Blocks.ICE.defaultBlockState(), (ILevelWrapper)instance);
                }
            }
        }
        return null;
    }
}

