/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.compat.jei;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.data.craft.HumidityControl;
import com.teamtea.eclipticseasons.api.data.misc.PosAndBlockStateCheck;
import com.teamtea.eclipticseasons.client.render.ber.XYZ;
import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import com.teamtea.eclipticseasons.common.registry.ItemRegistry;
import com.teamtea.eclipticseasons.compat.jei.ESJEIPlugin;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.Internal;
import mezz.jei.library.gui.ingredients.TagContentTooltipComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class JEIHumidityControlCategory
implements IRecipeCategory<HumidityControl> {
    private final IDrawable icon;
    private final IGuiHelper guiHelper;
    private final IDrawableStatic clock;
    private final IDrawableStatic shadow;
    private final IDrawableStatic range;
    private final IDrawableStatic right_down_arrow;
    private final IDrawableStatic blue_arrow_up;
    private final IDrawableStatic red_arrow;
    private final IDrawableStatic blankDrawable;

    public JEIHumidityControlCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.icon = guiHelper.createDrawableItemStack(((Item)ItemRegistry.block_in_wooden_grate_block_item.get()).getDefaultInstance());
        this.blankDrawable = guiHelper.createBlankDrawable(128, 60);
        this.clock = this.createIDrawableStatic("clock.png");
        this.shadow = this.createIDrawableStatic("shadow.png");
        this.range = this.createIDrawableStatic("range.png");
        this.right_down_arrow = this.createIDrawableStatic("right_down_arrow.png");
        this.blue_arrow_up = this.createIDrawableStatic("blue_arrow_up.png");
        this.red_arrow = this.createIDrawableStatic("red_arrow.png");
    }

    public IDrawableStatic createIDrawableStatic(String name) {
        return this.guiHelper.drawableBuilder(EclipticSeasons.rl("textures/gui/icon/" + name), 0, 0, 16, 16).setTextureSize(16, 16).build();
    }

    @NotNull
    public RecipeType<HumidityControl> getRecipeType() {
        return ESJEIPlugin.HUMIDITY_CONTROL_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"info.eclipticseasons.humidity_control");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.blankDrawable;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HumidityControl recipe, @NotNull IFocusGroup ingredients) {
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 8).addIngredients(Ingredient.of((ItemStack[])recipe.ingredient().getItems()));
        builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addIngredients(Ingredient.of((ItemLike[])((ItemLike[])BlockRegistry.getAllChangedGrateBlocks().toArray(ItemLike[]::new))));
        for (PosAndBlockStateCheck check : recipe.checks()) {
            if (!check.block().blocks().isPresent() || ((HolderSet)check.block().blocks().get()).size() <= 0) continue;
            for (Holder blockHolder : (HolderSet)check.block().blocks().get()) {
                builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addIngredients(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)blockHolder.value()}));
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 100, 40).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{recipe.result()}));
    }

    public void getTooltip(ITooltipBuilder tooltip, HumidityControl recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        super.getTooltip(tooltip, (Object)recipe, recipeSlotsView, mouseX, mouseY);
        if (mouseX > 32.0 && mouseX < 64.0 && mouseY > 4.0 && mouseY < 60.0) {
            int currentTimeMillis = (int)(System.currentTimeMillis() % Integer.MAX_VALUE) / 2000;
            for (PosAndBlockStateCheck check : recipe.checks()) {
                if (!check.block().blocks().isPresent() || ((HolderSet)check.block().blocks().get()).size() <= 0) continue;
                int index = currentTimeMillis % ((HolderSet)check.block().blocks().get()).size();
                Holder blockHolder = ((HolderSet)check.block().blocks().get()).get(index);
                if (check.offset().getY() == -1 && check.offset().getX() == 0 && check.offset().getZ() == 0) {
                    tooltip.add((FormattedText)Component.translatable((String)"info.eclipticseasons.humidity_control.below_need", (Object[])new Object[]{((Block)blockHolder.value()).getName().withStyle(ChatFormatting.GRAY)}));
                } else {
                    tooltip.add((FormattedText)Component.translatable((String)"info.eclipticseasons.humidity_control.common_need", (Object[])new Object[]{((Block)blockHolder.value()).getName().withStyle(ChatFormatting.GRAY)}));
                }
                tooltip.add((FormattedText)Component.translatable((String)"info.eclipticseasons.humidity_control.extra_hint"));
                IJeiRuntime jeiRuntime = Internal.getJeiRuntime();
                IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
                IIngredientRenderer renderer = ingredientManager.getIngredientRenderer((Object)((Block)blockHolder.value()).asItem().getDefaultInstance());
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (Holder holder : (HolderSet)check.block().blocks().get()) {
                    stacks.add(((Block)holder.value()).asItem().getDefaultInstance());
                }
                tooltip.add((TooltipComponent)new TagContentTooltipComponent(renderer, stacks));
            }
        }
    }

    public void draw(HumidityControl recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        IDrawableStatic iDrawableStatic;
        this.guiHelper.getSlotDrawable().draw(guiGraphics, 15, 7);
        this.guiHelper.getSlotDrawable().draw(guiGraphics, 99, 39);
        guiGraphics.pose().pushPose();
        int shadow_y = 4;
        for (PosAndBlockStateCheck posAndBlockStateCheck : recipe.checks()) {
            if (posAndBlockStateCheck.offset().getY() == 0) continue;
            shadow_y += 20;
            break;
        }
        guiGraphics.pose().translate(25.0f, (float)shadow_y, 0.0f);
        guiGraphics.pose().scale(4.0f, 3.0f, 4.0f);
        this.shadow.draw(guiGraphics, 0, 0);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(41.0f, 3.0f, 0.0f);
        guiGraphics.pose().scale(2.0f, 2.0f, 2.0f);
        int currentTimeMillis = (int)(System.currentTimeMillis() % Integer.MAX_VALUE) / 2000;
        for (PosAndBlockStateCheck check : recipe.checks()) {
            if (!check.block().blocks().isPresent() || ((HolderSet)check.block().blocks().get()).size() <= 0) continue;
            int index = currentTimeMillis % ((HolderSet)check.block().blocks().get()).size();
            Holder blockHolder = ((HolderSet)check.block().blocks().get()).get(index);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(16 * check.offset().getX()), (float)(-16 * check.offset().getY()), (float)(16 * check.offset().getZ()));
            float x = 7.0f;
            float y = -1.0f;
            int guiOffset = 0;
            if (blockHolder.isBound()) {
                BlockState blockState = ((Block)blockHolder.value()).defaultBlockState();
                BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
                BakedModel bakedmodel = blockRenderer.getBlockModel(blockState);
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(x + 8.0f, y + 8.0f, (float)(150 + (bakedmodel.isGui3d() ? guiOffset : 0)));
                try {
                    guiGraphics.pose().scale(16.0f, -16.0f, 16.0f);
                    guiGraphics.pose().mulPose(XYZ.deg_to_rad(30, 225, 0));
                    guiGraphics.pose().scale(0.625f, 0.625f, 0.625f);
                    blockRenderer.renderSingleBlock(blockState, guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY);
                }
                catch (Throwable throwable) {
                    EclipticSeasons.logger(throwable);
                }
                guiGraphics.pose().popPose();
            }
            guiGraphics.pose().popPose();
        }
        currentTimeMillis = (int)(System.currentTimeMillis() % Integer.MAX_VALUE) / 1200;
        guiGraphics.pose().translate(0.0f, 0.0f, 20.0f);
        List<Block> list = BlockRegistry.getAllChangedGrateBlocks();
        int index = currentTimeMillis % list.size();
        guiGraphics.renderItem(BlockRegistry.getOriginalCopperGrateBlock(list.get(index)).asItem().getDefaultInstance(), 0, 0);
        guiGraphics.pose().popPose();
        Font font = Minecraft.getInstance().font;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(96.0f, 0.0f, 0.0f);
        this.clock.draw(guiGraphics, 0, 0);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(0.75f, 0.75f, 0.75f);
        String timeString = recipe.noCost() ? "\u221e" : (int)((float)recipe.lasting_time() / Minecraft.getInstance().level.tickRateManager().tickrate()) + "s";
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, timeString, 20.0f, 9.0f / 1.5f, Color.GRAY.getRGB(), false);
        guiGraphics.pose().popPose();
        currentTimeMillis = (int)(System.currentTimeMillis() % Integer.MAX_VALUE) / 1800;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.5f, 10.0f, 0.0f);
        Object aString = "";
        if (currentTimeMillis % 2 == 0) {
            iDrawableStatic = recipe.level() > 0 ? this.blue_arrow_up : this.red_arrow;
            aString = "" + Math.abs(recipe.level());
        } else {
            iDrawableStatic = this.range;
            aString = "" + recipe.range();
        }
        iDrawableStatic.draw(guiGraphics, 0, 0);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(0.75f, 0.75f, 0.75f);
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, (String)aString, 20.0f, 9.0f / 1.5f + 1.0f, Color.GRAY.getRGB(), false);
        guiGraphics.pose().popPose();
        guiGraphics.pose().popPose();
        guiGraphics.pose().popPose();
        this.right_down_arrow.draw(guiGraphics, 80, 24);
    }
}

