/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.compat.vanilla;

import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.constant.climate.ISnowTerm;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.tag.ClimateTypeBiomeTags;
import com.teamtea.eclipticseasons.api.misc.IBiomeTagHolder;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.biome.BiomeClimateManager;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;

public class VanillaWeather {
    public static boolean isInWinter(Level level) {
        return EclipticSeasonsApi.getInstance().getSolarTerm(level).getSeason() == Season.WINTER;
    }

    public static boolean isInSummer(Level level) {
        return EclipticSeasonsApi.getInstance().getSolarTerm(level).getSeason() == Season.SUMMER;
    }

    public static Biome.Precipitation handlePrecipitationAt(Biome biome, BlockPos pos) {
        Level level = VanillaWeather.getValidLevel(biome);
        return VanillaWeather.handlePrecipitationAt(level, biome, pos);
    }

    @Deprecated
    public static boolean hasMonsoonalPrecipitation(Biome biome) {
        Level level = VanillaWeather.getValidLevel(biome);
        return VanillaWeather.hasPrecipitation(level, biome);
    }

    public static boolean hasPrecipitation(Level level, Biome biome) {
        SolarTerm solarTerm = EclipticSeasonsApi.getInstance().getSolarTerm(level);
        boolean hasPrecipitation = biome.getModifiedClimateSettings().hasPrecipitation();
        TagKey<Biome> tag = ((IBiomeTagHolder)biome).eclipticseasons$getBindTag();
        if (tag.equals(ClimateTypeBiomeTags.MONSOONAL)) {
            Season season = solarTerm.getSeason();
            hasPrecipitation = season == Season.SUMMER || season == Season.AUTUMN;
        }
        return hasPrecipitation;
    }

    public static Biome.Precipitation handlePrecipitationAt(Level level, Biome biome, BlockPos pos) {
        Biome.Precipitation resultPrecipitation = Biome.Precipitation.NONE;
        SolarTerm solarTerm = EclipticSeasonsApi.getInstance().getSolarTerm(level);
        boolean hasPrecipitation = VanillaWeather.hasPrecipitation(level, biome);
        if (hasPrecipitation) {
            resultPrecipitation = biome.coldEnoughToSnow(pos) ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN;
            boolean isServer = level instanceof ServerLevel;
            ISnowTerm snowTerm = SolarTerm.getSnowTerm(biome, isServer, EclipticUtil.getSnowTempChange(level));
            boolean flag_cold = snowTerm.maySnow(solarTerm, biome, pos, isServer);
            if (resultPrecipitation == Biome.Precipitation.RAIN) {
                if (flag_cold) {
                    resultPrecipitation = Biome.Precipitation.SNOW;
                }
            } else if (!flag_cold) {
                resultPrecipitation = Biome.Precipitation.RAIN;
            }
        }
        return resultPrecipitation;
    }

    public static Level getValidLevel(Biome biome) {
        boolean isOnServer = VanillaWeather.isOnServerThread(biome);
        if (isOnServer) {
            return WeatherManager.getMainServerLevel();
        }
        return VanillaWeather.getUsingClientLevel();
    }

    public static boolean isOnServerThread(Biome biome) {
        if (FMLLoader.getDist() == Dist.DEDICATED_SERVER) {
            return true;
        }
        return BiomeClimateManager.BIOME_TAG_KEY_MAP.containsKey(biome);
    }

    public static Level getUsingClientLevel() {
        for (Level level : WeatherManager.BIOME_WEATHER_LIST.keySet()) {
            if (!level.isClientSide()) continue;
            return level;
        }
        return null;
    }

    public static int replaceThunderDelay(Level level, Integer call) {
        switch (EclipticSeasonsApi.getInstance().getSolarTerm(level).getSeason()) {
            case SPRING: {
                return Mth.clamp((int)(call - 10000), (int)0, (int)ServerLevel.THUNDER_DELAY.getMaxValue());
            }
            case SUMMER: {
                return Mth.clamp((int)(call - 20000), (int)0, (int)ServerLevel.THUNDER_DELAY.getMaxValue());
            }
            case AUTUMN: {
                return Mth.clamp((int)(call + 20000), (int)0, (int)(ServerLevel.THUNDER_DELAY.getMaxValue() + 20000));
            }
            case WINTER: {
                return Mth.clamp((int)(call + 50000), (int)0, (int)(ServerLevel.THUNDER_DELAY.getMaxValue() + 50000));
            }
        }
        return call;
    }

    public static int replaceRainDelay(Level level, Integer call) {
        switch (EclipticSeasonsApi.getInstance().getSolarTerm(level).getSeason()) {
            case SPRING: {
                return Mth.clamp((int)(call - 20000), (int)0, (int)ServerLevel.RAIN_DELAY.getMaxValue());
            }
            case SUMMER: {
                return Mth.clamp((int)(call - 10000), (int)0, (int)ServerLevel.RAIN_DELAY.getMaxValue());
            }
            case AUTUMN: {
                return Mth.clamp((int)(call + 5000), (int)0, (int)ServerLevel.RAIN_DELAY.getMaxValue());
            }
            case WINTER: {
                return Mth.clamp((int)(call + 20000), (int)0, (int)(ServerLevel.RAIN_DELAY.getMaxValue() + 20000));
            }
        }
        return call;
    }

    public static Biome.Precipitation getRainOrSnow(Level level, Biome biome, BlockPos pos) {
        return !level.isRaining() ? Biome.Precipitation.NONE : VanillaWeather.handlePrecipitationAt(level, biome, pos);
    }
}

