/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.data.api;

import java.nio.file.Path;
import net.minecraft.data.PackOutput;
import org.jetbrains.annotations.NotNull;

public class MutablePackOutput
extends PackOutput {
    private PackOutput original;
    private Path outputFolder;

    public MutablePackOutput(PackOutput original) {
        super(original.getOutputFolder());
        this.original = original;
        this.outputFolder = original.getOutputFolder();
    }

    public MutablePackOutput(PackOutput original, Path path) {
        super(original.getOutputFolder());
        this.original = original;
        this.outputFolder = path;
    }

    public MutablePackOutput set(Path newFolder) {
        this.outputFolder = newFolder;
        this.original = new PackOutput(this.outputFolder);
        return this;
    }

    public MutablePackOutput move(Path newFolder) {
        return new MutablePackOutput(this.original, this.original.getOutputFolder().resolve(newFolder));
    }

    public void reset() {
        this.outputFolder = this.original.getOutputFolder();
    }

    @NotNull
    public Path getOutputFolder() {
        return this.outputFolder;
    }
}

