/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.data.api.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.data.client.model.ESModelLoadedJson;
import com.teamtea.eclipticseasons.api.data.client.model.multipart.AndConditionLike;
import com.teamtea.eclipticseasons.api.data.client.model.multipart.ConditionLike;
import com.teamtea.eclipticseasons.api.data.client.model.multipart.KeyValueConditionLike;
import com.teamtea.eclipticseasons.api.data.client.model.multipart.MultiPartLike;
import com.teamtea.eclipticseasons.api.data.client.model.multipart.OrConditionLike;
import com.teamtea.eclipticseasons.api.data.client.model.multipart.SelectorLike;
import com.teamtea.eclipticseasons.api.data.client.model.variant.MultiVariantLike;
import com.teamtea.eclipticseasons.api.data.client.model.variant.VariantLike;
import com.teamtea.eclipticseasons.common.registry.SnowDefinitionsRegistry;
import com.teamtea.eclipticseasons.data.api.provider.base.ESClientDataMapProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModelDefinitionProvider
extends ESClientDataMapProvider<ESModelLoadedJson> {
    private final ExtraModelProvider blockModels;

    public AbstractModelDefinitionProvider(PackOutput output, String modid, ExistingFileHelper helper, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, modid, helper, registries, "eclipticseasons/model_definitions", ESModelLoadedJson.CODEC);
        this.blockModels = new ExtraModelProvider(output, modid, helper);
    }

    protected ExtraModelProvider models() {
        return this.blockModels;
    }

    @Override
    protected abstract void gather(HolderLookup.Provider var1);

    @Override
    protected CompletableFuture<?> run(CachedOutput output, HolderLookup.Provider provider) {
        return CompletableFuture.allOf(super.run(output, provider), this.models().generateAll(output));
    }

    public static ResourceLocation withBlockFolder(ResourceLocation rl) {
        String prefix = "block/";
        if (rl.getPath().startsWith(prefix)) {
            return rl;
        }
        return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)("block/" + rl.getPath()));
    }

    public ResourceLocation snow_rl(String path) {
        String prefix = "snowy/";
        if (path.startsWith(prefix)) {
            return AbstractModelDefinitionProvider.withBlockFolder(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path));
        }
        return AbstractModelDefinitionProvider.withBlockFolder(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)("snowy/" + path)));
    }

    public ResourceLocation snow_rl(ResourceLocation resourceLocation) {
        String prefix = "snowy/";
        if (resourceLocation.getPath().startsWith(prefix)) {
            return AbstractModelDefinitionProvider.withBlockFolder(resourceLocation);
        }
        return AbstractModelDefinitionProvider.withBlockFolder(resourceLocation.withPrefix(prefix));
    }

    protected static VariantLike.VariantBuilder variant(ExtraModelBuilder extraModelBuilder) {
        return VariantLike.builder(AbstractModelDefinitionProvider.withBlockFolder(extraModelBuilder.getLocation()));
    }

    protected VariantLike.VariantBuilder variant(String path) {
        return VariantLike.builder(AbstractModelDefinitionProvider.withBlockFolder(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path)));
    }

    protected static VariantLike.VariantBuilder variant(ResourceLocation resourceLocation) {
        return VariantLike.builder(AbstractModelDefinitionProvider.withBlockFolder(resourceLocation));
    }

    @NotNull
    protected static ConditionLike condition(String key, String value) {
        return new KeyValueConditionLike(key, value);
    }

    @NotNull
    public static ConditionLike condition(Property<?> property, Object object) {
        return new KeyValueConditionLike(property, object);
    }

    @NotNull
    protected static ConditionLike and(ConditionLike ... conditionLikes) {
        return new AndConditionLike(List.of(conditionLikes));
    }

    @NotNull
    protected static ConditionLike or(ConditionLike ... conditionLikes) {
        return new OrConditionLike(List.of(conditionLikes));
    }

    @SafeVarargs
    @NotNull
    protected static String conditionString(Pair<Property<?>, Comparable<?>> ... conditions) {
        return Arrays.stream(conditions).collect(Collectors.groupingBy(Pair::getFirst, Collectors.mapping(Pair::getSecond, Collectors.toList()))).entrySet().stream().map(e -> ((Property)e.getKey()).getName() + "=" + ((List)e.getValue()).stream().map(Object::toString).collect(Collectors.joining("|"))).collect(Collectors.joining(","));
    }

    @NotNull
    protected static String conditionString(Map<Property<?>, Comparable<?>> conditions) {
        return conditions.entrySet().stream().map(e -> ((Property)e.getKey()).getName() + "=" + String.valueOf(e.getValue())).collect(Collectors.joining(","));
    }

    protected BlockModelDefinitionBuilder addSnowyBlockModelDefinition(Block block) {
        return this.addBlockModelDefinition(block, SnowDefinitionsRegistry.getSnowModelPath(this.modid, block));
    }

    public BlockModelDefinitionBuilder addBlockModelDefinition(Block block, ResourceLocation location) {
        BlockModelDefinitionBuilder variantModelBuilder = (BlockModelDefinitionBuilder)new BlockModelDefinitionBuilder(this.models(), block, location).self();
        this.add(location, variantModelBuilder::build);
        return variantModelBuilder;
    }

    public PartialStateModelDefinitionBuilder addPartialStateModelDefinition(ResourceLocation location, Block ... blocks) {
        Map<Property<? extends Comparable<?>>, List<? extends Comparable<?>>> collect = Arrays.stream(blocks).map(block -> block.getStateDefinition().getProperties()).flatMap(Collection::stream).collect(Collectors.toMap(e -> e, e -> new ArrayList(e.getPossibleValues())));
        return this.addPartialStateModelDefinition(location, collect);
    }

    @SafeVarargs
    public final PartialStateModelDefinitionBuilder addPartialStateModelDefinition(ResourceLocation location, Property<? extends Comparable<?>> ... allowProperties) {
        return this.addPartialStateModelDefinition(location, Arrays.stream(allowProperties).collect(Collectors.toMap(e -> e, e -> List.copyOf(e.getPossibleValues()), (a, b) -> a, LinkedHashMap::new)));
    }

    public PartialStateModelDefinitionBuilder addPartialStateModelDefinition(ResourceLocation location, Map<Property<? extends Comparable<?>>, List<? extends Comparable<?>>> allowValues) {
        PartialStateModelDefinitionBuilder variantModelBuilder = (PartialStateModelDefinitionBuilder)new PartialStateModelDefinitionBuilder(this.models(), allowValues, location).self();
        this.add(location, variantModelBuilder::build);
        return variantModelBuilder;
    }

    public ModelDefinitionBuilder addModelDefinition(ResourceLocation location) {
        ModelDefinitionBuilder variantModelBuilder = new ModelDefinitionBuilder(this.models(), location);
        this.add(location, variantModelBuilder::build);
        return variantModelBuilder;
    }

    public ModelDefinitionBuilder simple(ResourceLocation location) {
        return this.addModelDefinition(location).singleWithExist();
    }

    protected static class ExtraModelProvider
    extends ModelProvider<ExtraModelBuilder> {
        public ExtraModelProvider(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
            super(output, modid, "block", ExtraModelBuilder::new, existingFileHelper);
        }

        @NotNull
        public CompletableFuture<?> run(@NotNull CachedOutput cache) {
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }

        @NotNull
        public String getName() {
            return "Block Model";
        }

        protected void registerModels() {
        }

        public ExtraModelBuilder withExistingParent(String name, String parent) {
            return (ExtraModelBuilder)super.withExistingParent(name, parent);
        }

        public ExtraModelBuilder withExistingParent(String name, ResourceLocation parent) {
            return (ExtraModelBuilder)super.withExistingParent(name, parent);
        }

        public ExtraModelBuilder withExistingParent(String path, String parent, boolean notSave) {
            ExtraModelBuilder extraModelBuilder = this.withExistingParent(path, parent);
            ResourceLocation outputLoc = AbstractModelDefinitionProvider.withBlockFolder(path.contains(":") ? ResourceLocation.parse((String)path) : ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path));
            if (notSave) {
                this.generatedModels.remove(outputLoc);
            }
            return extraModelBuilder;
        }

        public ExtraModelBuilder snowyWithExistingParent(String name) {
            return (ExtraModelBuilder)super.withExistingParent("snowy/" + name, name);
        }

        public ExtraModelBuilder snowyWithExistingParent(String name, String parent) {
            return (ExtraModelBuilder)super.withExistingParent("snowy/" + name, parent);
        }

        @NotNull
        public ExtraModelBuilder getBuilder(@NotNull String path) {
            Preconditions.checkNotNull((Object)path, (Object)"Path must not be null");
            ResourceLocation outputLoc = AbstractModelDefinitionProvider.withBlockFolder(path.contains(":") ? ResourceLocation.parse((String)path) : ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path));
            this.existingFileHelper.trackGenerated(outputLoc, (ExistingFileHelper.IResourceType)MODEL);
            return (ExtraModelBuilder)((Object)this.generatedModels.computeIfAbsent(outputLoc, this.factory));
        }

        @NotNull
        public ExtraModelBuilder getBuilder(@NotNull ResourceLocation path) {
            Preconditions.checkNotNull((Object)path, (Object)"Path must not be null");
            ResourceLocation outputLoc = AbstractModelDefinitionProvider.withBlockFolder(path);
            this.existingFileHelper.trackGenerated(outputLoc, (ExistingFileHelper.IResourceType)MODEL);
            return (ExtraModelBuilder)((Object)this.generatedModels.computeIfAbsent(outputLoc, this.factory));
        }

        @NotNull
        public CompletableFuture<?> generateAll(@NotNull CachedOutput cache) {
            return super.generateAll(cache);
        }
    }

    public static class ExtraModelBuilder
    extends ModelBuilder<ExtraModelBuilder> {
        public ExtraModelBuilder(ResourceLocation outputLocation, ExistingFileHelper existingFileHelper) {
            super(outputLocation, existingFileHelper);
        }

        private ExtraModelBuilder self() {
            return this;
        }

        public ExtraModelBuilder texture(String key, ResourceLocation texture) {
            Preconditions.checkNotNull((Object)key, (Object)"Key must not be null");
            Preconditions.checkNotNull((Object)texture, (Object)"Texture must not be null");
            this.textures.put(key, texture.toString());
            return this.self();
        }

        public ExtraModelBuilder cross() {
            return this.texture("cross", this.getUncheckedLocation());
        }
    }

    public static class BlockModelDefinitionBuilder
    extends ModelDefinitionBuilder {
        protected final Block owner;

        protected BlockModelDefinitionBuilder(ExtraModelProvider models, Block block, ResourceLocation defLoc) {
            super(models, defLoc);
            this.owner = block;
        }

        public BlockModelDefinitionBuilder variantsForAllStatesExceptExact(Function<BlockState, ExtraModelBuilder> mapper, Property<?> ... ignored) {
            return this.variantsForAllStatesExcept(state -> new VariantLike[]{VariantLike.builder(((ExtraModelBuilder)((Object)((Object)mapper.apply((BlockState)state)))).getLocation()).build()}, ignored);
        }

        public BlockModelDefinitionBuilder variantsForAllStatesExceptSingle(Function<BlockState, VariantLike.VariantBuilder> mapper, Property<?> ... ignored) {
            return this.variantsForAllStatesExcept(state -> new VariantLike[]{((VariantLike.VariantBuilder)mapper.apply((BlockState)state)).build()}, ignored);
        }

        public BlockModelDefinitionBuilder variantsForAllStatesExcept(Function<BlockState, VariantLike[]> mapper, Property<?> ... ignored) {
            HashSet<PartialState> seen = new HashSet<PartialState>();
            for (BlockState fullState : this.owner.getStateDefinition().getPossibleStates()) {
                VariantLike[] variantLikes;
                LinkedHashMap propertyValues = Maps.newLinkedHashMap((Map)fullState.getValues());
                for (Property<?> p : ignored) {
                    propertyValues.remove(p);
                }
                PartialState partialState = new PartialState(propertyValues);
                if (!seen.add(partialState) || (variantLikes = mapper.apply(fullState)).length <= 0) continue;
                this.variant(AbstractModelDefinitionProvider.conditionString(propertyValues), variantLikes);
            }
            return this;
        }
    }

    public static class ModelDefinitionBuilder {
        private final ResourceLocation defLoc;
        protected final Map<ConditionLike, List<VariantLike>> selectorLikes = new LinkedHashMap<ConditionLike, List<VariantLike>>();
        protected final ExtraModelProvider models;
        protected boolean replace = false;
        protected final Set<String> requirements = new LinkedHashSet<String>();
        protected Map<String, List<VariantLike>> multiVariants = new LinkedHashMap<String, List<VariantLike>>();

        private ModelDefinitionBuilder(ExtraModelProvider models, ResourceLocation defLoc) {
            this.defLoc = defLoc;
            this.models = models;
        }

        protected ModelDefinitionBuilder self() {
            return this;
        }

        public ModelDefinitionBuilder replace(boolean replace) {
            this.replace = replace;
            return this.self();
        }

        public ModelDefinitionBuilder requireMod(String modid) {
            this.requirements.add(modid);
            return this.self();
        }

        public ModelDefinitionBuilder clearRequirements(String modid) {
            this.requirements.clear();
            return this.self();
        }

        public ModelDefinitionBuilder stagedVariants(String variantKey, int count) {
            this.clearCache();
            for (int i = 0; i < count; ++i) {
                ResourceLocation stageId = AbstractModelDefinitionProvider.withBlockFolder(this.defLoc).withSuffix("_stage" + i);
                VariantLike variant = VariantLike.builder(stageId).build();
                this.variant(variantKey + "=" + i, variant);
                this.models.cross(stageId.toString(), stageId);
            }
            this.replace(true);
            return this.self();
        }

        @SafeVarargs
        protected final ModelDefinitionBuilder simple(Function<ResourceLocation, ExtraModelBuilder> ... model) {
            this.clearCache();
            ResourceLocation withPrefix = AbstractModelDefinitionProvider.withBlockFolder(this.defLoc);
            if (model.length == 1) {
                this.variant(VariantLike.builder(withPrefix).build());
                model[0].apply(withPrefix);
            } else {
                int i = 0;
                while (i < model.length) {
                    ResourceLocation variantId = this.defLoc.withSuffix("_" + i);
                    int finalI = i++;
                    model[finalI].apply(variantId);
                    this.variant(VariantLike.builder(variantId).build());
                }
            }
            return this.self();
        }

        public ModelDefinitionBuilder multiPartWithGenerate(VariantLike variant, Function<ResourceLocation, ExtraModelBuilder> modelGenerator) {
            return this.multiPartWithGenerate(SelectorLike.EMPTY_CONDITION, modelGenerator, variant);
        }

        public ModelDefinitionBuilder multiPartWithGenerate(ConditionLike condition, Function<ResourceLocation, ExtraModelBuilder> modelGenerator, VariantLike variant) {
            return this.multiPartWithGenerate(condition, variant.getModelLocation(), modelGenerator, variant);
        }

        public ModelDefinitionBuilder multiPartWithGenerate(ConditionLike condition, ResourceLocation modelLoc, Function<ResourceLocation, ExtraModelBuilder> modelGenerator, VariantLike ... variants) {
            modelGenerator.apply(modelLoc);
            return this.multiPart(condition, variants);
        }

        public ModelDefinitionBuilder multiPartWithGenerate(ConditionLike condition, Supplier<List<ExtraModelBuilder>> modelGenerator) {
            return this.multiPart(condition, (VariantLike[])modelGenerator.get().stream().map(AbstractModelDefinitionProvider::variant).map(VariantLike.VariantBuilder::build).toArray(VariantLike[]::new));
        }

        public ModelDefinitionBuilder multiPartWithGenerateSingle(ConditionLike condition, Supplier<ExtraModelBuilder> modelGenerator) {
            return this.multiPart(condition, AbstractModelDefinitionProvider.variant(modelGenerator.get()).build());
        }

        public ModelDefinitionBuilder multiPart(VariantLike ... variant) {
            return this.multiPart(SelectorLike.EMPTY_CONDITION, variant);
        }

        public ModelDefinitionBuilder multiPart(@Nullable ConditionLike condition, VariantLike ... variant) {
            condition = condition == null ? SelectorLike.EMPTY_CONDITION : condition;
            this.selectorLikes.computeIfAbsent(condition, k -> new ArrayList()).addAll(List.of(variant));
            return this.self();
        }

        public ModelDefinitionBuilder variantWithGenerate(VariantLike variant, Function<ResourceLocation, ExtraModelBuilder> modelGenerator) {
            return this.variantWithGenerate("", modelGenerator, variant);
        }

        public ModelDefinitionBuilder variantWithGenerate(String condition, Function<ResourceLocation, ExtraModelBuilder> modelGenerator, VariantLike variant) {
            return this.variantWithGenerate(condition, variant.getModelLocation(), modelGenerator, variant);
        }

        public ModelDefinitionBuilder variantWithGenerate(String condition, ResourceLocation modelLoc, Function<ResourceLocation, ExtraModelBuilder> modelGenerator, VariantLike ... variants) {
            modelGenerator.apply(modelLoc);
            return this.variant(condition, variants);
        }

        public ModelDefinitionBuilder variant(VariantLike ... variant) {
            return this.variant("", variant);
        }

        public ModelDefinitionBuilder variant(@Nullable String condition, VariantLike ... variant) {
            condition = condition == null ? "" : condition;
            this.multiVariants.computeIfAbsent(condition, k -> new ArrayList()).addAll(List.of(variant));
            return this.self();
        }

        protected void clearVariantCache() {
            this.multiVariants.clear();
        }

        protected void clearCache() {
            this.clearVariantCache();
            this.selectorLikes.clear();
        }

        public ModelDefinitionBuilder singleCross() {
            ResourceLocation withPrefix = AbstractModelDefinitionProvider.withBlockFolder(this.defLoc);
            return this.singleCross(withPrefix);
        }

        public ModelDefinitionBuilder singleCross(ResourceLocation texturePath) {
            this.clearCache();
            ResourceLocation withPrefix = AbstractModelDefinitionProvider.withBlockFolder(this.defLoc);
            this.variant(VariantLike.builder(withPrefix).build());
            this.models.cross(withPrefix.toString(), texturePath);
            return this.self();
        }

        public ModelDefinitionBuilder singleWithExist() {
            this.clearCache();
            ResourceLocation withPrefix = AbstractModelDefinitionProvider.withBlockFolder(this.defLoc);
            this.variant(VariantLike.builder(withPrefix).build());
            return this.self();
        }

        public ESModelLoadedJson build() {
            return ESModelLoadedJson.builder().replace(this.replace).require(this.requirements.stream().toList()).variants(this.multiVariants.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new MultiVariantLike((List)e.getValue())))).multiPartLike(new MultiPartLike(this.selectorLikes.entrySet().stream().map(e -> new SelectorLike((ConditionLike)e.getKey(), new MultiVariantLike((List)e.getValue()))).toList())).build();
        }
    }

    public static class PartialStateModelDefinitionBuilder
    extends ModelDefinitionBuilder {
        private final Map<Property<?>, List<? extends Comparable<?>>> allowValues;

        protected PartialStateModelDefinitionBuilder(ExtraModelProvider models, Map<Property<?>, List<? extends Comparable<?>>> allowValues, ResourceLocation defLoc) {
            super(models, defLoc);
            this.allowValues = allowValues;
        }

        public PartialStateModelDefinitionBuilder variantsForAllStatesExceptExact(Function<PartialState, ExtraModelBuilder> mapper, Property<?> ... ignored) {
            return this.variantsForAllStatesExcept(state -> new VariantLike[]{VariantLike.builder(((ExtraModelBuilder)((Object)((Object)mapper.apply((PartialState)state)))).getLocation()).build()}, ignored);
        }

        public PartialStateModelDefinitionBuilder variantsForAllStatesExceptSingle(Function<PartialState, VariantLike.VariantBuilder> mapper, Property<?> ... ignored) {
            return this.variantsForAllStatesExcept(state -> new VariantLike[]{((VariantLike.VariantBuilder)mapper.apply((PartialState)state)).build()}, ignored);
        }

        public PartialStateModelDefinitionBuilder variantsForAllStatesExcept(Function<PartialState, VariantLike[]> mapper, Property<?> ... ignored) {
            HashSet<PartialState> seen = new HashSet<PartialState>();
            for (PartialState partialState : PartialState.combine(this.allowValues)) {
                VariantLike[] variantLikes;
                if (!seen.add(partialState) || (variantLikes = mapper.apply(partialState)).length <= 0) continue;
                this.variant(AbstractModelDefinitionProvider.conditionString(partialState.map), variantLikes);
            }
            return this;
        }
    }

    public record PartialState(Map<Property<?>, Comparable<?>> map) {
        public <T extends Comparable<T>> T getValue(Property<T> property) {
            Comparable value = this.map.getOrDefault(property, null);
            return (T)value;
        }

        public static List<PartialState> combine(Map<Property<?>, List<? extends Comparable<?>>> map) {
            ArrayList properties = new ArrayList(map.keySet());
            ArrayList<PartialState> result = new ArrayList<PartialState>();
            PartialState.backtrack(properties, map, 0, new LinkedHashMap(), result);
            return result;
        }

        private static void backtrack(List<Property<?>> properties, Map<Property<?>, List<? extends Comparable<?>>> map, int index, LinkedHashMap<Property<?>, Comparable<?>> current, List<PartialState> result) {
            if (index == properties.size()) {
                result.add(new PartialState(new LinkedHashMap(current)));
                return;
            }
            Property<?> prop = properties.get(index);
            List<Comparable<?>> values = map.get(prop);
            if (values == null || values.isEmpty()) {
                PartialState.backtrack(properties, map, index + 1, current, result);
                return;
            }
            for (Comparable<?> val : values) {
                current.put(prop, val);
                PartialState.backtrack(properties, map, index + 1, current, result);
                current.remove(prop);
            }
        }
    }
}

