/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.data.api.provider.base;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public abstract class ESClientDataMapProvider<T>
implements DataProvider {
    private final PackOutput output;
    protected final String modid;
    public final ExistingFileHelper helper;
    protected final Map<ResourceLocation, Supplier<T>> outMap;
    private final String type;
    private final Codec<T> codec;
    protected CompletableFuture<HolderLookup.Provider> registries;

    public ESClientDataMapProvider(PackOutput output, String modid, ExistingFileHelper helper, CompletableFuture<HolderLookup.Provider> registries, String type, Codec<T> codec) {
        this.output = output;
        this.modid = modid;
        this.helper = helper;
        this.outMap = new HashMap<ResourceLocation, Supplier<T>>();
        this.type = type;
        this.codec = codec;
        this.registries = registries;
    }

    protected abstract void gather(HolderLookup.Provider var1);

    protected void add(String path, T t) {
        this.outMap.put(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path), () -> t);
    }

    protected void add(ResourceLocation path, T t) {
        this.outMap.put(path, () -> t);
    }

    protected void add(String path, Supplier<T> t) {
        this.outMap.put(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path), t);
    }

    protected void add(ResourceLocation path, Supplier<T> t) {
        this.outMap.put(path, t);
    }

    protected Path resolvePath(ResourceLocation id) {
        return this.output.getOutputFolder(PackOutput.Target.RESOURCE_PACK).resolve(id.getNamespace()).resolve(this.type).resolve(id.getPath() + ".json");
    }

    public CompletableFuture<?> run(CachedOutput output) {
        return this.registries.thenCompose(provider -> this.run(output, (HolderLookup.Provider)provider));
    }

    protected CompletableFuture<?> run(CachedOutput output, HolderLookup.Provider provider) {
        this.gather(provider);
        return CompletableFuture.allOf((CompletableFuture[])this.outMap.entrySet().stream().map(e -> ESClientDataMapProvider.saveStable(output, provider, this.codec, ((Supplier)e.getValue()).get(), this.resolvePath((ResourceLocation)e.getKey()))).toArray(CompletableFuture[]::new));
    }

    @NotNull
    public String getName() {
        return "Client Provider for %s: %s".formatted(this.modid, this.type);
    }

    static <T> CompletableFuture<?> saveStable(CachedOutput output, HolderLookup.Provider registries, Codec<T> codec, T value, Path path) {
        RegistryOps registryops = registries.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        JsonElement jsonelement = (JsonElement)codec.encodeStart((DynamicOps)registryops, value).getOrThrow();
        return ESClientDataMapProvider.saveStable(output, jsonelement, path);
    }

    static CompletableFuture<?> saveStable(CachedOutput output, JsonElement json, Path path) {
        return CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                HashingOutputStream hashingoutputstream = new HashingOutputStream(Hashing.sha1(), (OutputStream)bytearrayoutputstream);
                try (JsonWriter jsonwriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)hashingoutputstream, StandardCharsets.UTF_8));){
                    jsonwriter.setSerializeNulls(false);
                    jsonwriter.setIndent(" ".repeat(Math.max(0, INDENT_WIDTH.get())));
                    Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                    gson.toJson(json, jsonwriter);
                }
                output.writeIfNeeded(path, bytearrayoutputstream.toByteArray(), hashingoutputstream.hash());
            }
            catch (IOException ioexception) {
                LOGGER.error("Failed to save file to {}", (Object)path, (Object)ioexception);
            }
        }, Util.backgroundExecutor());
    }
}

