/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.data.extend.example;

import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.solar.color.base.TemperateSolarTermColors;
import com.teamtea.eclipticseasons.api.data.client.BiomeColor;
import com.teamtea.eclipticseasons.api.data.client.ColorMode;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.data.misc.SolarTermValueMap;
import com.teamtea.eclipticseasons.common.registry.AgroClimateRegistry;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import com.teamtea.eclipticseasons.data.api.provider.base.ESClientDataMapProvider;
import com.teamtea.eclipticseasons.data.general.datapack.DatapackRegistryGenerator;
import java.awt.Color;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.RegistryPatchGenerator;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BiomeColorProvider
extends ESClientDataMapProvider<BiomeColor> {
    public BiomeColorProvider(PackOutput output, String modid, ExistingFileHelper helper, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, modid, helper, registries, "eclipticseasons/biome_colors", BiomeColor.CODEC);
        CompletableFuture lookup = RegistryPatchGenerator.createLookup(registries, (RegistrySetBuilder)DatapackRegistryGenerator.REGISTRY_SET_BUILDER);
        lookup.thenApply(RegistrySetBuilder.PatchedRegistries::patches);
        this.registries = lookup.thenApply(RegistrySetBuilder.PatchedRegistries::full);
    }

    @Override
    protected void gather(HolderLookup.Provider provider) {
        HolderLookup.RegistryLookup biomeRegistryLookup = provider.lookupOrThrow(Registries.BIOME);
        HolderLookup.RegistryLookup aThrow = provider.lookupOrThrow(ESRegistries.AGRO_CLIMATE);
        this.add("plains", new BiomeColor((HolderSet<Biome>)biomeRegistryLookup.getOrThrow(Tags.Biomes.IS_PLAINS), SolarTermValueMap.builder().putSeason(Season.SPRING, new ColorMode(Optional.of(Color.PINK.getRGB()), Optional.empty(), Optional.empty())).putSeason(Season.SUMMER, new ColorMode(Optional.of(Color.GREEN.getRGB()), Optional.empty(), Optional.empty())).putSeason(Season.AUTUMN, new ColorMode(Optional.of(Color.ORANGE.getRGB()), Optional.empty(), Optional.empty())).putSeason(Season.WINTER, new ColorMode(Optional.of(Color.BLUE.getRGB()), Optional.empty(), Optional.empty())).putSeason(Season.NONE, new ColorMode(Optional.of(Color.WHITE.getRGB()), Optional.empty(), Optional.empty())).ofBuild(), Optional.empty()));
        SolarTermValueMap.Builder<ColorMode> builder = SolarTermValueMap.builder();
        for (TemperateSolarTermColors colors : TemperateSolarTermColors.collectValues()) {
            builder.putSolarTerm(SolarTerm.get(colors.ordinal()), new ColorMode(Optional.of(colors.getLeaveColor()), Optional.of(Float.valueOf(colors.getMix())), Optional.empty()));
        }
        this.add("plains_2", new BiomeColor((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomeRegistryLookup.getOrThrow(Biomes.PLAINS)}), Optional.empty(), builder.ofBuild()));
        SolarTermValueMap.Builder<ColorMode> builder2 = SolarTermValueMap.builder().putSeason(Season.SPRING, new ColorMode(Optional.of(Color.PINK.getRGB()), Optional.empty(), Optional.empty())).putSeason(Season.SUMMER, new ColorMode(Optional.of(Color.GREEN.getRGB()), Optional.empty(), Optional.empty())).putSeason(Season.AUTUMN, new ColorMode(Optional.of(Color.ORANGE.getRGB()), Optional.empty(), Optional.empty())).putSeason(Season.WINTER, new ColorMode(Optional.of(Color.BLUE.getRGB()), Optional.empty(), Optional.empty())).putSeason(Season.NONE, new ColorMode(Optional.of(Color.WHITE.getRGB()), Optional.empty(), Optional.empty()));
        builder2.climate((Holder<AgroClimaticZone>)aThrow.getOrThrow(AgroClimateRegistry.COLD));
        this.add("snowy_plains", new BiomeColor((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomeRegistryLookup.getOrThrow(Biomes.SNOWY_PLAINS)}), Optional.empty(), builder2.ofBuild()));
    }
}

