/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.data.extend.extra_snow;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.data.client.model.variant.VariantLike;
import com.teamtea.eclipticseasons.common.block.base.SimpleHorizontalEntityBlock;
import com.teamtea.eclipticseasons.data.api.provider.AbstractModelDefinitionProvider;
import com.teamtea.eclipticseasons.data.general.datapack.client.ClientModelDefinitionProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.PitcherCropBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.TorchflowerCropBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class ExtraClientModelDefinitionProvider
extends ClientModelDefinitionProvider {
    public ExtraClientModelDefinitionProvider(PackOutput output, String modid, ExistingFileHelper helper, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, modid, helper, registries);
    }

    @Override
    protected void gather(HolderLookup.Provider provider) {
        this.addSnowyBlockModelDefinition(Blocks.SUNFLOWER).variantsForAllStatesExceptExact(state -> {
            if (state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
                return (AbstractModelDefinitionProvider.ExtraModelBuilder)this.models().withExistingParent("block/snowy/sunflower_bottom", "sunflower_bottom").texture("cross", "block/snowy/sunflower_bottom");
            }
            return (AbstractModelDefinitionProvider.ExtraModelBuilder)((AbstractModelDefinitionProvider.ExtraModelBuilder)((AbstractModelDefinitionProvider.ExtraModelBuilder)((AbstractModelDefinitionProvider.ExtraModelBuilder)this.models().withExistingParent("block/snowy/sunflower_top", "sunflower_top").texture("cross", "block/snowy/sunflower_top")).texture("front", "block/snowy/sunflower_front")).texture("back", "block/snowy/sunflower_back")).texture("particle", "block/snowy/sunflower_front");
        }, new Property[0]).replace(true);
        this.addSnowyPlant(Blocks.OAK_SAPLING);
        this.addSnowyPlant(Blocks.DARK_OAK_SAPLING);
        this.addSnowyPlant(Blocks.ACACIA_SAPLING);
        this.addSnowyPlant(Blocks.BIRCH_SAPLING);
        this.addSnowyPlant(Blocks.JUNGLE_SAPLING);
        this.addSnowyPlant(Blocks.SPRUCE_SAPLING);
        this.addSnowyPlant(Blocks.CHERRY_SAPLING);
        this.addSnowyBlockModelDefinition(Blocks.MANGROVE_PROPAGULE).variantsForAllStatesExceptExact(state -> {
            if (((Boolean)state.getValue((Property)MangrovePropaguleBlock.HANGING)).booleanValue()) {
                return (AbstractModelDefinitionProvider.ExtraModelBuilder)this.models().withExistingParent("block/snowy/mangrove_propagule_hanging_" + String.valueOf(state.getValue((Property)MangrovePropaguleBlock.AGE)), "mangrove_propagule_hanging_" + String.valueOf(state.getValue((Property)MangrovePropaguleBlock.AGE))).texture("propagule", "block/snowy/mangrove_propagule_hanging");
            }
            return (AbstractModelDefinitionProvider.ExtraModelBuilder)this.models().withExistingParent("block/snowy/mangrove_propagule", "mangrove_propagule").texture("sapling", "block/snowy/mangrove_propagule");
        }, new Property[]{SaplingBlock.STAGE, BlockStateProperties.WATERLOGGED}).replace(true);
        this.addSnowyPlant(Blocks.RED_MUSHROOM);
        this.addSnowyPlant(Blocks.BROWN_MUSHROOM);
        this.addSnowyPlant(Blocks.ALLIUM);
        this.addSnowyPlant(Blocks.AZURE_BLUET);
        this.addSnowyPlant(Blocks.BLUE_ORCHID);
        this.addSnowyPlant(Blocks.CORNFLOWER);
        this.addSnowyPlant(Blocks.DANDELION);
        this.addSnowyPlant(Blocks.LILY_OF_THE_VALLEY);
        this.addSnowyPlant(Blocks.ORANGE_TULIP);
        this.addSnowyPlant(Blocks.PINK_TULIP);
        this.addSnowyPlant(Blocks.WHITE_TULIP);
        this.addSnowyPlant(Blocks.RED_TULIP);
        this.addSnowyPlant(Blocks.OXEYE_DAISY);
        this.addSnowyPlant(Blocks.POPPY);
        this.addSnowyPlant(Blocks.WITHER_ROSE);
        this.addSnowyCrossDoublePlant(Blocks.LILAC);
        this.addSnowyCrossDoublePlant(Blocks.PEONY);
        this.addSnowyCrossDoublePlant(Blocks.ROSE_BUSH);
        this.addSnowyPlant(Blocks.TORCHFLOWER);
        this.addSnowyBlockModelDefinition(Blocks.TORCHFLOWER_CROP).variantsForAllStatesExceptExact(state -> this.models().snowyWithExistingParent("torchflower_crop_stage" + String.valueOf(state.getValue((Property)TorchflowerCropBlock.AGE))).cross(), new Property[0]).replace(true);
        this.addSnowyBlockModelDefinition(Blocks.PITCHER_PLANT).variantsForAllStatesExceptExact(state -> {
            if (state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
                return (AbstractModelDefinitionProvider.ExtraModelBuilder)this.models().snowyWithExistingParent("pitcher_plant_bottom").texture("bottom", "block/snowy/pitcher_crop_bottom_stage_4");
            }
            return (AbstractModelDefinitionProvider.ExtraModelBuilder)this.models().snowyWithExistingParent("pitcher_plant_top").texture("top", "block/snowy/pitcher_crop_top_stage_4");
        }, new Property[0]).replace(true);
        this.addSnowyBlockModelDefinition(Blocks.PITCHER_CROP).variantsForAllStatesExceptExact(state -> {
            if (state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
                int age = (Integer)state.getValue((Property)PitcherCropBlock.AGE);
                AbstractModelDefinitionProvider.ExtraModelBuilder pitcherBottom = (AbstractModelDefinitionProvider.ExtraModelBuilder)((AbstractModelDefinitionProvider.ExtraModelBuilder)this.models().snowyWithExistingParent("pitcher_crop_bottom_stage_" + age).texture("pitcher_top", "block/snowy/pitcher_crop_top")).texture("pitcher_side", "block/snowy/pitcher_crop_side");
                if (age > 0) {
                    pitcherBottom.texture("stage_" + age + (age > 2 ? "_bottom" : ""), "block/snowy/pitcher_crop_bottom_stage_" + age);
                }
                return pitcherBottom;
            }
            int age = (Integer)state.getValue((Property)PitcherCropBlock.AGE);
            AbstractModelDefinitionProvider.ExtraModelBuilder pitcherBottom = this.models().snowyWithExistingParent("pitcher_crop_top_stage_" + age);
            if (age > 2) {
                pitcherBottom.texture("stage_" + age + "_top", "block/snowy/pitcher_crop_top_stage_" + age);
            }
            return pitcherBottom;
        }, new Property[0]).replace(true);
        for (Block block : List.of(Blocks.BEETROOTS, Blocks.CARROTS, Blocks.POTATOES, Blocks.WHEAT)) {
            this.addSnowyBlockModelDefinition(block).variantsForAllStatesExceptExact(state -> {
                int age = ((CropBlock)block).getAge(state);
                String path = block.builtInRegistryHolder().getKey().location().getPath() + "_stage" + age / (block == Blocks.CARROTS || block == Blocks.POTATOES ? (age == 6 ? 3 : 2) : 1);
                return this.models().snowyWithExistingParent(path).texture("crop", this.snow_rl(path));
            }, new Property[0]).replace(true);
        }
        for (Block block : List.of(Blocks.MELON_STEM, Blocks.PUMPKIN_STEM)) {
            this.addSnowyBlockModelDefinition(block).variantsForAllStatesExceptExact(state -> {
                int age = (Integer)state.getValue((Property)StemBlock.AGE);
                String path = block.builtInRegistryHolder().getKey().location().getPath();
                return this.models().snowyWithExistingParent(path + "_stage" + age, this.snow_rl("template/stem_growth" + age).toString()).texture("stem", this.snow_rl("stem"));
            }, new Property[0]).replace(false);
        }
        for (Pair pair : List.of(Pair.of((Object)Blocks.MELON_STEM, (Object)Blocks.ATTACHED_MELON_STEM), Pair.of((Object)Blocks.PUMPKIN_STEM, (Object)Blocks.ATTACHED_PUMPKIN_STEM))) {
            String path1 = ((Block)pair.getFirst()).builtInRegistryHolder().getKey().location().getPath();
            String path2 = ((Block)pair.getSecond()).builtInRegistryHolder().getKey().location().getPath();
            AbstractModelDefinitionProvider.ExtraModelBuilder builder = this.models().snowyWithExistingParent(path2, this.snow_rl("template/stem_fruit").toString()).texture("stem", this.snow_rl("stem")).texture("upperstem", this.snow_rl("attached_stem"));
            this.addSnowyBlockModelDefinition((Block)pair.getSecond()).variantsForAllStatesExcept(state -> new VariantLike[]{ExtraClientModelDefinitionProvider.variant(builder).rotationY((SimpleHorizontalEntityBlock.getRotateYByFacing(state) + 90) % 360).build()}, new Property[0]).replace(false);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return super.getName() + "(Extra Version)";
    }
}

