/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.data.general.datapack.client;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.client.model.ESModelLoadedJson;
import com.teamtea.eclipticseasons.api.data.client.model.variant.MultiVariantLike;
import com.teamtea.eclipticseasons.api.data.client.model.variant.VariantLike;
import com.teamtea.eclipticseasons.client.core.ExtraModelManager;
import com.teamtea.eclipticseasons.common.core.snow.ClientModelDefinitions;
import com.teamtea.eclipticseasons.common.registry.SnowDefinitionsRegistry;
import com.teamtea.eclipticseasons.data.api.provider.AbstractModelDefinitionProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ClientModelDefinitionProvider
extends AbstractModelDefinitionProvider {
    public ClientModelDefinitionProvider(PackOutput output, String modid, ExistingFileHelper helper, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, modid, helper, registries);
    }

    public AbstractModelDefinitionProvider.ExtraModelBuilder getModel(String resourceLocation) {
        return (AbstractModelDefinitionProvider.ExtraModelBuilder)new AbstractModelDefinitionProvider.ExtraModelBuilder(ClientModelDefinitionProvider.withBlockFolder(EclipticSeasons.rl(resourceLocation)), this.helper).parent((ModelFile)new ModelFile.ExistingModelFile(ClientModelDefinitionProvider.withBlockFolder(EclipticSeasons.rl(resourceLocation)), this.helper));
    }

    @Override
    protected void gather(HolderLookup.Provider provider) {
        this.simple(ClientModelDefinitions.SNOWY_LEAVES_TOP).requireMod(this.modid);
        this.simple(ClientModelDefinitions.SNOWY_LEAVES_ATTACH).requireMod(this.modid);
        this.simple(ClientModelDefinitions.OVERLAY_TINY).requireMod(this.modid);
        this.simple(ClientModelDefinitions.OVERLAY).requireMod(this.modid);
        this.addModelDefinition(ClientModelDefinitions.SNOWY_GRASS_BLOCK_OVERLAY).replace(true).variant(ClientModelDefinitionProvider.variant(this.models().withExistingParent("snowy_grass_block", "block/grass_block_snow").texture("top", ResourceLocation.withDefaultNamespace((String)"block/snow"))).build());
        this.addFlower();
        this.addModelDefinition(ClientModelDefinitions.SNOWY_SWEET_BERRY_BUSH).replace(true).stagedVariants(SweetBerryBushBlock.AGE.getName(), 4);
        this.addModelDefinition(ClientModelDefinitions.SNOWY_DEAD_BUSH).singleCross().replace(true);
        this.addModelDefinition(ClientModelDefinitions.SNOWY_SUGAR_CANE).singleCross().replace(true);
        this.addSnowyPlant(Blocks.BAMBOO_SAPLING, "bamboo_stage0");
        this.addSnowyBlockModelDefinition(Blocks.BAMBOO).multiPartWithGenerate(ClientModelDefinitionProvider.condition(BambooStalkBlock.AGE, (Object)BambooStalkBlock.AGE.getName(Integer.valueOf(0))), () -> IntStream.range(1, 5).mapToObj(i -> this.models().snowyWithExistingParent("bamboo%s_age0".formatted(i)).texture("all", this.snow_rl("bamboo_stalk"))).toList()).multiPartWithGenerate(ClientModelDefinitionProvider.condition(BambooStalkBlock.AGE, (Object)BambooStalkBlock.AGE.getName(Integer.valueOf(1))), () -> IntStream.range(1, 5).mapToObj(i -> this.models().snowyWithExistingParent("bamboo%s_age1".formatted(i)).texture("all", this.snow_rl("bamboo_stalk"))).toList()).multiPartWithGenerateSingle(ClientModelDefinitionProvider.condition(BambooStalkBlock.LEAVES, (Object)BambooStalkBlock.LEAVES.getName((Enum)BambooLeaves.LARGE)), () -> this.models().snowyWithExistingParent("bamboo_large_leaves").texture("texture", this.snow_rl("bamboo_large_leaves"))).multiPartWithGenerateSingle(ClientModelDefinitionProvider.condition(BambooStalkBlock.LEAVES, (Object)BambooStalkBlock.LEAVES.getName((Enum)BambooLeaves.SMALL)), () -> this.models().snowyWithExistingParent("bamboo_small_leaves").texture("texture", this.snow_rl("bamboo_small_leaves"))).replace(true);
        this.addBlockModelDefinition(Blocks.BAMBOO, SnowDefinitionsRegistry.getSnowModelPath(this.modid, Blocks.BAMBOO).withSuffix("_top")).multiPartWithGenerate(ClientModelDefinitionProvider.condition(BambooStalkBlock.AGE, (Object)BambooStalkBlock.AGE.getName(Integer.valueOf(0))), () -> IntStream.range(1, 5).mapToObj(i -> this.models().snowyWithExistingParent("bamboo%s_age0_top".formatted(i), "bamboo%s_age0".formatted(i)).texture("all", this.snow_rl("bamboo_stalk_top"))).toList()).multiPartWithGenerate(ClientModelDefinitionProvider.condition(BambooStalkBlock.AGE, (Object)BambooStalkBlock.AGE.getName(Integer.valueOf(1))), () -> IntStream.range(1, 5).mapToObj(i -> this.models().snowyWithExistingParent("bamboo%s_age1_top".formatted(i), "bamboo%s_age1".formatted(i)).texture("all", this.snow_rl("bamboo_stalk_top"))).toList()).multiPart(ClientModelDefinitionProvider.condition(BambooStalkBlock.LEAVES, (Object)BambooStalkBlock.LEAVES.getName((Enum)BambooLeaves.LARGE)), ClientModelDefinitionProvider.variant(this.snow_rl("bamboo_large_leaves")).build()).multiPart(ClientModelDefinitionProvider.condition(BambooStalkBlock.LEAVES, (Object)BambooStalkBlock.LEAVES.getName((Enum)BambooLeaves.SMALL)), ClientModelDefinitionProvider.variant(this.snow_rl("bamboo_small_leaves")).build()).replace(true);
    }

    protected void addSnowyPlant(Block plant) {
        this.addModelDefinition(SnowDefinitionsRegistry.getSnowModelPath(plant)).singleCross().replace(true);
    }

    protected AbstractModelDefinitionProvider.ModelDefinitionBuilder addSnowyCrossDoublePlant(Block lilac) {
        String path = ClientModelDefinitionProvider.getPath(lilac.builtInRegistryHolder().getKey().location());
        return this.addSnowyBlockModelDefinition(lilac).variantsForAllStatesExceptExact(state -> {
            if (state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
                return (AbstractModelDefinitionProvider.ExtraModelBuilder)this.models().snowyWithExistingParent(path + "_bottom").texture("cross", "block/snowy/%s_bottom".formatted(path));
            }
            return (AbstractModelDefinitionProvider.ExtraModelBuilder)this.models().snowyWithExistingParent(path + "_top").texture("cross", "block/snowy/%s_top".formatted(path));
        }, new Property[0]).replace(true);
    }

    protected void addSnowyPlant(Block plant, String texture) {
        this.addModelDefinition(SnowDefinitionsRegistry.getSnowModelPath(plant)).singleCross(ClientModelDefinitionProvider.withBlockFolder(EclipticSeasons.rl(texture).withPrefix("snowy/"))).replace(true);
    }

    private void addFlower() {
        for (SolarTerm solarTerm : SolarTerm.collectValues()) {
            int weight;
            if (solarTerm.isInTerms(SolarTerm.BEGINNING_OF_SPRING, SolarTerm.BEGINNING_OF_SUMMER)) {
                weight = (Math.abs(solarTerm.ordinal() - 3) + 1) * 56 * 2;
                this.add(ClientModelDefinitionProvider.getPath(EclipticSeasons.rl("flower_on_grass_" + solarTerm.getName())), ESModelLoadedJson.builder().variant("", this.buildMultiVariantLikeFromList(ExtraModelManager.flower_on_grass, weight)).build());
            }
            if (!solarTerm.isInTerms(SolarTerm.BEGINNING_OF_SUMMER, SolarTerm.BEGINNING_OF_AUTUMN)) continue;
            weight = (Math.abs(solarTerm.ordinal() - 7) + 1) * 42 * 2;
            this.add(ClientModelDefinitionProvider.getPath(EclipticSeasons.rl("fourleaf_clovers_" + solarTerm.getName())), ESModelLoadedJson.builder().variant("", this.buildMultiVariantLikeFromList(ExtraModelManager.fourleaf_clovers, weight)).build());
        }
    }

    private MultiVariantLike buildMultiVariantLikeFromList(List<ModelResourceLocation> modelResourceLocations, int emptyWeight) {
        ArrayList<VariantLike> list = new ArrayList<VariantLike>(modelResourceLocations.stream().map(ModelResourceLocation::id).map(r -> new VariantLike.VariantBuilder((ResourceLocation)r).weight(1).build()).toList());
        if (emptyWeight > 0) {
            list.add(ClientModelDefinitionProvider.variant(ResourceLocation.withDefaultNamespace((String)"block/air")).weight(emptyWeight).build());
        }
        return new MultiVariantLike(list);
    }

    private static String getPath(ResourceLocation overlay) {
        return overlay.getPath();
    }
}

