/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.data.general.model;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.client.core.ExtraModelManager;
import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ESBlockModelProvider
extends BlockModelProvider {
    public static final String BLOCK = "block/block";
    public static final String HANDHELD = "item/handheld";

    public ESBlockModelProvider(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        super(output, modid, existingFileHelper);
    }

    protected void registerModels() {
        for (ModelResourceLocation flowerOnGrass : ExtraModelManager.flower_on_grass) {
            ((BlockModelBuilder)this.withExistingParent(flowerOnGrass.id().getPath(), this.resource("grass_flower"))).texture("1", flowerOnGrass.id().getPath());
        }
        for (ModelResourceLocation flowerOnGrass : ExtraModelManager.fourleaf_clovers) {
            ((BlockModelBuilder)this.withExistingParent(flowerOnGrass.id().getPath(), this.resource("tinted_grass_flower"))).texture("1", flowerOnGrass.id().getPath());
        }
        for (ModelResourceLocation flowerOnGrass : ExtraModelManager.snow_edge_overlays) {
            ((BlockModelBuilder)this.withExistingParent(flowerOnGrass.id().getPath(), this.resource("grass_flower"))).texture("1", flowerOnGrass.id().getPath());
        }
        this.withExistingParent(BlockRegistry.block_in_copper_grate_block.getId().getPath(), this.blockName(Blocks.COPPER_GRATE));
        this.withExistingParent(BlockRegistry.block_in_exposed_copper_grate_block.getId().getPath(), this.blockName(Blocks.EXPOSED_COPPER_GRATE));
        this.withExistingParent(BlockRegistry.block_in_weathered_copper_grate_block.getId().getPath(), this.blockName(Blocks.WEATHERED_COPPER_GRATE));
        this.withExistingParent(BlockRegistry.block_in_oxidized_copper_grate_block.getId().getPath(), this.blockName(Blocks.OXIDIZED_COPPER_GRATE));
        this.withExistingParent(BlockRegistry.block_in_waxed_copper_grate_block.getId().getPath(), this.blockName(Blocks.COPPER_GRATE));
        this.withExistingParent(BlockRegistry.block_in_waxed_exposed_copper_grate_block.getId().getPath(), this.blockName(Blocks.EXPOSED_COPPER_GRATE));
        this.withExistingParent(BlockRegistry.block_in_waxed_weathered_copper_grate_block.getId().getPath(), this.blockName(Blocks.WEATHERED_COPPER_GRATE));
        this.withExistingParent(BlockRegistry.block_in_waxed_oxidized_copper_grate_block.getId().getPath(), this.blockName(Blocks.OXIDIZED_COPPER_GRATE));
        this.cubeAll(this.resource(BlockRegistry.block_in_wooden_grate_block.getId().getPath()).getPath(), EclipticSeasons.rl("block/wooden_grate"));
    }

    public ResourceLocation resource(String path) {
        return EclipticSeasons.rl("block/" + path);
    }

    private String blockName(Block block) {
        return "block/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }
}

