/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.mixin.client.chunk;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.misc.client.IExtraRendererContextOwner;
import com.teamtea.eclipticseasons.api.misc.client.IMapSlice;
import com.teamtea.eclipticseasons.client.core.ExtraRendererContext;
import com.teamtea.eclipticseasons.common.core.map.BiomeHolder;
import com.teamtea.eclipticseasons.common.core.map.ChunkInfoMap;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.map.SnowyRemover;
import com.teamtea.eclipticseasons.common.core.snow.SnowyMapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyStatusKeeper;
import com.teamtea.eclipticseasons.common.registry.AttachmentRegistry;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderChunkRegion.class})
public abstract class MixinRenderChunkRegion_IMapSlice
implements IMapSlice,
IExtraRendererContextOwner {
    @Shadow
    @Final
    protected Level level;
    @Shadow
    @Final
    public static int SIZE;
    @Shadow
    @Final
    private int minChunkX;
    @Shadow
    @Final
    private int minChunkZ;
    @Unique
    private static final int MAP_BLOCK_COUNT = 256;
    @Unique
    private int[][] HEIGHT_MAP;
    @Unique
    private int[][] SOLID_HEIGHT_MAP;
    @Unique
    private int[][] BIOME_MAP;
    @Unique
    private int[][] SNOWY_MAP;
    @Unique
    private SnowyStatusKeeper[] SNOWY_STATUS_MAP;
    @Unique
    private ExtraRendererContext eclipticseasons$rendererHolder = new ExtraRendererContext();

    @Shadow
    public static int index(int minX, int minZ, int x, int z) {
        return 0;
    }

    @Shadow
    protected abstract RenderChunk getChunk(int var1, int var2);

    @Inject(remap=false, method={"<init>(Lnet/minecraft/world/level/Level;II[Lnet/minecraft/client/renderer/chunk/RenderChunk;Lit/unimi/dsi/fastutil/longs/Long2ObjectFunction;)V"}, at={@At(value="TAIL")})
    private void eclipticseasons$init(Level level, int minChunkX, int minChunkZ, RenderChunk[] chunks, Long2ObjectFunction<ModelData> modelDataSnapshot, CallbackInfo ci) {
        this.HEIGHT_MAP = new int[SIZE * SIZE][256];
        this.BIOME_MAP = new int[SIZE * SIZE][256];
        this.SNOWY_MAP = new int[SIZE * SIZE][256];
        this.SOLID_HEIGHT_MAP = new int[SIZE * SIZE][256];
        this.SNOWY_STATUS_MAP = new SnowyStatusKeeper[SIZE * SIZE];
    }

    @Override
    public void forceMapSliceUpdate() {
        if (MapChecker.isValidDimension(this.level)) {
            int maxH = this.level.getMaxBuildHeight();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int sectionX = this.minChunkX; sectionX < this.minChunkX + SIZE; ++sectionX) {
                for (int sectionZ = this.minChunkZ; sectionZ < this.minChunkZ + SIZE; ++sectionZ) {
                    int localSectionIndex = MixinRenderChunkRegion_IMapSlice.index(this.minChunkX, this.minChunkZ, sectionX, sectionZ);
                    LevelChunk wrapped = this.getChunk((int)sectionX, (int)sectionZ).wrapped;
                    Heightmap heightmap = wrapped.getOrCreateHeightmapUnprimed(Heightmap.Types.MOTION_BLOCKING);
                    ChunkPos chunkPos = wrapped.getPos();
                    SnowyRemover snowyRemover = (SnowyRemover)wrapped.getData(AttachmentRegistry.SNOWY_REMOVER);
                    BiomeHolder biomeHolder = (BiomeHolder)wrapped.getData(AttachmentRegistry.BIOME_HOLDER);
                    int[] heights = this.HEIGHT_MAP[localSectionIndex];
                    int[] biomes = this.BIOME_MAP[localSectionIndex];
                    int[] snowys = this.SNOWY_MAP[localSectionIndex];
                    int[] solidHeights = this.SOLID_HEIGHT_MAP[localSectionIndex];
                    this.SNOWY_STATUS_MAP[localSectionIndex] = SnowyMapChecker.getSnowyStatusKeeperCopy(wrapped);
                    int startX = chunkPos.getMinBlockX();
                    int startZ = chunkPos.getMinBlockZ();
                    mutableBlockPos.setX(startX);
                    mutableBlockPos.setZ(startZ);
                    ChunkInfoMap chunkMap = MapChecker.getChunkMap(this.level, (BlockPos)mutableBlockPos);
                    if (chunkMap == null) {
                        MapChecker.getHeight(this.level, (BlockPos)mutableBlockPos);
                        chunkMap = MapChecker.getChunkMap(this.level, (BlockPos)mutableBlockPos);
                    }
                    if (chunkMap != null) {
                        for (int x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                int biomeId;
                                int index = x * 16 + z;
                                mutableBlockPos.setX(startX + x);
                                mutableBlockPos.setZ(startZ + z);
                                int y = chunkMap.getHeight((BlockPos)mutableBlockPos);
                                heights[index] = y > chunkMap.getMinY() ? y : MapChecker.getHeight(this.level, (BlockPos)mutableBlockPos);
                                mutableBlockPos.setY(heights[index] + 1);
                                if (mutableBlockPos.getY() > maxH) {
                                    mutableBlockPos.setY(this.level.getHeight(Heightmap.Types.MOTION_BLOCKING, mutableBlockPos.getX(), mutableBlockPos.getZ()));
                                }
                                biomes[index] = (biomeId = biomeHolder.getBiomeId((BlockPos)mutableBlockPos)) > -1 ? biomeId : MapChecker.biomeToId(this.level, (Biome)MapChecker.getUnCachedSurfaceBiome(this.level, (BlockPos)mutableBlockPos).value());
                                snowys[index] = snowyRemover.blockWatcher()[x][z];
                                solidHeights[index] = heightmap.getHighestTaken(x, z);
                            }
                        }
                        continue;
                    }
                    EclipticSeasons.logger("Warning, now try create slice for invalid level", this.level);
                }
            }
        }
    }

    @Override
    public int getBlockHeight(BlockPos pos) {
        int relBlockX = SectionPos.blockToSectionCoord((int)pos.getX());
        int relBlockZ = SectionPos.blockToSectionCoord((int)pos.getZ());
        int[] lightArrays = this.HEIGHT_MAP[MixinRenderChunkRegion_IMapSlice.index(this.minChunkX, this.minChunkZ, relBlockX, relBlockZ)];
        int localBlockX = pos.getX() & 0xF;
        int localBlockZ = pos.getZ() & 0xF;
        return lightArrays[localBlockX * 16 + localBlockZ];
    }

    @Override
    public int getSolidBlockHeight(BlockPos pos) {
        int relBlockX = SectionPos.blockToSectionCoord((int)pos.getX());
        int relBlockZ = SectionPos.blockToSectionCoord((int)pos.getZ());
        int[] lightArrays = this.SOLID_HEIGHT_MAP[MixinRenderChunkRegion_IMapSlice.index(this.minChunkX, this.minChunkZ, relBlockX, relBlockZ)];
        int localBlockX = pos.getX() & 0xF;
        int localBlockZ = pos.getZ() & 0xF;
        return lightArrays[localBlockX * 16 + localBlockZ];
    }

    @Override
    public int getSurfaceFaceBiomeId(BlockPos pos) {
        int relBlockX = SectionPos.blockToSectionCoord((int)pos.getX());
        int relBlockZ = SectionPos.blockToSectionCoord((int)pos.getZ());
        int[] lightArrays = this.BIOME_MAP[MixinRenderChunkRegion_IMapSlice.index(this.minChunkX, this.minChunkZ, relBlockX, relBlockZ)];
        int localBlockX = pos.getX() & 0xF;
        int localBlockZ = pos.getZ() & 0xF;
        return lightArrays[localBlockX * 16 + localBlockZ];
    }

    @Override
    public int getSnowyStatus(BlockPos pos) {
        int relBlockX = SectionPos.blockToSectionCoord((int)pos.getX());
        int relBlockZ = SectionPos.blockToSectionCoord((int)pos.getZ());
        int[] lightArrays = this.SNOWY_MAP[MixinRenderChunkRegion_IMapSlice.index(this.minChunkX, this.minChunkZ, relBlockX, relBlockZ)];
        int localBlockX = pos.getX() & 0xF;
        int localBlockZ = pos.getZ() & 0xF;
        return lightArrays[localBlockX * 16 + localBlockZ];
    }

    @Override
    public boolean isSnowyBlock(BlockPos pos) {
        int relBlockZ;
        int relBlockX = SectionPos.blockToSectionCoord((int)pos.getX());
        SnowyStatusKeeper lightArrays = this.SNOWY_STATUS_MAP[MixinRenderChunkRegion_IMapSlice.index(this.minChunkX, this.minChunkZ, relBlockX, relBlockZ = SectionPos.blockToSectionCoord((int)pos.getZ()))];
        return lightArrays != null && lightArrays.isSnowyBlock(pos);
    }

    @Override
    public ExtraRendererContext eclipticseasons$getContext() {
        return this.eclipticseasons$rendererHolder;
    }
}

