/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.mixin.common.level;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.core.map.ChunkInfoMap;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyMapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyStatusKeeper;
import com.teamtea.eclipticseasons.common.core.snow.WeatherStatusKeeper;
import com.teamtea.eclipticseasons.common.handler.CustomRandomTickHandler;
import com.teamtea.eclipticseasons.compat.vanilla.VanillaWeather;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class MixinServerLevel
extends Level {
    @Shadow
    public abstract ServerLevel getLevel();

    protected MixinServerLevel(WritableLevelData p_270739_, ResourceKey<Level> p_270683_, RegistryAccess p_270200_, Holder<DimensionType> p_270240_, Supplier<ProfilerFiller> p_270692_, boolean p_270904_, boolean p_270470_, long p_270248_, int p_270466_) {
        super(p_270739_, p_270683_, p_270200_, p_270240_, p_270692_, p_270904_, p_270470_, p_270248_, p_270466_);
    }

    @Inject(at={@At(value="HEAD")}, method={"setWeatherParameters"}, cancellable=true)
    public void eclipticseasons$setWeatherParameters(int pClearTime, int pWeatherTime, boolean pIsRaining, boolean pIsThundering, CallbackInfo ci) {
        if (EclipticUtil.hasLocalWeather(this)) {
            WeatherManager.onSetWeatherParameters(this.getLevel(), pClearTime, pWeatherTime, pIsRaining, pIsThundering);
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"resetWeatherCycle"}, cancellable=true)
    public void eclipticseasons$resetWeatherCycle(CallbackInfo ci) {
        if (EclipticUtil.hasLocalWeather(this)) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"advanceWeatherCycle"}, cancellable=true)
    public void eclipticseasons$advanceWeatherCycle(CallbackInfo ci) {
        boolean cancel = WeatherManager.agentAdvanceWeatherCycle(this.getLevel(), this.random);
        if (cancel && EclipticUtil.hasLocalWeather(this)) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"advanceWeatherCycle"}, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/util/valueproviders/IntProvider;sample(Lnet/minecraft/util/RandomSource;)I")})
    private int eclipticseasons$advanceWeatherCycle_sample_THUNDER_DELAY(IntProvider intProvider, RandomSource randomSource, Operation<Integer> original) {
        if (!EclipticUtil.hasLocalWeather(this)) {
            return VanillaWeather.replaceThunderDelay(this, (Integer)original.call(new Object[]{intProvider, randomSource}));
        }
        return (Integer)original.call(new Object[]{intProvider, randomSource});
    }

    @WrapOperation(method={"advanceWeatherCycle"}, at={@At(value="INVOKE", ordinal=3, target="Lnet/minecraft/util/valueproviders/IntProvider;sample(Lnet/minecraft/util/RandomSource;)I")})
    private int eclipticseasons$advanceWeatherCycle_sample_RAIN_DELAY(IntProvider intProvider, RandomSource randomSource, Operation<Integer> original) {
        if (!EclipticUtil.hasLocalWeather(this)) {
            return VanillaWeather.replaceRainDelay(this, (Integer)original.call(new Object[]{intProvider, randomSource}));
        }
        return (Integer)original.call(new Object[]{intProvider, randomSource});
    }

    @Inject(method={"tickChunk"}, at={@At(value="TAIL")})
    private void eclipticseasons$tickChunk_end(LevelChunk chunk, int randomTickSpeed, CallbackInfo ci) {
        CropGrowthHandler.handleChunkTick(this, chunk);
    }

    @WrapOperation(method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;isRaining()Z")})
    private boolean eclipticseasons$tickChunk_isRaining(ServerLevel serverLevel, Operation<Boolean> original, @Local(ordinal=0) LevelChunk levelChunk) {
        if (EclipticUtil.hasLocalWeather(this)) {
            return true;
        }
        return (Boolean)original.call(new Object[]{serverLevel});
    }

    @WrapOperation(method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;isThundering()Z")})
    private boolean eclipticseasons$tickChunk_isThundering(ServerLevel serverLevel, Operation<Boolean> original, @Local(ordinal=0) LevelChunk levelChunk) {
        if (EclipticUtil.hasLocalWeather(this)) {
            return true;
        }
        return (Boolean)original.call(new Object[]{serverLevel});
    }

    @WrapOperation(method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;isRainingAt(Lnet/minecraft/core/BlockPos;)Z")})
    private boolean eclipticseasons$tickChunk_checkRainDifficulty(ServerLevel serverLevel, BlockPos pos, Operation<Boolean> original, @Local(ordinal=0) LevelChunk levelChunk) {
        if (EclipticUtil.hasLocalWeather(this)) {
            return WeatherManager.isThunderAt((Level)serverLevel, pos) && serverLevel.isRainingAt(pos);
        }
        if (VanillaWeather.isInWinter((Level)serverLevel)) {
            return false;
        }
        return (Boolean)original.call(new Object[]{serverLevel, pos});
    }

    @Inject(method={"tickPrecipitation"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;getBiome(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/Holder;")})
    private void eclipticseasons$tickPrecipitation_setBiome_before(BlockPos blockPos, CallbackInfo ci, @Share(value="biome_holder") LocalRef<Holder<Biome>> biome, @Local(ordinal=1) BlockPos posAbove) {
        biome.set(EclipticUtil.hasLocalWeather(this) ? MapChecker.getSurfaceBiome(this, posAbove) : null);
    }

    @WrapOperation(method={"tickPrecipitation"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;getBiome(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/Holder;")})
    private Holder<Biome> eclipticseasons$tickPrecipitation_setBiome(ServerLevel instance, BlockPos pos, Operation<Holder<Biome>> original, @Share(value="biome_holder") LocalRef<Holder<Biome>> biome) {
        if (biome.get() == null) {
            biome.set((Object)((Holder)original.call(new Object[]{instance, pos})));
        }
        return (Holder)biome.get();
    }

    @Inject(method={"tickPrecipitation"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;isAreaLoaded(Lnet/minecraft/core/BlockPos;I)Z")})
    private void eclipticseasons$tickPrecipitation_melt(BlockPos blockPos, CallbackInfo ci, @Local(ordinal=1) BlockPos aboveGroundPos, @Share(value="biome_holder") LocalRef<Holder<Biome>> biome) {
        if (((Boolean)CommonConfig.Temperature.iceMelt.get()).booleanValue()) {
            CustomRandomTickHandler.SNOW_MELT_2.tick(this.getLevel(), (Holder<Biome>)((Holder)biome.get()), aboveGroundPos);
        }
    }

    @WrapOperation(method={"tickPrecipitation"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;shouldFreeze(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z")})
    private boolean eclipticseasons$tickPrecipitation_freeze(Biome instance, LevelReader pLevel, BlockPos pPos, Operation<Boolean> original, @Local(ordinal=2) BlockPos groundPos, @Share(value="biome_holder") LocalRef<Holder<Biome>> biome) {
        return CustomRandomTickHandler.checkExtraFreezeCondition(this.getLevel(), (Holder<Biome>)((Holder)biome.get()), groundPos);
    }

    @WrapOperation(method={"tickPrecipitation"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;shouldSnow(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z")})
    private boolean eclipticseasons$tickPrecipitation_snow(Biome instance, LevelReader levelReader, BlockPos level, Operation<Boolean> original, @Local(ordinal=1) BlockPos aboveGroundPos, @Share(value="biome_holder") LocalRef<Holder<Biome>> biome) {
        return CustomRandomTickHandler.checkExtraSnowCondition(this.getLevel(), (Holder<Biome>)((Holder)biome.get()), aboveGroundPos);
    }

    @WrapOperation(method={"tickPrecipitation"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;isRaining()Z")})
    private boolean eclipticseasons$tickPrecipitation_isRaining(ServerLevel serverLevel, Operation<Boolean> original, @Local(ordinal=1) BlockPos aboveGroundPos, @Share(value="biome_holder") LocalRef<Holder<Biome>> biome) {
        if (EclipticUtil.hasLocalWeather(this)) {
            return WeatherManager.getRainOrSnow((Level)serverLevel, (Biome)((Holder)biome.get()).value(), aboveGroundPos) != Biome.Precipitation.NONE;
        }
        return (Boolean)original.call(new Object[]{serverLevel});
    }

    @WrapOperation(method={"tickPrecipitation"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;getPrecipitationAt(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/biome/Biome$Precipitation;")})
    private Biome.Precipitation eclipticseasons$tickPrecipitation_getPrecipitationAt(Biome biome, BlockPos pos, Operation<Biome.Precipitation> original) {
        ServerLevel serverLevel = this.getLevel();
        if (EclipticUtil.hasLocalWeather(this)) {
            return WeatherManager.getPrecipitationAt((Level)serverLevel, biome, pos);
        }
        return VanillaWeather.handlePrecipitationAt((Level)serverLevel, biome, pos);
    }

    @Inject(method={"tickChunk"}, at={@At(value="HEAD")})
    private void eclipticseasons$tickChunk_prepare(LevelChunk chunk, int randomTickSpeed, CallbackInfo ci, @Share(value="snowy_status") LocalRef<SnowyStatusKeeper> keeper, @Share(value="weather_status") LocalRef<WeatherStatusKeeper> keeperWeather, @Share(value="chunk_info_map") LocalRef<ChunkInfoMap> mapLocalRef) {
        keeper.set((Object)SnowyMapChecker.getSnowyStatusKeeper((ChunkAccess)chunk));
        mapLocalRef.set((Object)MapChecker.getChunkInfoMapOrCreate((Level)this.getLevel(), chunk.getPos()));
        keeperWeather.set((Object)SnowyMapChecker.getWeatherStatusKeeper((ChunkAccess)chunk));
    }

    @ModifyExpressionValue(method={"tickChunk"}, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/server/level/ServerLevel;getBlockRandomPos(IIII)Lnet/minecraft/core/BlockPos;")})
    private BlockPos eclipticseasons$tickChunk_our_snow(BlockPos original, @Local(argsOnly=true) LevelChunk chunk, @Local ChunkPos chunkPos, @Share(value="snowy_status") LocalRef<SnowyStatusKeeper> keeper, @Share(value="weather_status") LocalRef<WeatherStatusKeeper> keeperWeather, @Share(value="chunk_info_map") LocalRef<ChunkInfoMap> mapLocalRef) {
        ChunkInfoMap chunkInfoMap;
        SnowyStatusKeeper data = (SnowyStatusKeeper)keeper.get();
        WeatherStatusKeeper weatherStatusKeeper = (WeatherStatusKeeper)keeperWeather.get();
        if (data != null && (chunkInfoMap = (ChunkInfoMap)mapLocalRef.get()) != null && weatherStatusKeeper != null) {
            data.tickChunk(this.getLevel(), chunk, chunkPos, original, chunkInfoMap, weatherStatusKeeper);
        }
        return original;
    }

    @Inject(method={"tickChunk"}, at={@At(value="RETURN")})
    private void eclipticseasons$tickChunk_sync(LevelChunk chunk, int randomTickSpeed, CallbackInfo ci, @Share(value="snowy_status") LocalRef<SnowyStatusKeeper> keeper, @Share(value="weather_status") LocalRef<WeatherStatusKeeper> keeperWeather) {
        SnowyStatusKeeper data;
        WeatherStatusKeeper weatherStatusKeeper = (WeatherStatusKeeper)keeperWeather.get();
        if (weatherStatusKeeper != null) {
            weatherStatusKeeper.updateAndSend(this.getLevel(), chunk);
        }
        if ((data = (SnowyStatusKeeper)keeper.get()) != null) {
            data.updateAndSend(this.getLevel(), chunk);
        }
    }
}

