/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.mixin.compat.sodium;

import com.llamalad7.mixinextras.sugar.Local;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.client.render.chunk.IceKeeper;
import com.teamtea.eclipticseasons.compat.sodium.SodiumBoard;
import com.teamtea.eclipticseasons.compat.sodium.SodiumStatus;
import com.teamtea.eclipticseasons.config.ClientConfig;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildContext;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderMeshingTask;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderTask;
import net.caffeinemc.mods.sodium.client.util.task.CancellationToken;
import net.caffeinemc.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkBuilderMeshingTask.class})
public abstract class MixinBlockRenderTask
extends ChunkBuilderTask<ChunkBuildOutput>
implements SodiumBoard {
    @Shadow
    @Final
    private ChunkRenderContext renderContext;
    @Unique
    private long eclipticseasons$time = 0L;
    @Unique
    private long eclipticseasons$countModel = 0L;

    public MixinBlockRenderTask(RenderSection render, int time, Vector3dc absoluteCameraPos) {
        super(render, time, absoluteCameraPos);
    }

    @Inject(method={"execute(Lnet/caffeinemc/mods/sodium/client/render/chunk/compile/ChunkBuildContext;Lnet/caffeinemc/mods/sodium/client/util/task/CancellationToken;)Lnet/caffeinemc/mods/sodium/client/render/chunk/compile/ChunkBuildOutput;"}, at={@At(value="RETURN")})
    private void eclipticseasons$compile_checkb(ChunkBuildContext buildContext, CancellationToken cancellationToken, CallbackInfoReturnable<ChunkBuildOutput> cir) {
        long l = System.currentTimeMillis() - this.eclipticseasons$time;
        if (l > (long)ClientConfig.Debug.minChunkCompileWarningTime.getAsInt()) {
            EclipticSeasons.logger("WARNING", Thread.currentThread().toString(), this.render.getPosition(), this.render.getPosition().center(), this.render.getOriginX(), this.render.getOriginY(), this.render.getOriginZ(), "Rebuild time: " + l, "Model check count: " + this.eclipticseasons$countModel);
        }
        this.eclipticseasons$time = 0L;
        this.eclipticseasons$countModel = 0L;
        ((SodiumStatus)buildContext.cache.getBlockRenderer()).eclipticseasons$bindCounter(null);
    }

    @Inject(method={"execute(Lnet/caffeinemc/mods/sodium/client/render/chunk/compile/ChunkBuildContext;Lnet/caffeinemc/mods/sodium/client/util/task/CancellationToken;)Lnet/caffeinemc/mods/sodium/client/render/chunk/compile/ChunkBuildOutput;"}, at={@At(value="HEAD")})
    private void eclipticseasons$compile_check(ChunkBuildContext buildContext, CancellationToken cancellationToken, CallbackInfoReturnable<ChunkBuildOutput> cir) {
        this.eclipticseasons$time = System.currentTimeMillis();
        this.eclipticseasons$countModel = 0L;
        ((SodiumStatus)buildContext.cache.getBlockRenderer()).eclipticseasons$bindCounter(this);
    }

    @Override
    public void eclipticseasons$addCount() {
        ++this.eclipticseasons$countModel;
    }

    @Inject(method={"execute(Lnet/caffeinemc/mods/sodium/client/render/chunk/compile/ChunkBuildContext;Lnet/caffeinemc/mods/sodium/client/util/task/CancellationToken;)Lnet/caffeinemc/mods/sodium/client/render/chunk/compile/ChunkBuildOutput;"}, remap=false, at={@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/compile/pipeline/FluidRenderer;render(Lnet/caffeinemc/mods/sodium/client/world/LevelSlice;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/material/FluidState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/caffeinemc/mods/sodium/client/render/chunk/translucent_sorting/TranslucentGeometryCollector;Lnet/caffeinemc/mods/sodium/client/render/chunk/compile/ChunkBuildBuffers;)V")})
    private void eclipticseasons$renderFrozenWaterIce(ChunkBuildContext buildContext, CancellationToken cancellationToken, CallbackInfoReturnable<ChunkBuildOutput> cir, @Local FluidState fluidState, @Local BlockState blockState, @Local(ordinal=0) BlockPos.MutableBlockPos blockPos, @Local(ordinal=1) BlockPos.MutableBlockPos modelOffset) {
        if (IceKeeper.notFrozen((BlockAndTintGetter)buildContext.cache.getWorldSlice(), (BlockPos)blockPos, blockState, fluidState)) {
            return;
        }
        BakedModel model = IceKeeper.getIceModel(blockState, fluidState);
        if (model != null) {
            buildContext.cache.getBlockRenderer().renderModel(model, IceKeeper.getFakeState(blockState, fluidState), (BlockPos)blockPos, (BlockPos)modelOffset);
        }
    }
}

