/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.mixin.compat.sodium;

import com.teamtea.eclipticseasons.api.misc.client.ISnowyGetter;
import com.teamtea.eclipticseasons.common.core.map.BiomeHolder;
import com.teamtea.eclipticseasons.common.core.map.ChunkInfoMap;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.map.SnowyRemover;
import com.teamtea.eclipticseasons.common.core.snow.SnowyMapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyStatusKeeper;
import com.teamtea.eclipticseasons.common.registry.AttachmentRegistry;
import net.caffeinemc.mods.sodium.client.world.cloned.ClonedChunkSection;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClonedChunkSection.class})
public abstract class MixinClonedChunkSection
implements ISnowyGetter {
    @Unique
    private SnowyRemover eclipticseasons$snowyRemover;
    @Unique
    private BiomeHolder eclipticseasons$biomeHolder;
    @Unique
    private Heightmap eclipticseasons$heightmap;
    @Unique
    private ChunkInfoMap eclipticseasons$chunkInfoMap;
    @Unique
    SnowyStatusKeeper eclipticseasons$snowyStatusKeeper;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void eclipticseasons$init(Level level, LevelChunk chunk, LevelChunkSection section, SectionPos pos, CallbackInfo ci) {
        this.eclipticseasons$snowyRemover = (SnowyRemover)chunk.getData(AttachmentRegistry.SNOWY_REMOVER);
        this.eclipticseasons$biomeHolder = (BiomeHolder)chunk.getData(AttachmentRegistry.BIOME_HOLDER);
        this.eclipticseasons$heightmap = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.MOTION_BLOCKING);
        this.eclipticseasons$chunkInfoMap = MapChecker.getChunkInfoMapOrCreate(level, chunk.getPos().getMiddleBlockPosition(64));
        this.eclipticseasons$snowyStatusKeeper = SnowyMapChecker.getSnowyStatusKeeperCopy(chunk);
    }

    @Override
    public SnowyRemover getSnowyRemover() {
        return this.eclipticseasons$snowyRemover;
    }

    @Override
    public BiomeHolder getBiomeHolder() {
        return this.eclipticseasons$biomeHolder;
    }

    @Override
    public Heightmap getSolidHeightMap() {
        return this.eclipticseasons$heightmap;
    }

    @Override
    public ChunkInfoMap getChunkInfoMap() {
        return this.eclipticseasons$chunkInfoMap;
    }

    @Override
    public SnowyStatusKeeper getSnowyStatusKeeper() {
        return this.eclipticseasons$snowyStatusKeeper;
    }
}

