/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.client.model.multipart;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.teamtea.eclipticseasons.api.data.client.model.multipart.AndConditionLike;
import com.teamtea.eclipticseasons.api.data.client.model.multipart.ConditionLike;
import com.teamtea.eclipticseasons.api.data.client.model.multipart.KeyValueConditionLike;
import com.teamtea.eclipticseasons.api.data.client.model.multipart.OrConditionLike;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ALlConditionLike {
    public static final Codec<ConditionLike> CODEC = CodecUtil.lazyInitialized(() -> ConditionCodecs.CONDITION_CODEC);
    private static final Codec<ConditionLike> KEY_VALUE_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).flatXmap(map -> {
        if (map.size() == 1) {
            Map.Entry entry = map.entrySet().iterator().next();
            return DataResult.success((Object)new KeyValueConditionLike((String)entry.getKey(), (String)entry.getValue()));
        }
        return DataResult.error(() -> "Simple KeyValueConditionLike must have exactly one entry");
    }, cond -> {
        if (cond instanceof KeyValueConditionLike) {
            KeyValueConditionLike kv = (KeyValueConditionLike)cond;
            return DataResult.success(Map.of(kv.key, kv.value));
        }
        return DataResult.error(() -> "Not a KeyValueCondition");
    });
    private static final Codec<OrConditionLike> OR_CODEC = CODEC.listOf().fieldOf("OR").xmap(OrConditionLike::new, OrConditionLike::getConditions).codec();
    private static final Codec<AndConditionLike> AND_CODEC_BASE = CODEC.listOf().fieldOf("AND").xmap(AndConditionLike::new, AndConditionLike::getConditions).codec();
    private static final Codec<AndConditionLike> AND_CODEC_FLAT = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).flatXmap(map -> {
        if (map.size() != 1) {
            List<KeyValueConditionLike> list = map.entrySet().stream().map(entry -> new KeyValueConditionLike((String)entry.getKey(), (String)entry.getValue())).toList();
            return DataResult.success((Object)new AndConditionLike(list));
        }
        return DataResult.error(() -> "Flat AndConditionLike must have more than one entry or none");
    }, andConditionLike -> {
        if (andConditionLike instanceof AndConditionLike && (andConditionLike.getConditions().isEmpty() || andConditionLike.getConditions().stream().allMatch(c -> c instanceof KeyValueConditionLike))) {
            return DataResult.success(andConditionLike.getConditions().stream().collect(Collectors.toMap(e -> ((KeyValueConditionLike)e).getKey(), e -> ((KeyValueConditionLike)e).getValue())));
        }
        return DataResult.error(() -> "Not a Flat AndConditionLike");
    });
    private static final Codec<AndConditionLike> AND_CODEC = Codec.either(AND_CODEC_FLAT, AND_CODEC_BASE).flatXmap(x -> {
        if (x.left().isPresent()) {
            return DataResult.success((Object)((AndConditionLike)x.left().get()));
        }
        if (x.right().isPresent()) {
            return DataResult.success((Object)((AndConditionLike)x.right().get()));
        }
        return DataResult.error(() -> "Fail to parse");
    }, andConditionLike -> {
        if (andConditionLike instanceof AndConditionLike) {
            if (andConditionLike.getConditions().stream().allMatch(c -> c instanceof KeyValueConditionLike)) {
                return DataResult.success((Object)Either.left((Object)andConditionLike));
            }
            return DataResult.success((Object)Either.right((Object)andConditionLike));
        }
        return DataResult.error(() -> "Not a AndConditionLike");
    });

    public static class ConditionCodecs {
        public static final Codec<ConditionLike> CONDITION_CODEC = Codec.either((Codec)Codec.either(AND_CODEC, OR_CODEC), KEY_VALUE_CODEC).flatXmap(either -> DataResult.success((Object)((ConditionLike)either.map(c -> c.left().isPresent() ? (ConditionLike)c.left().get() : (ConditionLike)c.right().get(), Function.identity()))), cond -> {
            if (cond instanceof AndConditionLike) {
                AndConditionLike and = (AndConditionLike)cond;
                return DataResult.success((Object)Either.left((Object)Either.left((Object)and)));
            }
            if (cond instanceof OrConditionLike) {
                OrConditionLike or = (OrConditionLike)cond;
                return DataResult.success((Object)Either.left((Object)Either.right((Object)or)));
            }
            if (cond instanceof KeyValueConditionLike) {
                KeyValueConditionLike kv = (KeyValueConditionLike)cond;
                return DataResult.success((Object)Either.right((Object)kv));
            }
            return DataResult.error(() -> "Unknown ConditionLike type: " + String.valueOf(cond));
        });
    }
}

