/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.client.model.seasonal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import com.teamtea.eclipticseasons.api.util.codec.ESExtraCodec;
import com.teamtea.eclipticseasons.api.util.fast.Enum2ObjectMap;
import com.teamtea.eclipticseasons.client.model.LocalSeasonStatusModel;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public class SeasonalTexture {
    public static final Codec<SeasonalTexture> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)CodecUtil.listFrom(ResourceLocation.f_135803_).optionalFieldOf("target", List.of()).forGetter(o -> o.parent), (App)CodecUtil.holderCodec(ESRegistries.AGRO_CLIMATE).optionalFieldOf("climate").forGetter(o -> o.climate), (App)Codec.either(CodecUtil.listFrom(ResourceLocation.f_135803_), (Codec)TagKey.m_203886_((ResourceKey)Registries.f_256952_)).optionalFieldOf("biomes").forGetter(o -> o.biomes), (App)Slice.CODEC.listOf().fieldOf("slices").forGetter(o -> o.slices)).apply((Applicative)ins, SeasonalTexture::new));
    private final List<ResourceLocation> parent;
    private final Optional<Holder<AgroClimaticZone>> climate;
    private final Optional<Either<List<ResourceLocation>, TagKey<Biome>>> biomes;
    private final List<Slice> slices;
    private Enum2ObjectMap<SolarTerm, FlatSliceHolder> flatSliceEnumMap = null;

    public boolean hasBuild() {
        return this.flatSliceEnumMap != null;
    }

    public SeasonalTexture build(ResourceLocation resourceLocation) {
        this.flatSliceEnumMap = new Enum2ObjectMap(SolarTerm.class);
        for (Slice slice : this.slices) {
            FlatSliceHolder otherHolder;
            SolarTerm end;
            SolarTerm start2;
            FlatSlice flatSlice = new FlatSlice(slice.textures.isEmpty() ? null : slice.textures, slice.tintMap, slice.transitionMaterials.isEmpty() ? null : slice.transitionMaterials);
            FlatSlice snowFlatSlice = new FlatSlice(slice.snowTextures.isEmpty() ? null : slice.snowTextures, slice.snowTintMap, slice.snowTransitionMaterials.isEmpty() ? null : slice.snowTransitionMaterials);
            AgroClimaticZone climate = this.getClimate().map(Holder::m_203334_).orElse(null);
            SolarTerm solarTerm = slice.start.isValid() ? slice.start : (slice.solarTerm.isValid() ? slice.solarTerm : (slice.season.isValid() ? slice.season.getFirstSolarTerm(climate) : (start2 = slice.startSeason.isValid() ? slice.endSeason.getFirstSolarTerm(climate) : null)));
            SolarTerm solarTerm2 = slice.end.isValid() ? slice.end : (slice.solarTerm.isValid() ? slice.solarTerm : (slice.season.isValid() ? slice.season.getEndSolarTerm(climate) : (end = slice.endSeason.isValid() ? slice.endSeason.getEndSolarTerm(climate) : null)));
            if (start2 == null && end == null) {
                start2 = SolarTerm.BEGINNING_OF_SPRING;
                end = SolarTerm.GREATER_COLD;
            }
            if (start2 == null || end == null || !start2.isValid() || !end.isValid()) continue;
            FlatSliceHolder firstSliceHolder = new FlatSliceHolder(start2, end, flatSlice, snowFlatSlice);
            if (start2 != end && (flatSlice.transitionModels != null || snowFlatSlice.transitionModels != null)) {
                firstSliceHolder = new FlatSliceHolder(start2, start2, flatSlice, snowFlatSlice);
                otherHolder = new FlatSliceHolder(start2.getNextSolarTerm(), end, new FlatSlice(flatSlice.transitionModels == null ? flatSlice.mid : flatSlice.transitionModels.stream().map(Pair::getSecond).toList(), flatSlice.tintMap, null), new FlatSlice(snowFlatSlice.transitionModels == null ? snowFlatSlice.mid : snowFlatSlice.transitionModels.stream().map(Pair::getSecond).toList(), flatSlice.tintMap, null));
            } else {
                otherHolder = firstSliceHolder;
            }
            for (SolarTerm solarTerm3 : SolarTerm.collectValues()) {
                if (start2 == solarTerm3) {
                    this.flatSliceEnumMap.put(start2, firstSliceHolder);
                    continue;
                }
                if (!solarTerm3.isInTerms(start2, end)) continue;
                this.flatSliceEnumMap.put(solarTerm3, otherHolder);
            }
        }
        return this;
    }

    @Generated
    public SeasonalTexture(List<ResourceLocation> parent, Optional<Holder<AgroClimaticZone>> climate, Optional<Either<List<ResourceLocation>, TagKey<Biome>>> biomes, List<Slice> slices) {
        this.parent = parent;
        this.climate = climate;
        this.biomes = biomes;
        this.slices = slices;
    }

    @Generated
    public List<ResourceLocation> getParent() {
        return this.parent;
    }

    @Generated
    public Optional<Holder<AgroClimaticZone>> getClimate() {
        return this.climate;
    }

    @Generated
    public Optional<Either<List<ResourceLocation>, TagKey<Biome>>> getBiomes() {
        return this.biomes;
    }

    @Generated
    public List<Slice> getSlices() {
        return this.slices;
    }

    @Generated
    public Enum2ObjectMap<SolarTerm, FlatSliceHolder> getFlatSliceEnumMap() {
        return this.flatSliceEnumMap;
    }

    @Generated
    public void setFlatSliceEnumMap(Enum2ObjectMap<SolarTerm, FlatSliceHolder> flatSliceEnumMap) {
        this.flatSliceEnumMap = flatSliceEnumMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeasonalTexture)) {
            return false;
        }
        SeasonalTexture other = (SeasonalTexture)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ResourceLocation> this$parent = this.getParent();
        List<ResourceLocation> other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        Optional<Holder<AgroClimaticZone>> this$climate = this.getClimate();
        Optional<Holder<AgroClimaticZone>> other$climate = other.getClimate();
        if (this$climate == null ? other$climate != null : !((Object)this$climate).equals(other$climate)) {
            return false;
        }
        Optional<Either<List<ResourceLocation>, TagKey<Biome>>> this$biomes = this.getBiomes();
        Optional<Either<List<ResourceLocation>, TagKey<Biome>>> other$biomes = other.getBiomes();
        if (this$biomes == null ? other$biomes != null : !((Object)this$biomes).equals(other$biomes)) {
            return false;
        }
        List<Slice> this$slices = this.getSlices();
        List<Slice> other$slices = other.getSlices();
        if (this$slices == null ? other$slices != null : !((Object)this$slices).equals(other$slices)) {
            return false;
        }
        Enum2ObjectMap<SolarTerm, FlatSliceHolder> this$flatSliceEnumMap = this.getFlatSliceEnumMap();
        Enum2ObjectMap<SolarTerm, FlatSliceHolder> other$flatSliceEnumMap = other.getFlatSliceEnumMap();
        return !(this$flatSliceEnumMap == null ? other$flatSliceEnumMap != null : !((Object)this$flatSliceEnumMap).equals(other$flatSliceEnumMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SeasonalTexture;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ResourceLocation> $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        Optional<Holder<AgroClimaticZone>> $climate = this.getClimate();
        result = result * 59 + ($climate == null ? 43 : ((Object)$climate).hashCode());
        Optional<Either<List<ResourceLocation>, TagKey<Biome>>> $biomes = this.getBiomes();
        result = result * 59 + ($biomes == null ? 43 : ((Object)$biomes).hashCode());
        List<Slice> $slices = this.getSlices();
        result = result * 59 + ($slices == null ? 43 : ((Object)$slices).hashCode());
        Enum2ObjectMap<SolarTerm, FlatSliceHolder> $flatSliceEnumMap = this.getFlatSliceEnumMap();
        result = result * 59 + ($flatSliceEnumMap == null ? 43 : $flatSliceEnumMap.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SeasonalTexture(parent=" + String.valueOf(this.getParent()) + ", climate=" + String.valueOf(this.getClimate()) + ", biomes=" + String.valueOf(this.getBiomes()) + ", slices=" + String.valueOf(this.getSlices()) + ", flatSliceEnumMap=" + String.valueOf(this.getFlatSliceEnumMap()) + ")";
    }

    public static class Slice {
        public static final Pair<ResourceLocation, ResourceLocation> EMPTY_PAIR = Pair.of((Object)LocalSeasonStatusModel.EMPTY, (Object)LocalSeasonStatusModel.EMPTY);
        public static final Codec<Map<String, ResourceLocation>> MATERIALS = CodecUtil.mapCodec(Codec.STRING, ResourceLocation.f_135803_);
        public static final Codec<Slice> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)ESExtraCodec.SOLAR_TERM.optionalFieldOf("start", (Object)SolarTerm.NONE).forGetter(o -> o.start), (App)ESExtraCodec.SOLAR_TERM.optionalFieldOf("end", (Object)SolarTerm.NONE).forGetter(o -> o.end), (App)ESExtraCodec.SOLAR_TERM.optionalFieldOf("solar_term", (Object)SolarTerm.NONE).forGetter(o -> o.solarTerm), (App)ESExtraCodec.SEASON.optionalFieldOf("start_season", (Object)Season.NONE).forGetter(o -> o.startSeason), (App)ESExtraCodec.SEASON.optionalFieldOf("end_season", (Object)Season.NONE).forGetter(o -> o.endSeason), (App)ESExtraCodec.SEASON.optionalFieldOf("season", (Object)Season.NONE).forGetter(o -> o.season), (App)CodecUtil.listFrom(MATERIALS).optionalFieldOf("textures", List.of()).forGetter(o -> o.textures), (App)CodecUtil.listFrom(MATERIALS.listOf().flatXmap(c -> {
            if (c.size() == 2) {
                return DataResult.success((Object)Pair.of((Object)((Map)c.get(0)), (Object)((Map)c.get(1))));
            }
            return DataResult.error(() -> "Unknown Size " + c.size());
        }, p -> DataResult.success(List.of((Map)p.getFirst(), (Map)p.getSecond())))).optionalFieldOf("transition_textures", List.of()).forGetter(o -> o.transitionMaterials), (App)CodecUtil.listFrom(MATERIALS).optionalFieldOf("snow_textures", List.of()).forGetter(o -> o.snowTextures), (App)CodecUtil.listFrom(MATERIALS.listOf().flatXmap(c -> {
            if (c.size() == 2) {
                return DataResult.success((Object)Pair.of((Object)((Map)c.get(0)), (Object)((Map)c.get(1))));
            }
            return DataResult.error(() -> "Unknown Size " + c.size());
        }, p -> DataResult.success(List.of((Map)p.getFirst(), (Map)p.getSecond())))).optionalFieldOf("snow_transition_textures", List.of()).forGetter(o -> o.snowTransitionMaterials), (App)CodecUtil.mapCodec(Codec.STRING, Codec.INT).optionalFieldOf("tint", Map.of()).forGetter(o -> o.tintMap), (App)CodecUtil.mapCodec(Codec.STRING, Codec.INT).optionalFieldOf("snow_tint", Map.of()).forGetter(o -> o.snowTintMap)).apply((Applicative)ins, Slice::new));
        private final SolarTerm start;
        private final SolarTerm end;
        private final SolarTerm solarTerm;
        private final Season startSeason;
        private final Season endSeason;
        private final Season season;
        private final List<Map<String, ResourceLocation>> textures;
        private final List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> transitionMaterials;
        private final List<Map<String, ResourceLocation>> snowTextures;
        private final List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> snowTransitionMaterials;
        private final Map<String, Integer> tintMap;
        private final Map<String, Integer> snowTintMap;

        @Generated
        private static SolarTerm $default$start() {
            return SolarTerm.NONE;
        }

        @Generated
        private static SolarTerm $default$end() {
            return SolarTerm.NONE;
        }

        @Generated
        private static SolarTerm $default$solarTerm() {
            return SolarTerm.NONE;
        }

        @Generated
        private static Season $default$startSeason() {
            return Season.NONE;
        }

        @Generated
        private static Season $default$endSeason() {
            return Season.NONE;
        }

        @Generated
        private static Season $default$season() {
            return Season.NONE;
        }

        @Generated
        private static List<Map<String, ResourceLocation>> $default$textures() {
            return List.of();
        }

        @Generated
        private static List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> $default$transitionMaterials() {
            return List.of();
        }

        @Generated
        private static List<Map<String, ResourceLocation>> $default$snowTextures() {
            return List.of();
        }

        @Generated
        private static List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> $default$snowTransitionMaterials() {
            return List.of();
        }

        @Generated
        private static Map<String, Integer> $default$tintMap() {
            return Map.of();
        }

        @Generated
        private static Map<String, Integer> $default$snowTintMap() {
            return Map.of();
        }

        @Generated
        Slice(SolarTerm start2, SolarTerm end, SolarTerm solarTerm, Season startSeason, Season endSeason, Season season, List<Map<String, ResourceLocation>> textures, List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> transitionMaterials, List<Map<String, ResourceLocation>> snowTextures, List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> snowTransitionMaterials, Map<String, Integer> tintMap, Map<String, Integer> snowTintMap) {
            this.start = start2;
            this.end = end;
            this.solarTerm = solarTerm;
            this.startSeason = startSeason;
            this.endSeason = endSeason;
            this.season = season;
            this.textures = textures;
            this.transitionMaterials = transitionMaterials;
            this.snowTextures = snowTextures;
            this.snowTransitionMaterials = snowTransitionMaterials;
            this.tintMap = tintMap;
            this.snowTintMap = snowTintMap;
        }

        @Generated
        public static SliceBuilder builder() {
            return new SliceBuilder();
        }

        @Generated
        public SolarTerm getStart() {
            return this.start;
        }

        @Generated
        public SolarTerm getEnd() {
            return this.end;
        }

        @Generated
        public SolarTerm getSolarTerm() {
            return this.solarTerm;
        }

        @Generated
        public Season getStartSeason() {
            return this.startSeason;
        }

        @Generated
        public Season getEndSeason() {
            return this.endSeason;
        }

        @Generated
        public Season getSeason() {
            return this.season;
        }

        @Generated
        public List<Map<String, ResourceLocation>> getTextures() {
            return this.textures;
        }

        @Generated
        public List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> getTransitionMaterials() {
            return this.transitionMaterials;
        }

        @Generated
        public List<Map<String, ResourceLocation>> getSnowTextures() {
            return this.snowTextures;
        }

        @Generated
        public List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> getSnowTransitionMaterials() {
            return this.snowTransitionMaterials;
        }

        @Generated
        public Map<String, Integer> getTintMap() {
            return this.tintMap;
        }

        @Generated
        public Map<String, Integer> getSnowTintMap() {
            return this.snowTintMap;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Slice)) {
                return false;
            }
            Slice other = (Slice)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SolarTerm this$start = this.getStart();
            SolarTerm other$start = other.getStart();
            if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
                return false;
            }
            SolarTerm this$end = this.getEnd();
            SolarTerm other$end = other.getEnd();
            if (this$end == null ? other$end != null : !this$end.equals(other$end)) {
                return false;
            }
            SolarTerm this$solarTerm = this.getSolarTerm();
            SolarTerm other$solarTerm = other.getSolarTerm();
            if (this$solarTerm == null ? other$solarTerm != null : !this$solarTerm.equals(other$solarTerm)) {
                return false;
            }
            Season this$startSeason = this.getStartSeason();
            Season other$startSeason = other.getStartSeason();
            if (this$startSeason == null ? other$startSeason != null : !this$startSeason.equals(other$startSeason)) {
                return false;
            }
            Season this$endSeason = this.getEndSeason();
            Season other$endSeason = other.getEndSeason();
            if (this$endSeason == null ? other$endSeason != null : !this$endSeason.equals(other$endSeason)) {
                return false;
            }
            Season this$season = this.getSeason();
            Season other$season = other.getSeason();
            if (this$season == null ? other$season != null : !this$season.equals(other$season)) {
                return false;
            }
            List<Map<String, ResourceLocation>> this$textures = this.getTextures();
            List<Map<String, ResourceLocation>> other$textures = other.getTextures();
            if (this$textures == null ? other$textures != null : !((Object)this$textures).equals(other$textures)) {
                return false;
            }
            List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> this$transitionMaterials = this.getTransitionMaterials();
            List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> other$transitionMaterials = other.getTransitionMaterials();
            if (this$transitionMaterials == null ? other$transitionMaterials != null : !((Object)this$transitionMaterials).equals(other$transitionMaterials)) {
                return false;
            }
            List<Map<String, ResourceLocation>> this$snowTextures = this.getSnowTextures();
            List<Map<String, ResourceLocation>> other$snowTextures = other.getSnowTextures();
            if (this$snowTextures == null ? other$snowTextures != null : !((Object)this$snowTextures).equals(other$snowTextures)) {
                return false;
            }
            List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> this$snowTransitionMaterials = this.getSnowTransitionMaterials();
            List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> other$snowTransitionMaterials = other.getSnowTransitionMaterials();
            if (this$snowTransitionMaterials == null ? other$snowTransitionMaterials != null : !((Object)this$snowTransitionMaterials).equals(other$snowTransitionMaterials)) {
                return false;
            }
            Map<String, Integer> this$tintMap = this.getTintMap();
            Map<String, Integer> other$tintMap = other.getTintMap();
            if (this$tintMap == null ? other$tintMap != null : !((Object)this$tintMap).equals(other$tintMap)) {
                return false;
            }
            Map<String, Integer> this$snowTintMap = this.getSnowTintMap();
            Map<String, Integer> other$snowTintMap = other.getSnowTintMap();
            return !(this$snowTintMap == null ? other$snowTintMap != null : !((Object)this$snowTintMap).equals(other$snowTintMap));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Slice;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SolarTerm $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : $start.hashCode());
            SolarTerm $end = this.getEnd();
            result = result * 59 + ($end == null ? 43 : $end.hashCode());
            SolarTerm $solarTerm = this.getSolarTerm();
            result = result * 59 + ($solarTerm == null ? 43 : $solarTerm.hashCode());
            Season $startSeason = this.getStartSeason();
            result = result * 59 + ($startSeason == null ? 43 : $startSeason.hashCode());
            Season $endSeason = this.getEndSeason();
            result = result * 59 + ($endSeason == null ? 43 : $endSeason.hashCode());
            Season $season = this.getSeason();
            result = result * 59 + ($season == null ? 43 : $season.hashCode());
            List<Map<String, ResourceLocation>> $textures = this.getTextures();
            result = result * 59 + ($textures == null ? 43 : ((Object)$textures).hashCode());
            List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> $transitionMaterials = this.getTransitionMaterials();
            result = result * 59 + ($transitionMaterials == null ? 43 : ((Object)$transitionMaterials).hashCode());
            List<Map<String, ResourceLocation>> $snowTextures = this.getSnowTextures();
            result = result * 59 + ($snowTextures == null ? 43 : ((Object)$snowTextures).hashCode());
            List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> $snowTransitionMaterials = this.getSnowTransitionMaterials();
            result = result * 59 + ($snowTransitionMaterials == null ? 43 : ((Object)$snowTransitionMaterials).hashCode());
            Map<String, Integer> $tintMap = this.getTintMap();
            result = result * 59 + ($tintMap == null ? 43 : ((Object)$tintMap).hashCode());
            Map<String, Integer> $snowTintMap = this.getSnowTintMap();
            result = result * 59 + ($snowTintMap == null ? 43 : ((Object)$snowTintMap).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SeasonalTexture.Slice(start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + ", solarTerm=" + String.valueOf(this.getSolarTerm()) + ", startSeason=" + String.valueOf(this.getStartSeason()) + ", endSeason=" + String.valueOf(this.getEndSeason()) + ", season=" + String.valueOf(this.getSeason()) + ", textures=" + String.valueOf(this.getTextures()) + ", transitionMaterials=" + String.valueOf(this.getTransitionMaterials()) + ", snowTextures=" + String.valueOf(this.getSnowTextures()) + ", snowTransitionMaterials=" + String.valueOf(this.getSnowTransitionMaterials()) + ", tintMap=" + String.valueOf(this.getTintMap()) + ", snowTintMap=" + String.valueOf(this.getSnowTintMap()) + ")";
        }

        @Generated
        public static class SliceBuilder {
            @Generated
            private boolean start$set;
            @Generated
            private SolarTerm start$value;
            @Generated
            private boolean end$set;
            @Generated
            private SolarTerm end$value;
            @Generated
            private boolean solarTerm$set;
            @Generated
            private SolarTerm solarTerm$value;
            @Generated
            private boolean startSeason$set;
            @Generated
            private Season startSeason$value;
            @Generated
            private boolean endSeason$set;
            @Generated
            private Season endSeason$value;
            @Generated
            private boolean season$set;
            @Generated
            private Season season$value;
            @Generated
            private boolean textures$set;
            @Generated
            private List<Map<String, ResourceLocation>> textures$value;
            @Generated
            private boolean transitionMaterials$set;
            @Generated
            private List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> transitionMaterials$value;
            @Generated
            private boolean snowTextures$set;
            @Generated
            private List<Map<String, ResourceLocation>> snowTextures$value;
            @Generated
            private boolean snowTransitionMaterials$set;
            @Generated
            private List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> snowTransitionMaterials$value;
            @Generated
            private boolean tintMap$set;
            @Generated
            private Map<String, Integer> tintMap$value;
            @Generated
            private boolean snowTintMap$set;
            @Generated
            private Map<String, Integer> snowTintMap$value;

            @Generated
            SliceBuilder() {
            }

            @Generated
            public SliceBuilder start(SolarTerm start2) {
                this.start$value = start2;
                this.start$set = true;
                return this;
            }

            @Generated
            public SliceBuilder end(SolarTerm end) {
                this.end$value = end;
                this.end$set = true;
                return this;
            }

            @Generated
            public SliceBuilder solarTerm(SolarTerm solarTerm) {
                this.solarTerm$value = solarTerm;
                this.solarTerm$set = true;
                return this;
            }

            @Generated
            public SliceBuilder startSeason(Season startSeason) {
                this.startSeason$value = startSeason;
                this.startSeason$set = true;
                return this;
            }

            @Generated
            public SliceBuilder endSeason(Season endSeason) {
                this.endSeason$value = endSeason;
                this.endSeason$set = true;
                return this;
            }

            @Generated
            public SliceBuilder season(Season season) {
                this.season$value = season;
                this.season$set = true;
                return this;
            }

            @Generated
            public SliceBuilder textures(List<Map<String, ResourceLocation>> textures) {
                this.textures$value = textures;
                this.textures$set = true;
                return this;
            }

            @Generated
            public SliceBuilder transitionMaterials(List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> transitionMaterials) {
                this.transitionMaterials$value = transitionMaterials;
                this.transitionMaterials$set = true;
                return this;
            }

            @Generated
            public SliceBuilder snowTextures(List<Map<String, ResourceLocation>> snowTextures) {
                this.snowTextures$value = snowTextures;
                this.snowTextures$set = true;
                return this;
            }

            @Generated
            public SliceBuilder snowTransitionMaterials(List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> snowTransitionMaterials) {
                this.snowTransitionMaterials$value = snowTransitionMaterials;
                this.snowTransitionMaterials$set = true;
                return this;
            }

            @Generated
            public SliceBuilder tintMap(Map<String, Integer> tintMap) {
                this.tintMap$value = tintMap;
                this.tintMap$set = true;
                return this;
            }

            @Generated
            public SliceBuilder snowTintMap(Map<String, Integer> snowTintMap) {
                this.snowTintMap$value = snowTintMap;
                this.snowTintMap$set = true;
                return this;
            }

            @Generated
            public Slice build() {
                SolarTerm start$value = this.start$value;
                if (!this.start$set) {
                    start$value = Slice.$default$start();
                }
                SolarTerm end$value = this.end$value;
                if (!this.end$set) {
                    end$value = Slice.$default$end();
                }
                SolarTerm solarTerm$value = this.solarTerm$value;
                if (!this.solarTerm$set) {
                    solarTerm$value = Slice.$default$solarTerm();
                }
                Season startSeason$value = this.startSeason$value;
                if (!this.startSeason$set) {
                    startSeason$value = Slice.$default$startSeason();
                }
                Season endSeason$value = this.endSeason$value;
                if (!this.endSeason$set) {
                    endSeason$value = Slice.$default$endSeason();
                }
                Season season$value = this.season$value;
                if (!this.season$set) {
                    season$value = Slice.$default$season();
                }
                List<Map<String, ResourceLocation>> textures$value = this.textures$value;
                if (!this.textures$set) {
                    textures$value = Slice.$default$textures();
                }
                List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> transitionMaterials$value = this.transitionMaterials$value;
                if (!this.transitionMaterials$set) {
                    transitionMaterials$value = Slice.$default$transitionMaterials();
                }
                List<Map<String, ResourceLocation>> snowTextures$value = this.snowTextures$value;
                if (!this.snowTextures$set) {
                    snowTextures$value = Slice.$default$snowTextures();
                }
                List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> snowTransitionMaterials$value = this.snowTransitionMaterials$value;
                if (!this.snowTransitionMaterials$set) {
                    snowTransitionMaterials$value = Slice.$default$snowTransitionMaterials();
                }
                Map<String, Integer> tintMap$value = this.tintMap$value;
                if (!this.tintMap$set) {
                    tintMap$value = Slice.$default$tintMap();
                }
                Map<String, Integer> snowTintMap$value = this.snowTintMap$value;
                if (!this.snowTintMap$set) {
                    snowTintMap$value = Slice.$default$snowTintMap();
                }
                return new Slice(start$value, end$value, solarTerm$value, startSeason$value, endSeason$value, season$value, textures$value, transitionMaterials$value, snowTextures$value, snowTransitionMaterials$value, tintMap$value, snowTintMap$value);
            }

            @Generated
            public String toString() {
                return "SeasonalTexture.Slice.SliceBuilder(start$value=" + String.valueOf(this.start$value) + ", end$value=" + String.valueOf(this.end$value) + ", solarTerm$value=" + String.valueOf(this.solarTerm$value) + ", startSeason$value=" + String.valueOf(this.startSeason$value) + ", endSeason$value=" + String.valueOf(this.endSeason$value) + ", season$value=" + String.valueOf(this.season$value) + ", textures$value=" + String.valueOf(this.textures$value) + ", transitionMaterials$value=" + String.valueOf(this.transitionMaterials$value) + ", snowTextures$value=" + String.valueOf(this.snowTextures$value) + ", snowTransitionMaterials$value=" + String.valueOf(this.snowTransitionMaterials$value) + ", tintMap$value=" + String.valueOf(this.tintMap$value) + ", snowTintMap$value=" + String.valueOf(this.snowTintMap$value) + ")";
            }
        }
    }

    public record FlatSlice(@Nullable List<Map<String, ResourceLocation>> mid, Map<String, Integer> tintMap, @Nullable List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> transitionModels) {
    }

    public record FlatSliceHolder(SolarTerm start, SolarTerm end, FlatSlice flatSlice, FlatSlice snowSlice) {
    }
}

