/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.crop;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.world.level.block.state.BlockState;

public record GrowParameter(float grow_chance, float death_chance, float fertile_chance, Optional<BlockState> deadState) {
    public static final Codec<GrowParameter> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)Codec.FLOAT.optionalFieldOf("grow_chance", (Object)Float.valueOf(1.0f)).forGetter(GrowParameter::grow_chance), (App)Codec.FLOAT.optionalFieldOf("death_chance", (Object)Float.valueOf(0.0f)).forGetter(GrowParameter::death_chance), (App)Codec.FLOAT.optionalFieldOf("fertile_chance", (Object)Float.valueOf(1.0f)).forGetter(GrowParameter::fertile_chance), (App)BlockState.f_61039_.optionalFieldOf("dead_state").forGetter(GrowParameter::deadState)).apply((Applicative)ins, GrowParameter::new));

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private float growChance = 1.0f;
        private float deathChance = 0.0f;
        private float fertileChance = 1.0f;
        private Optional<BlockState> deadState = Optional.empty();

        public Builder growChance(float growChance) {
            this.growChance = growChance;
            return this;
        }

        public Builder deathChance(float deathChance) {
            this.deathChance = deathChance;
            return this;
        }

        public Builder fertileChance(float fertileChance) {
            this.fertileChance = fertileChance;
            return this;
        }

        public Builder deadState(BlockState state) {
            this.deadState = Optional.ofNullable(state);
            return this;
        }

        public Builder deadState(Optional<BlockState> deadState) {
            this.deadState = deadState;
            return this;
        }

        public GrowParameter end() {
            return new GrowParameter(this.growChance, this.deathChance, this.fertileChance, this.deadState);
        }
    }
}

