/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public record ESSortInfo(ResourceLocation registry, List<ResourceLocation> target, int priority, boolean remove) {
    public static final Codec<ESSortInfo> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)ResourceLocation.f_135803_.fieldOf("registry").forGetter(ESSortInfo::registry), (App)CodecUtil.listFrom(ResourceLocation.f_135803_).fieldOf("target").forGetter(ESSortInfo::target), (App)Codec.INT.optionalFieldOf("priority", (Object)1000).forGetter(ESSortInfo::priority), (App)Codec.BOOL.optionalFieldOf("remove", (Object)false).forGetter(ESSortInfo::remove)).apply((Applicative)ins, ESSortInfo::new));
    private static final Map<ResourceLocation, List<ResourceLocation>> REMOVE_MAP = new HashMap<ResourceLocation, List<ResourceLocation>>();
    private static final Map<ResourceLocation, Map<ResourceLocation, Integer>> PRIORITY_MAP = new HashMap<ResourceLocation, Map<ResourceLocation, Integer>>();
    public static boolean hasUpdated = false;

    public static void resetUpdate(RegistryAccess registryAccess, boolean isServer) {
        if (hasUpdated) {
            return;
        }
        Optional registry1 = registryAccess.m_6632_(ESRegistries.EXTRA_INFO);
        if (registry1.isEmpty()) {
            return;
        }
        for (ESSortInfo esDataSorted : (Registry)registry1.get()) {
            Object resourceLocations;
            if (esDataSorted.remove()) {
                resourceLocations = REMOVE_MAP.computeIfAbsent(esDataSorted.registry, cc -> new ArrayList());
                resourceLocations.addAll(esDataSorted.target());
                continue;
            }
            resourceLocations = PRIORITY_MAP.computeIfAbsent(esDataSorted.registry, cc -> new HashMap());
            for (ResourceLocation holder : esDataSorted.target()) {
                resourceLocations.put(holder, esDataSorted.priority());
            }
        }
        hasUpdated = true;
    }

    public static void clearOnClientExitOrServerClose() {
        REMOVE_MAP.clear();
        PRIORITY_MAP.clear();
        hasUpdated = false;
    }

    public static <T> Set<Map.Entry<ResourceKey<T>, T>> sorted(Set<Map.Entry<ResourceKey<T>, T>> original) {
        if (original.isEmpty()) {
            return original;
        }
        Map.Entry resourceKeyTEntry = (Map.Entry)original.stream().findFirst().get();
        ResourceLocation registry1 = ((ResourceKey)resourceKeyTEntry.getKey()).m_211136_();
        Map priorityMap = PRIORITY_MAP.getOrDefault(registry1, Map.of());
        List removemap2 = REMOVE_MAP.getOrDefault(registry1, List.of());
        if (priorityMap.isEmpty() && removemap2.isEmpty()) {
            return original;
        }
        HashMap<ResourceLocation, Map.Entry<ResourceKey<T>, T>> oldMap = new HashMap<ResourceLocation, Map.Entry<ResourceKey<T>, T>>();
        for (Map.Entry<ResourceKey<T>, T> e : original) {
            if (removemap2.contains(e.getKey().m_135782_())) continue;
            oldMap.put(e.getKey().m_135782_(), e);
        }
        return oldMap.entrySet().stream().sorted(Comparator.comparingInt(a -> priorityMap.getOrDefault(a.getKey(), 1000))).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    public static <T> List<Holder.Reference<T>> sorted(List<Holder.Reference<T>> original) {
        if (original.isEmpty()) {
            return original;
        }
        Holder.Reference<T> resourceKeyTEntry = original.get(0);
        ResourceLocation registry1 = resourceKeyTEntry.m_205785_().m_211136_();
        Map priorityMap = PRIORITY_MAP.getOrDefault(registry1, Map.of());
        List removemap2 = REMOVE_MAP.getOrDefault(registry1, List.of());
        if (priorityMap.isEmpty() && removemap2.isEmpty()) {
            return original;
        }
        original = new ArrayList<Holder.Reference<T>>(original);
        original.removeIf(e -> removemap2.contains(e.m_205785_().m_135782_()));
        original.sort(Comparator.comparingInt(a -> priorityMap.getOrDefault(a.m_205785_().m_135782_(), 1000)));
        return original;
    }

    public static <T> List<T> sorted2(Registry<T> registry) {
        List<Holder.Reference<T>> list = registry.m_203611_().toList();
        return ESSortInfo.sorted(list).stream().map(Holder::m_203334_).toList();
    }
}

