/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.season.definition.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.data.season.definition.ISeasonChangeContext;
import com.teamtea.eclipticseasons.api.data.season.definition.condition.ChangeConditions;
import com.teamtea.eclipticseasons.api.data.season.definition.condition.IChangeCondition;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;

public class PrecipitationCondition
implements IChangeCondition {
    public static final MapCodec<PrecipitationCondition> CODEC = RecordCodecBuilder.mapCodec(ins -> ins.group((App)WarpPrecipitation.CODEC.fieldOf("rain").forGetter(c -> WarpPrecipitation.from(c.precipitation))).apply((Applicative)ins, precipitation1 -> new PrecipitationCondition(precipitation1.to())));
    private final Biome.Precipitation precipitation;

    @Override
    public ResourceLocation getType() {
        return ChangeConditions.PRECIPITATION;
    }

    @Override
    public boolean test(Level level, BlockPos pos, ISeasonChangeContext context) {
        return EclipticSeasonsApi.getInstance().getCurrentPrecipitationAt(level, pos) == this.precipitation;
    }

    @Override
    public MapCodec<? extends IChangeCondition> codec() {
        return CODEC;
    }

    @Generated
    PrecipitationCondition(Biome.Precipitation precipitation) {
        this.precipitation = precipitation;
    }

    @Generated
    public static PrecipitationConditionBuilder builder() {
        return new PrecipitationConditionBuilder();
    }

    @Generated
    public Biome.Precipitation getPrecipitation() {
        return this.precipitation;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrecipitationCondition)) {
            return false;
        }
        PrecipitationCondition other = (PrecipitationCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Biome.Precipitation this$precipitation = this.getPrecipitation();
        Biome.Precipitation other$precipitation = other.getPrecipitation();
        return !(this$precipitation == null ? other$precipitation != null : !this$precipitation.equals(other$precipitation));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PrecipitationCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Biome.Precipitation $precipitation = this.getPrecipitation();
        result = result * 59 + ($precipitation == null ? 43 : $precipitation.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PrecipitationCondition(precipitation=" + String.valueOf(this.getPrecipitation()) + ")";
    }

    @Generated
    public static class PrecipitationConditionBuilder {
        @Generated
        private Biome.Precipitation precipitation;

        @Generated
        PrecipitationConditionBuilder() {
        }

        @Generated
        public PrecipitationConditionBuilder precipitation(Biome.Precipitation precipitation) {
            this.precipitation = precipitation;
            return this;
        }

        @Generated
        public PrecipitationCondition build() {
            return new PrecipitationCondition(this.precipitation);
        }

        @Generated
        public String toString() {
            return "PrecipitationCondition.PrecipitationConditionBuilder(precipitation=" + String.valueOf(this.precipitation) + ")";
        }
    }

    public static enum WarpPrecipitation implements StringRepresentable
    {
        NONE("none"),
        RAIN("rain"),
        SNOW("snow");

        public static final Codec<WarpPrecipitation> CODEC;
        private final String name;

        private WarpPrecipitation(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public static WarpPrecipitation from(Biome.Precipitation bp) {
            return WarpPrecipitation.valueOf(bp.toString());
        }

        public Biome.Precipitation to() {
            return Biome.Precipitation.valueOf((String)this.toString());
        }

        static {
            CODEC = StringRepresentable.m_216439_(WarpPrecipitation::values);
        }
    }
}

