/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.season.definition.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.constant.solar.TimePeriod;
import com.teamtea.eclipticseasons.api.data.season.definition.ISeasonChangeContext;
import com.teamtea.eclipticseasons.api.data.season.definition.condition.ChangeConditions;
import com.teamtea.eclipticseasons.api.data.season.definition.condition.IChangeCondition;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import com.teamtea.eclipticseasons.api.util.codec.ESExtraCodec;
import java.util.ArrayList;
import java.util.HashSet;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class TimePeriodCondition
implements IChangeCondition {
    public static final MapCodec<TimePeriodCondition> CODEC = RecordCodecBuilder.mapCodec(ins -> ins.group((App)CodecUtil.listFrom(ESExtraCodec.TIME_PERIOD).xmap(HashSet::new, ArrayList::new).fieldOf("periods").forGetter(o -> o.periods)).apply((Applicative)ins, TimePeriodCondition::new));
    private final HashSet<TimePeriod> periods;

    @Override
    public ResourceLocation getType() {
        return ChangeConditions.TIME_PERIOD;
    }

    @Override
    public boolean test(Level level, BlockPos pos, ISeasonChangeContext context) {
        TimePeriod timePeriod = TimePeriod.fromTimeOfDay(level.m_46942_(1.0f));
        return this.periods.contains(timePeriod);
    }

    @Override
    public MapCodec<? extends IChangeCondition> codec() {
        return CODEC;
    }

    @Generated
    TimePeriodCondition(HashSet<TimePeriod> periods) {
        this.periods = periods;
    }

    @Generated
    public static TimePeriodConditionBuilder builder() {
        return new TimePeriodConditionBuilder();
    }

    @Generated
    public HashSet<TimePeriod> getPeriods() {
        return this.periods;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimePeriodCondition)) {
            return false;
        }
        TimePeriodCondition other = (TimePeriodCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HashSet<TimePeriod> this$periods = this.getPeriods();
        HashSet<TimePeriod> other$periods = other.getPeriods();
        return !(this$periods == null ? other$periods != null : !((Object)this$periods).equals(other$periods));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimePeriodCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HashSet<TimePeriod> $periods = this.getPeriods();
        result = result * 59 + ($periods == null ? 43 : ((Object)$periods).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimePeriodCondition(periods=" + String.valueOf(this.getPeriods()) + ")";
    }

    @Generated
    public static class TimePeriodConditionBuilder {
        @Generated
        private HashSet<TimePeriod> periods;

        @Generated
        TimePeriodConditionBuilder() {
        }

        @Generated
        public TimePeriodConditionBuilder periods(HashSet<TimePeriod> periods) {
            this.periods = periods;
            return this;
        }

        @Generated
        public TimePeriodCondition build() {
            return new TimePeriodCondition(this.periods);
        }

        @Generated
        public String toString() {
            return "TimePeriodCondition.TimePeriodConditionBuilder(periods=" + String.valueOf(this.periods) + ")";
        }
    }
}

