/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.season.definition.selector;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.data.season.definition.ISeasonChangeContext;
import com.teamtea.eclipticseasons.api.data.season.definition.condition.IChangeCondition;
import com.teamtea.eclipticseasons.api.data.season.definition.selector.ChangeSelectors;
import com.teamtea.eclipticseasons.api.data.season.definition.selector.IChangeSelector;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import com.teamtea.eclipticseasons.common.core.crop.NaturalPlantHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;

public class MultiBlockSelector
implements IChangeSelector {
    public static final MapCodec<MultiBlockSelector> CODEC = RecordCodecBuilder.mapCodec(ins -> ins.group((App)Part.CODEC.listOf().fieldOf("parts").forGetter(o -> o.multiBlocks), (App)Codec.INT.optionalFieldOf("weight", (Object)10).forGetter(o -> o.weight), (App)CodecUtil.listFrom(IChangeCondition.CODEC).optionalFieldOf("conditions", List.of()).forGetter(o -> o.conditions), (App)Vec3i.f_123287_.optionalFieldOf("offset").forGetter(o -> o.offset), (App)ResourceLocation.f_135803_.optionalFieldOf("loot").forGetter(o -> o.loot)).apply((Applicative)ins, MultiBlockSelector::new));
    private final List<Part> multiBlocks;
    private final int weight;
    private final List<IChangeCondition> conditions;
    private final Optional<Vec3i> offset;
    private final Optional<ResourceLocation> loot;

    @Override
    public ResourceLocation getType() {
        return ChangeSelectors.MULTI_BLOCKS;
    }

    @Override
    public MapCodec<? extends IChangeSelector> codec() {
        return CODEC;
    }

    @Override
    public boolean place(ServerLevel level, BlockPos pos, ISeasonChangeContext context) {
        List<Part> get = this.multiBlocks;
        int count = 0;
        int getSize = get.size();
        for (int j = 0; j < getSize; ++j) {
            Part part = get.get(j);
            BlockState newState = part.state;
            BlockPos newpos = part.offset.map(arg_0 -> ((BlockPos)pos).m_121955_(arg_0)).orElse(pos);
            if (part.replace.isEmpty()) {
                BlockState oldState = level.m_8055_(newpos);
                if (!oldState.m_60722_(Fluids.f_76191_)) continue;
                boolean set = NaturalPlantHandler.setBlockAndSelfCheck(level, newpos, newState, oldState);
                count += set ? 1 : 0;
                continue;
            }
            if (!part.replace.get().booleanValue() && !level.m_46859_(newpos)) continue;
            boolean set = NaturalPlantHandler.setBlockAndSelfCheck(level, newpos, newState);
            count += set ? 1 : 0;
        }
        return count > 0;
    }

    @Generated
    private static int $default$weight() {
        return 10;
    }

    @Generated
    private static Optional<Vec3i> $default$offset() {
        return Optional.empty();
    }

    @Generated
    private static Optional<ResourceLocation> $default$loot() {
        return Optional.empty();
    }

    @Generated
    MultiBlockSelector(List<Part> multiBlocks, int weight, List<IChangeCondition> conditions, Optional<Vec3i> offset, Optional<ResourceLocation> loot) {
        this.multiBlocks = multiBlocks;
        this.weight = weight;
        this.conditions = conditions;
        this.offset = offset;
        this.loot = loot;
    }

    @Generated
    public static MultiBlockSelectorBuilder builder() {
        return new MultiBlockSelectorBuilder();
    }

    @Generated
    public List<Part> getMultiBlocks() {
        return this.multiBlocks;
    }

    @Override
    @Generated
    public int getWeight() {
        return this.weight;
    }

    @Override
    @Generated
    public List<IChangeCondition> getConditions() {
        return this.conditions;
    }

    @Generated
    public Optional<Vec3i> getOffset() {
        return this.offset;
    }

    @Override
    @Generated
    public Optional<ResourceLocation> getLoot() {
        return this.loot;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiBlockSelector)) {
            return false;
        }
        MultiBlockSelector other = (MultiBlockSelector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWeight() != other.getWeight()) {
            return false;
        }
        List<Part> this$multiBlocks = this.getMultiBlocks();
        List<Part> other$multiBlocks = other.getMultiBlocks();
        if (this$multiBlocks == null ? other$multiBlocks != null : !((Object)this$multiBlocks).equals(other$multiBlocks)) {
            return false;
        }
        List<IChangeCondition> this$conditions = this.getConditions();
        List<IChangeCondition> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        Optional<Vec3i> this$offset = this.getOffset();
        Optional<Vec3i> other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Optional<ResourceLocation> this$loot = this.getLoot();
        Optional<ResourceLocation> other$loot = other.getLoot();
        return !(this$loot == null ? other$loot != null : !((Object)this$loot).equals(other$loot));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MultiBlockSelector;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWeight();
        List<Part> $multiBlocks = this.getMultiBlocks();
        result = result * 59 + ($multiBlocks == null ? 43 : ((Object)$multiBlocks).hashCode());
        List<IChangeCondition> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        Optional<Vec3i> $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Optional<ResourceLocation> $loot = this.getLoot();
        result = result * 59 + ($loot == null ? 43 : ((Object)$loot).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MultiBlockSelector(multiBlocks=" + String.valueOf(this.getMultiBlocks()) + ", weight=" + this.getWeight() + ", conditions=" + String.valueOf(this.getConditions()) + ", offset=" + String.valueOf(this.getOffset()) + ", loot=" + String.valueOf(this.getLoot()) + ")";
    }

    public static final class Part {
        public static final Codec<Part> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)BlockState.f_61039_.fieldOf("block").forGetter(o -> o.state), (App)Vec3i.f_123287_.optionalFieldOf("offset").forGetter(o -> o.offset), (App)Codec.BOOL.optionalFieldOf("replace").forGetter(o -> o.replace)).apply((Applicative)ins, Part::new));
        private final BlockState state;
        private final Optional<Vec3i> offset;
        private final Optional<Boolean> replace;

        @Generated
        private static Optional<Vec3i> $default$offset() {
            return Optional.empty();
        }

        @Generated
        private static Optional<Boolean> $default$replace() {
            return Optional.empty();
        }

        @Generated
        Part(BlockState state, Optional<Vec3i> offset, Optional<Boolean> replace) {
            this.state = state;
            this.offset = offset;
            this.replace = replace;
        }

        @Generated
        public static PartBuilder builder() {
            return new PartBuilder();
        }

        @Generated
        public BlockState getState() {
            return this.state;
        }

        @Generated
        public Optional<Vec3i> getOffset() {
            return this.offset;
        }

        @Generated
        public Optional<Boolean> getReplace() {
            return this.replace;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Part)) {
                return false;
            }
            Part other = (Part)o;
            BlockState this$state = this.getState();
            BlockState other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            Optional<Vec3i> this$offset = this.getOffset();
            Optional<Vec3i> other$offset = other.getOffset();
            if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
                return false;
            }
            Optional<Boolean> this$replace = this.getReplace();
            Optional<Boolean> other$replace = other.getReplace();
            return !(this$replace == null ? other$replace != null : !((Object)this$replace).equals(other$replace));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BlockState $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            Optional<Vec3i> $offset = this.getOffset();
            result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
            Optional<Boolean> $replace = this.getReplace();
            result = result * 59 + ($replace == null ? 43 : ((Object)$replace).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MultiBlockSelector.Part(state=" + String.valueOf(this.getState()) + ", offset=" + String.valueOf(this.getOffset()) + ", replace=" + String.valueOf(this.getReplace()) + ")";
        }

        @Generated
        public static class PartBuilder {
            @Generated
            private BlockState state;
            @Generated
            private boolean offset$set;
            @Generated
            private Optional<Vec3i> offset$value;
            @Generated
            private boolean replace$set;
            @Generated
            private Optional<Boolean> replace$value;

            @Generated
            PartBuilder() {
            }

            @Generated
            public PartBuilder state(BlockState state) {
                this.state = state;
                return this;
            }

            @Generated
            public PartBuilder offset(Optional<Vec3i> offset) {
                this.offset$value = offset;
                this.offset$set = true;
                return this;
            }

            @Generated
            public PartBuilder replace(Optional<Boolean> replace) {
                this.replace$value = replace;
                this.replace$set = true;
                return this;
            }

            @Generated
            public Part build() {
                Optional<Vec3i> offset$value = this.offset$value;
                if (!this.offset$set) {
                    offset$value = Part.$default$offset();
                }
                Optional<Boolean> replace$value = this.replace$value;
                if (!this.replace$set) {
                    replace$value = Part.$default$replace();
                }
                return new Part(this.state, offset$value, replace$value);
            }

            @Generated
            public String toString() {
                return "MultiBlockSelector.Part.PartBuilder(state=" + String.valueOf(this.state) + ", offset$value=" + String.valueOf(this.offset$value) + ", replace$value=" + String.valueOf(this.replace$value) + ")";
            }
        }
    }

    @Generated
    public static class MultiBlockSelectorBuilder {
        @Generated
        private ArrayList<Part> multiBlocks;
        @Generated
        private boolean weight$set;
        @Generated
        private int weight$value;
        @Generated
        private ArrayList<IChangeCondition> conditions;
        @Generated
        private boolean offset$set;
        @Generated
        private Optional<Vec3i> offset$value;
        @Generated
        private boolean loot$set;
        @Generated
        private Optional<ResourceLocation> loot$value;

        @Generated
        MultiBlockSelectorBuilder() {
        }

        @Generated
        public MultiBlockSelectorBuilder multiBlock(Part multiBlock) {
            if (this.multiBlocks == null) {
                this.multiBlocks = new ArrayList();
            }
            this.multiBlocks.add(multiBlock);
            return this;
        }

        @Generated
        public MultiBlockSelectorBuilder multiBlocks(Collection<? extends Part> multiBlocks) {
            if (multiBlocks == null) {
                throw new NullPointerException("multiBlocks cannot be null");
            }
            if (this.multiBlocks == null) {
                this.multiBlocks = new ArrayList();
            }
            this.multiBlocks.addAll(multiBlocks);
            return this;
        }

        @Generated
        public MultiBlockSelectorBuilder clearMultiBlocks() {
            if (this.multiBlocks != null) {
                this.multiBlocks.clear();
            }
            return this;
        }

        @Generated
        public MultiBlockSelectorBuilder weight(int weight) {
            this.weight$value = weight;
            this.weight$set = true;
            return this;
        }

        @Generated
        public MultiBlockSelectorBuilder condition(IChangeCondition condition) {
            if (this.conditions == null) {
                this.conditions = new ArrayList();
            }
            this.conditions.add(condition);
            return this;
        }

        @Generated
        public MultiBlockSelectorBuilder conditions(Collection<? extends IChangeCondition> conditions) {
            if (conditions == null) {
                throw new NullPointerException("conditions cannot be null");
            }
            if (this.conditions == null) {
                this.conditions = new ArrayList();
            }
            this.conditions.addAll(conditions);
            return this;
        }

        @Generated
        public MultiBlockSelectorBuilder clearConditions() {
            if (this.conditions != null) {
                this.conditions.clear();
            }
            return this;
        }

        @Generated
        public MultiBlockSelectorBuilder offset(Optional<Vec3i> offset) {
            this.offset$value = offset;
            this.offset$set = true;
            return this;
        }

        @Generated
        public MultiBlockSelectorBuilder loot(Optional<ResourceLocation> loot) {
            this.loot$value = loot;
            this.loot$set = true;
            return this;
        }

        @Generated
        public MultiBlockSelector build() {
            List<Part> multiBlocks = switch (this.multiBlocks == null ? 0 : this.multiBlocks.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.multiBlocks.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Part>(this.multiBlocks));
            };
            List<IChangeCondition> conditions = switch (this.conditions == null ? 0 : this.conditions.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.conditions.get(0));
                default -> Collections.unmodifiableList(new ArrayList<IChangeCondition>(this.conditions));
            };
            int weight$value = this.weight$value;
            if (!this.weight$set) {
                weight$value = MultiBlockSelector.$default$weight();
            }
            Optional<Vec3i> offset$value = this.offset$value;
            if (!this.offset$set) {
                offset$value = MultiBlockSelector.$default$offset();
            }
            Optional<ResourceLocation> loot$value = this.loot$value;
            if (!this.loot$set) {
                loot$value = MultiBlockSelector.$default$loot();
            }
            return new MultiBlockSelector(multiBlocks, weight$value, conditions, offset$value, loot$value);
        }

        @Generated
        public String toString() {
            return "MultiBlockSelector.MultiBlockSelectorBuilder(multiBlocks=" + String.valueOf(this.multiBlocks) + ", weight$value=" + this.weight$value + ", conditions=" + String.valueOf(this.conditions) + ", offset$value=" + String.valueOf(this.offset$value) + ", loot$value=" + String.valueOf(this.loot$value) + ")";
        }
    }
}

