/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.util;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.solar.ISolarTerm;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.core.biome.BiomeClimateManager;
import com.teamtea.eclipticseasons.common.core.solar.SolarTermHelper;
import com.teamtea.eclipticseasons.common.core.solar.SolarTermHumidityChart;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.server.ServerLifecycleHooks;

public class SimpleUtil {
    public static void testTime(Runnable runnable) {
        long time = System.currentTimeMillis();
        for (int i = 0; i < 10000000; ++i) {
            runnable.run();
        }
        EclipticSeasons.logger(System.currentTimeMillis() - time);
    }

    public static String getModUse(int offset) {
        try {
            return Optional.of(Class.forName(Thread.currentThread().getStackTrace()[offset].getClassName())).map(Class::getProtectionDomain).map(ProtectionDomain::getCodeSource).map(CodeSource::getLocation).map(URL::getFile).map(it -> new File(it.split("%23")[0]).getAbsolutePath()).map(i -> FMLLoader.getLoadingModList().getModFiles().stream().filter(modFileInfo -> new File(modFileInfo.getFile().getFilePath().toString()).getAbsolutePath().equals(i)).findFirst().get()).map(modFileInfo -> modFileInfo.getFile().getModFileInfo().moduleName()).get();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static List<String> getModsUse(int offset) {
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 2; i < 15; ++i) {
            strings.add(SimpleUtil.getModUse(i));
        }
        return new ArrayList<String>(new HashSet(strings));
    }

    public static <E> void warningForModWrongCalling(ResourceKey<? extends Registry<? extends E>> registryKey) {
        SimpleUtil.warningForModWrongCalling("Warning for call " + String.valueOf(registryKey) + " at wrong time.");
    }

    public static void warningForModWrongCalling(String message) {
        HashSet<String> strings = new HashSet<String>(SimpleUtil.getModsUse(0));
        strings.removeIf(s -> s.equals("eclipticseasons"));
        strings.removeIf(s -> s.equals("neoforge"));
        strings.removeIf(s -> s.equals("minecraft"));
        strings.removeIf(String::isEmpty);
        EclipticSeasons.logger(message);
        EclipticSeasons.logger("Suspected mod: " + String.join((CharSequence)",", strings));
    }

    public static MutableComponent addSolarIconBefore(SolarTerm solarTerm, MutableComponent mutableComponent) {
        Style noBitstyle = mutableComponent.m_7383_().m_131150_(mutableComponent.m_7383_().m_131192_());
        return Component.m_237113_((String)solarTerm.getFontLabel()).m_130948_(Style.f_131099_.m_131150_(SolarTerm.getFont())).m_7220_((Component)Component.m_237113_((String)" ").m_130948_(noBitstyle).m_7220_((Component)mutableComponent));
    }

    public static MutableComponent addSolarIconBefore(ISolarTerm solarTerm, MutableComponent mutableComponent) {
        Style aDefault = Style.f_131099_.m_131150_(new ResourceLocation("default"));
        Style style = Style.f_131099_.m_131150_(solarTerm.getIconFont());
        return Component.m_237113_((String)solarTerm.getFontLabel()).m_130948_(style.m_131148_(TextColor.m_131266_((int)-1))).m_7220_((Component)Component.m_237113_((String)" ").m_130948_(aDefault).m_7220_((Component)mutableComponent));
    }

    public static MutableComponent getSolarTermMessage(SolarTerm solarTerm) {
        return Component.m_237119_().m_7220_((Component)Component.m_237110_((String)"info.eclipticseasons.environment.solar_term.message", (Object[])new Object[]{(Boolean)CommonConfig.Season.enableInformIcon.get() != false ? SimpleUtil.addSolarIconBefore(solarTerm, solarTerm.getAlternationText()) : solarTerm.getAlternationText()}));
    }

    public static void sendSolarTermMessage(ServerPlayer player, SolarTerm solarTerm, boolean ignoreChangeCheck) {
        ISolarTerm iSolarTerm = SolarTermHelper.isChangedAndGet(player.m_9236_(), player.m_20183_(), solarTerm, solarTerm.getLastSolarTerm(), ignoreChangeCheck);
        if (iSolarTerm != null) {
            MutableComponent translatable = Component.m_237110_((String)"info.eclipticseasons.environment.solar_term.message", (Object[])new Object[]{(Boolean)CommonConfig.Season.enableInformIcon.get() != false ? SimpleUtil.addSolarIconBefore(iSolarTerm, iSolarTerm.getAlternationText()) : solarTerm.getAlternationText()});
            player.m_240418_((Component)translatable, false);
        }
    }

    public static RegistryAccess getRegistryAccess(BlockEntity blockEntity) {
        RegistryAccess registryAccess = null;
        if (blockEntity.m_58904_() != null) {
            registryAccess = blockEntity.m_58904_().m_9598_();
        } else if (ClientCon.getUseLevel() != null) {
            registryAccess = ClientCon.getUseLevel().m_9598_();
        } else if (ServerLifecycleHooks.getCurrentServer() != null) {
            registryAccess = ServerLifecycleHooks.getCurrentServer().m_206579_();
        }
        return registryAccess;
    }

    public static void exportHumidityChart(Level level, String namespace) {
        Registry biomes = level.m_9598_().m_175515_(Registries.f_256952_);
        List collect = biomes.m_6579_().stream().sorted(Map.Entry.comparingByKey()).toList();
        for (Map.Entry e : collect) {
            if (!biomes.m_246971_((ResourceKey)e.getKey()).m_203656_(BiomeTags.f_215817_) || !((ResourceKey)e.getKey()).m_135782_().m_135827_().contains(namespace)) continue;
            Holder<Biome> biomeHolder = BiomeClimateManager.getHolder(level.m_9598_(), (Biome)e.getValue());
            double[] humidities = new double[24];
            for (int i = 0; i < 24; ++i) {
                SolarTerm solarTerm = SolarTerm.collectValues()[i];
                humidities[i] = EclipticUtil.getHumidityConstantFloat(solarTerm, biomeHolder, !level.m_5776_());
            }
            String biomeName = Component.m_237115_((String)Util.m_137492_((String)"biome", (ResourceLocation)((ResourceKey)e.getKey()).m_135782_())).getString();
            SolarTermHumidityChart chart = new SolarTermHumidityChart(biomeName, humidities);
            if (!new File("eclipticseasons").exists()) {
                new File("eclipticseasons").mkdir();
            }
            if (!new File("eclipticseasons/humid").exists()) {
                new File("eclipticseasons/humid").mkdir();
            }
            if (!new File("eclipticseasons/humid/" + namespace).exists()) {
                new File("eclipticseasons/humid/" + namespace).mkdir();
            }
            chart.exportToImage("%s/humid/%s/%s.png".formatted("eclipticseasons", namespace, biomeName), "png", 800, 400);
        }
    }
}

