/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.util.backport;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.util.backport.FakeStatePropertiesPredicate;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public record FakeBlockPredicate(Optional<HolderSet<Block>> blocks, Optional<FakeStatePropertiesPredicate> properties, Optional<NbtPredicate> nbt) {
    public static final Codec<FakeBlockPredicate> CODEC = RecordCodecBuilder.create(p_337342_ -> p_337342_.group((App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256747_).optionalFieldOf("blocks").forGetter(FakeBlockPredicate::blocks), (App)FakeStatePropertiesPredicate.CODEC.optionalFieldOf("state").forGetter(FakeBlockPredicate::properties), (App)ExtraCodecs.f_252400_.optionalFieldOf("nbt").forGetter(c -> c.nbt().map(NbtPredicate::m_57476_))).apply((Applicative)p_337342_, (holders, fakeStatePropertiesPredicate, jsonElement) -> new FakeBlockPredicate((Optional<HolderSet<Block>>)holders, (Optional<FakeStatePropertiesPredicate>)fakeStatePropertiesPredicate, jsonElement.map(NbtPredicate::m_57481_))));

    public FakeBlockPredicate(HolderSet<Block> blockHolderSet) {
        this(blockHolderSet, Optional.empty());
    }

    public FakeBlockPredicate(HolderSet<Block> blockHolderSet, Optional<FakeStatePropertiesPredicate> properties) {
        this(Optional.of(blockHolderSet), properties, Optional.empty());
    }

    public FakeBlockPredicate(Optional<HolderSet<Block>> blocks, Optional<FakeStatePropertiesPredicate> properties) {
        this(blocks, properties, Optional.empty());
    }

    public boolean matches(BlockState state) {
        return !(!this.blocks.isEmpty() && !state.m_204341_(this.blocks.get()) || !this.properties.isEmpty() && !this.properties.get().matches(state));
    }

    public static boolean matchesBlockEntity(LevelReader level, @Nullable BlockEntity blockEntity, NbtPredicate nbtPredicate) {
        return blockEntity != null && nbtPredicate.m_57483_((Tag)blockEntity.m_187480_());
    }

    public boolean matches(Level level, BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return false;
        }
        return this.matches(level.m_8055_(pos)) && (this.nbt.isEmpty() || FakeBlockPredicate.matchesBlockEntity((LevelReader)level, level.m_7702_(pos), this.nbt.get()));
    }

    public HolderSet<Block> getBlocks() {
        return this.blocks.orElseGet(() -> HolderSet.m_205809_((Holder[])new Holder[0]));
    }

    public static class Builder {
        private Optional<HolderSet<Block>> blocks = Optional.empty();
        private Optional<FakeStatePropertiesPredicate> properties = Optional.empty();

        private Builder() {
        }

        public static Builder block() {
            return new Builder();
        }

        public Builder of(Block ... blocks) {
            this.blocks = Optional.of(HolderSet.m_205806_(Block::m_204297_, (Object[])blocks));
            return this;
        }

        public Builder of(TagKey<Block> tag) {
            this.blocks = Optional.of(BuiltInRegistries.f_256975_.m_203561_(tag));
            return this;
        }

        public Builder setProperties(FakeStatePropertiesPredicate.Builder properties) {
            this.properties = properties.build();
            return this;
        }

        public FakeBlockPredicate build() {
            return new FakeBlockPredicate(this.blocks, this.properties);
        }
    }
}

