/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.util.backport;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;

public record FakeStatePropertiesPredicate(List<PropertyMatcher> properties) {
    private static final Codec<List<PropertyMatcher>> PROPERTIES_CODEC = Codec.unboundedMap((Codec)Codec.STRING, ValueMatcher.CODEC).xmap(map -> map.entrySet().stream().map(p_297914_ -> new PropertyMatcher((String)p_297914_.getKey(), (ValueMatcher)p_297914_.getValue())).toList(), p_297915_ -> p_297915_.stream().collect(Collectors.toMap(PropertyMatcher::name, PropertyMatcher::valueMatcher)));
    public static final Codec<FakeStatePropertiesPredicate> CODEC = PROPERTIES_CODEC.xmap(FakeStatePropertiesPredicate::new, FakeStatePropertiesPredicate::properties);

    public <S extends StateHolder<?, S>> boolean matches(StateDefinition<?, S> properties, S targetProperty) {
        for (PropertyMatcher statepropertiespredicate$propertymatcher : this.properties) {
            if (statepropertiespredicate$propertymatcher.match(properties, targetProperty)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(BlockState state) {
        return this.matches(state.m_60734_().m_49965_(), state);
    }

    record PropertyMatcher(String name, ValueMatcher valueMatcher) {
        public <S extends StateHolder<?, S>> boolean match(StateDefinition<?, S> properties, S propertyToMatch) {
            Property property = properties.m_61081_(this.name);
            return property != null && this.valueMatcher.match(propertyToMatch, property);
        }

        public Optional<String> checkState(StateDefinition<?, ?> state) {
            Property property = state.m_61081_(this.name);
            return property != null ? Optional.empty() : Optional.of(this.name);
        }
    }

    static interface ValueMatcher {
        public static final Codec<ValueMatcher> CODEC = Codec.either(ExactMatcher.CODEC, RangedMatcher.CODEC).xmap(either -> (ValueMatcher)either.map(Function.identity(), Function.identity()), p_299089_ -> {
            if (p_299089_ instanceof ExactMatcher) {
                ExactMatcher statepropertiespredicate$exactmatcher = (ExactMatcher)p_299089_;
                return Either.left((Object)statepropertiespredicate$exactmatcher);
            }
            if (p_299089_ instanceof RangedMatcher) {
                RangedMatcher statepropertiespredicate$rangedmatcher = (RangedMatcher)p_299089_;
                return Either.right((Object)statepropertiespredicate$rangedmatcher);
            }
            throw new UnsupportedOperationException();
        });

        public <T extends Comparable<T>> boolean match(StateHolder<?, ?> var1, Property<T> var2);
    }

    record RangedMatcher(Optional<String> minValue, Optional<String> maxValue) implements ValueMatcher
    {
        public static final Codec<RangedMatcher> CODEC = RecordCodecBuilder.create(p_337397_ -> p_337397_.group((App)Codec.STRING.optionalFieldOf("min").forGetter(RangedMatcher::minValue), (App)Codec.STRING.optionalFieldOf("max").forGetter(RangedMatcher::maxValue)).apply((Applicative)p_337397_, RangedMatcher::new));

        @Override
        public <T extends Comparable<T>> boolean match(StateHolder<?, ?> stateHolder, Property<T> property) {
            Optional optional1;
            Optional optional;
            Comparable t = stateHolder.m_61143_(property);
            if (this.minValue.isPresent() && ((optional = property.m_6215_(this.minValue.get())).isEmpty() || t.compareTo((Comparable)optional.get()) < 0)) {
                return false;
            }
            return !this.maxValue.isPresent() || !(optional1 = property.m_6215_(this.maxValue.get())).isEmpty() && t.compareTo((Comparable)optional1.get()) <= 0;
        }
    }

    record ExactMatcher(String value) implements ValueMatcher
    {
        public static final Codec<ExactMatcher> CODEC = Codec.STRING.xmap(ExactMatcher::new, ExactMatcher::value);

        @Override
        public <T extends Comparable<T>> boolean match(StateHolder<?, ?> p_298379_, Property<T> p_299294_) {
            Comparable t = p_298379_.m_61143_(p_299294_);
            Optional optional = p_299294_.m_6215_(this.value);
            return optional.isPresent() && t.compareTo((Comparable)optional.get()) == 0;
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<PropertyMatcher> matchers = ImmutableList.builder();

        private Builder() {
        }

        public static Builder properties() {
            return new Builder();
        }

        public Builder hasProperty(Property<?> property, Object value) {
            this.matchers.add((Object)new PropertyMatcher(property.m_61708_(), new ExactMatcher(value.toString())));
            return this;
        }

        public Builder hasProperty(Property<?> property, StringRepresentable value) {
            this.matchers.add((Object)new PropertyMatcher(property.m_61708_(), new ExactMatcher(value.m_7912_())));
            return this;
        }

        public Optional<FakeStatePropertiesPredicate> build() {
            return Optional.of(new FakeStatePropertiesPredicate((List<PropertyMatcher>)this.matchers.build()));
        }
    }
}

